/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.openjdk.common.BuildUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModuleDescription {
    public final String name;
    public final List<Dependency> depend;
    public final Map<String, List<String>> exports;
    private static final Map<URI, ModuleRepository> jdkRoot2Repository = new HashMap<URI, ModuleRepository>();
    private static final Pattern MODULE = Pattern.compile("module\\s+(?<modulename>([a-zA-Z0-9]+\\.)*[a-zA-Z0-9]+)");
    private static final Pattern REQUIRES = Pattern.compile("requires\\s+(?<flags>(transitive\\s+|public\\s+|static\\s+)*)(?<dependency>([a-zA-Z0-9]+\\.)*[a-zA-Z0-9]+)\\s*;");
    private static final Pattern EXPORTS = Pattern.compile("exports\\s+([^;]*?\\\\s+)?(?<package>([a-zA-Z0-9]+\\.)*[a-zA-Z0-9]+)(\\s+to\\s+(?<to>([a-zA-Z0-9]+\\.)*[a-zA-Z0-9]+(\\s*,\\s*([a-zA-Z0-9]+\\.)*[a-zA-Z0-9]+)*))?\\s*;");

    public ModuleDescription(String name, List<Dependency> depend, Map<String, List<String>> exports) {
        this.name = name;
        this.depend = depend;
        this.exports = exports;
    }

    public String toString() {
        return "ModuleDescription{name=" + this.name + ", depend=" + String.valueOf(this.depend) + ", exports=" + String.valueOf(this.exports) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleRepository getModules(FileObject project) throws Exception {
        Pair<FileObject, Pair<Boolean, Boolean>> jdkRootAndType = ModuleDescription.findJDKRoot(project);
        if (jdkRootAndType == null) {
            return null;
        }
        FileObject jdkRoot = (FileObject)jdkRootAndType.first();
        Class<ModuleDescription> clazz = ModuleDescription.class;
        synchronized (ModuleDescription.class) {
            boolean hasModuleInfos;
            List<ModuleDescription> moduleDescriptions;
            ModuleRepository repository = jdkRoot2Repository.get(jdkRoot.toURI());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (repository != null) {
                return repository;
            }
            FileObject modulesXML = BuildUtils.getFileObject(jdkRoot, "modules.xml");
            if (modulesXML != null) {
                moduleDescriptions = new ArrayList<ModuleDescription>();
                ModuleDescription.readModulesXml(modulesXML, moduleDescriptions);
                ModuleDescription.readModulesXml(BuildUtils.getFileObject(jdkRoot, "closed/modules.xml"), moduleDescriptions);
                hasModuleInfos = false;
            } else {
                moduleDescriptions = ModuleDescription.readModuleInfos(jdkRoot);
                hasModuleInfos = true;
            }
            if (moduleDescriptions.isEmpty()) {
                return null;
            }
            Class<ModuleDescription> clazz2 = ModuleDescription.class;
            synchronized (ModuleDescription.class) {
                repository = new ModuleRepository(jdkRoot, hasModuleInfos, (Boolean)((Pair)jdkRootAndType.second()).first(), (Boolean)((Pair)jdkRootAndType.second()).second(), moduleDescriptions);
                jdkRoot2Repository.put(jdkRoot.toURI(), repository);
                // ** MonitorExit[var7_9] (shouldn't be in output)
                return repository;
            }
        }
    }

    public static synchronized ModuleRepository getModuleRepository(URI forURI) {
        return jdkRoot2Repository.get(forURI);
    }

    private static Pair<FileObject, Pair<Boolean, Boolean>> findJDKRoot(FileObject projectDirectory) {
        if (BuildUtils.getFileObject(projectDirectory, "../../../open/src/java.base/share/classes/module-info.java") != null && BuildUtils.getFileObject(projectDirectory, "../../../open/src/java.base/share/classes/module-info.java") != null && BuildUtils.getFileObject(projectDirectory, "../../../open/src/java.compiler/share/classes/module-info.java") != null) {
            return Pair.of((Object)BuildUtils.getFileObject(projectDirectory, "../../.."), (Object)Pair.of((Object)true, (Object)true));
        }
        if (BuildUtils.getFileObject(projectDirectory, "../../src/java.base/share/classes/module-info.java") != null && BuildUtils.getFileObject(projectDirectory, "../../src/java.compiler/share/classes/module-info.java") != null) {
            return Pair.of((Object)BuildUtils.getFileObject(projectDirectory, "../.."), (Object)Pair.of((Object)true, (Object)false));
        }
        if (BuildUtils.getFileObject(projectDirectory, "../../../modules.xml") != null || BuildUtils.getFileObject(projectDirectory, "../../../jdk/src/java.base/share/classes/module-info.java") != null && BuildUtils.getFileObject(projectDirectory, "../../../langtools/src/java.compiler/share/classes/module-info.java") != null) {
            return Pair.of((Object)BuildUtils.getFileObject(projectDirectory, "../../.."), (Object)Pair.of((Object)false, (Object)false));
        }
        if (BuildUtils.getFileObject(projectDirectory, "../../../../modules.xml") != null || BuildUtils.getFileObject(projectDirectory, "../../../../jdk/src/java.base/share/classes/module-info.java") != null && BuildUtils.getFileObject(projectDirectory, "../../../langtools/src/java.compiler/share/classes/module-info.java") != null) {
            return Pair.of((Object)BuildUtils.getFileObject(projectDirectory, "../../../.."), (Object)Pair.of((Object)false, (Object)false));
        }
        return null;
    }

    private static void readModulesXml(FileObject modulesXML, List<ModuleDescription> moduleDescriptions) throws SAXException, IOException {
        if (modulesXML == null) {
            return;
        }
        try (InputStream in = modulesXML.getInputStream();){
            Document doc = XMLUtil.parse((InputSource)new InputSource(in), (boolean)false, (boolean)true, null, null);
            NodeList modules = doc.getDocumentElement().getElementsByTagName("module");
            for (int i = 0; i < modules.getLength(); ++i) {
                moduleDescriptions.add(ModuleDescription.parseModule((Element)modules.item(i)));
            }
        }
    }

    private static ModuleDescription parseModule(Element moduleEl) {
        NodeList children = moduleEl.getChildNodes();
        String name = null;
        ArrayList<Dependency> depend = new ArrayList<Dependency>();
        HashMap exports = new HashMap();
        block18: for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element childEl = (Element)child;
            switch (childEl.getLocalName()) {
                case "name": {
                    name = childEl.getTextContent();
                    continue block18;
                }
                case "depend": {
                    depend.add(new Dependency(childEl.getTextContent(), "true".equals(childEl.getAttribute("re-exports")), false));
                    continue block18;
                }
                case "export": {
                    String exported = null;
                    ArrayList<String> exportedTo = null;
                    NodeList exportChildren = childEl.getChildNodes();
                    block19: for (int j = 0; j < exportChildren.getLength(); ++j) {
                        Node exportChild = exportChildren.item(j);
                        if (exportChild.getNodeType() != 1) continue;
                        switch (exportChild.getLocalName()) {
                            case "name": {
                                exported = exportChild.getTextContent();
                                continue block19;
                            }
                            case "to": {
                                if (exportedTo == null) {
                                    exportedTo = new ArrayList<String>();
                                }
                                exportedTo.add(exportChild.getTextContent());
                            }
                        }
                    }
                    exports.put(exported, exportedTo != null ? Collections.unmodifiableList(exportedTo) : null);
                }
            }
        }
        return new ModuleDescription(name, Collections.unmodifiableList(depend), Collections.unmodifiableMap(exports));
    }

    private static List<ModuleDescription> readModuleInfos(FileObject jdkRoot) throws Exception {
        ArrayList<ModuleDescription> result = new ArrayList<ModuleDescription>();
        LinkedList<FileObject> todo = new LinkedList<FileObject>();
        todo.add(jdkRoot);
        while (!todo.isEmpty()) {
            FileObject current = (FileObject)todo.remove(0);
            if (".hg".equals(current.getNameExt()) || "build".equals(current.getNameExt()) && jdkRoot.equals(current.getParent())) continue;
            FileObject moduleInfo = ModuleDescription.getModuleInfo(current);
            if (moduleInfo != null) {
                FileObject srcDir;
                ModuleDescription module = ModuleDescription.parseModuleInfo(moduleInfo);
                if (module != null) {
                    result.add(module);
                }
                if ((srcDir = current.getParent()) != null && srcDir.getNameExt().equals("src")) continue;
            }
            if (BuildUtils.getFileObject(current, "TEST.ROOT") != null) continue;
            todo.addAll(Arrays.asList(current.getChildren()));
        }
        return result;
    }

    private static FileObject getModuleInfo(FileObject project) {
        for (FileObject c : project.getChildren()) {
            FileObject moduleInfo = BuildUtils.getFileObject(c, "classes/module-info.java");
            if (moduleInfo == null) continue;
            return moduleInfo;
        }
        return null;
    }

    private static ModuleDescription parseModuleInfo(FileObject f) throws IOException {
        try (InputStreamReader r = new InputStreamReader(f.getInputStream());){
            ModuleDescription desc = ModuleDescription.parseModuleInfo(r);
            if (desc == null || !desc.name.equals(BuildUtils.getFileObject(f, "../../..").getNameExt())) {
                ModuleDescription moduleDescription = null;
                return moduleDescription;
            }
            ModuleDescription moduleDescription = desc;
            return moduleDescription;
        }
    }

    static ModuleDescription parseModuleInfo(Reader r) throws IOException {
        TokenHierarchy th = TokenHierarchy.create((Reader)r, (Language)JavaTokenId.language(), EnumSet.of(JavaTokenId.BLOCK_COMMENT, new JavaTokenId[]{JavaTokenId.ERROR, JavaTokenId.INVALID_COMMENT_END, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.STRING_LITERAL}), (InputAttributes)new InputAttributes());
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        ts.moveStart();
        StringBuilder content = new StringBuilder();
        while (ts.moveNext()) {
            if (ts.token().id() == JavaTokenId.WHITESPACE) {
                content.append(' ');
                continue;
            }
            content.append(ts.token().text());
        }
        Matcher moduleMatcher = MODULE.matcher(content);
        if (!moduleMatcher.find()) {
            return null;
        }
        String moduleName = moduleMatcher.group("modulename");
        ArrayList<Dependency> depends = new ArrayList<Dependency>();
        boolean hasJavaBaseDependency = false;
        Matcher requiresMatcher = REQUIRES.matcher(content);
        while (requiresMatcher.find()) {
            String depName = requiresMatcher.group("dependency");
            boolean isPublic = false;
            boolean isStatic = false;
            String flags = requiresMatcher.group("flags");
            if (flags != null) {
                isPublic = flags.contains("transitive") || flags.contains("public");
                isStatic = flags.contains("static");
            }
            depends.add(new Dependency(depName, isPublic, isStatic));
            hasJavaBaseDependency |= depName.equals("java.base");
        }
        if (!hasJavaBaseDependency && !"java.base".equals(moduleName)) {
            depends.listIterator().add(new Dependency("java.base", false, false));
        }
        LinkedHashMap<String, List<String>> exports = new LinkedHashMap<String, List<String>>();
        Matcher exportsMatcher = EXPORTS.matcher(content);
        while (exportsMatcher.find()) {
            String pack = exportsMatcher.group("package");
            String to = exportsMatcher.group("to");
            List<String> toModule = to != null ? Arrays.asList(to.split("\\s*,\\s*")) : null;
            exports.put(pack, toModule);
        }
        return new ModuleDescription(moduleName, depends, exports);
    }

    public static class ModuleRepository {
        private final Set<Project> openProjects = new HashSet<Project>();
        private final FileObject root;
        private final boolean hasModuleInfos;
        private final boolean consolidatedRepository;
        private final boolean explicitOpen;
        public final List<ModuleDescription> modules;

        private ModuleRepository(FileObject root, boolean hasModuleInfos, boolean consolidatedRepository, boolean explicitOpen, List<ModuleDescription> modules) {
            this.root = root;
            this.hasModuleInfos = hasModuleInfos;
            this.consolidatedRepository = consolidatedRepository;
            this.explicitOpen = explicitOpen;
            this.modules = modules;
        }

        public FileObject getJDKRoot() {
            return this.root;
        }

        public ModuleDescription findModule(String moduleName) {
            for (ModuleDescription md : this.modules) {
                if (!md.name.equals(moduleName)) continue;
                return md;
            }
            return null;
        }

        public FileObject findModuleRoot(String moduleName) {
            if (this.consolidatedRepository) {
                FileObject module;
                if (this.explicitOpen) {
                    module = BuildUtils.getFileObject(this.root, "open/src/" + moduleName);
                    if (module == null) {
                        module = BuildUtils.getFileObject(this.root, "closed/src/" + moduleName);
                    }
                } else {
                    module = BuildUtils.getFileObject(this.root, "src/" + moduleName);
                }
                if (module != null && module.isFolder()) {
                    return module;
                }
            } else {
                for (FileObject repo : this.root.getChildren()) {
                    FileObject module = BuildUtils.getFileObject(repo, "src/" + moduleName);
                    if (module == null) {
                        module = BuildUtils.getFileObject(repo, "src/closed/" + moduleName);
                    }
                    if (module == null || !module.isFolder() || !this.validate(repo, module)) continue;
                    return module;
                }
            }
            return null;
        }

        private boolean validate(FileObject repo, FileObject project) {
            if (this.hasModuleInfos) {
                return ModuleDescription.getModuleInfo(project) != null;
            }
            switch (project.getNameExt()) {
                case "java.base": {
                    return repo.getName().equals("jdk");
                }
                case "java.corba": {
                    return repo.getName().equals("corba");
                }
                case "jdk.compiler": {
                    return repo.getName().equals("langtools");
                }
                case "jdk.dev": {
                    return repo.getName().equals("langtools");
                }
            }
            return true;
        }

        public List<String> moduleTests(String moduleName) {
            String[] stringArray;
            if (!this.consolidatedRepository) {
                switch (moduleName) {
                    case "java.base": {
                        return List.of("${jdkRoot}/jdk/test/");
                    }
                    case "java.compiler": {
                        return List.of("${jdkRoot}/langtools/test/");
                    }
                    case "java.xml": {
                        return List.of("${jdkRoot}/jaxp/test/");
                    }
                    case "jdk.scripting.nashorn": {
                        return List.of("${jdkRoot}/nashorn/test/");
                    }
                }
                return List.of();
            }
            ArrayList<String> result = new ArrayList<String>();
            if (this.explicitOpen) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "open/";
                stringArray = stringArray2;
                stringArray2[1] = "closed/";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "";
            }
            block24: for (String dir : stringArray) {
                switch (moduleName) {
                    case "java.base": {
                        result.add("${jdkRoot}/" + dir + "test/jdk/");
                        result.add("${jdkRoot}/" + dir + "test/hotspot/");
                        result.add("${jdkRoot}/" + dir + "test/lib/");
                        continue block24;
                    }
                    case "java.compiler": {
                        result.add("${jdkRoot}/" + dir + "test/langtools/");
                        continue block24;
                    }
                    case "java.xml": {
                        result.add("${jdkRoot}/" + dir + "test/jaxp/");
                        continue block24;
                    }
                    case "jdk.scripting.nashorn": {
                        result.add("${jdkRoot}/" + dir + "test/nashorn/");
                    }
                }
            }
            return result;
        }

        public Collection<String> allDependencies(ModuleDescription module) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            this.allDependencies(module, result, false);
            return result;
        }

        private void allDependencies(ModuleDescription module, Set<String> result, boolean transitiveOnly) {
            for (Dependency dep : module.depend) {
                if (transitiveOnly && !dep.requiresPublic) continue;
                ModuleDescription md = this.findModule(dep.moduleName);
                if (md != null) {
                    this.allDependencies(md, result, true);
                }
                result.add(dep.moduleName);
            }
        }

        public boolean isConsolidatedRepo() {
            return this.consolidatedRepository;
        }

        public synchronized void projectOpened(Project opened) {
            this.openProjects.add(opened);
        }

        public synchronized void projectClosed(Project closed) {
            this.openProjects.remove(closed);
        }

        public synchronized boolean isAnyProjectOpened() {
            return !this.openProjects.isEmpty();
        }
    }

    public static final class Dependency {
        public final String moduleName;
        public final boolean requiresPublic;
        public final boolean requiresStatic;

        public Dependency(String moduleName, boolean requiresPublic, boolean requiresStatic) {
            this.moduleName = moduleName;
            this.requiresPublic = requiresPublic;
            this.requiresStatic = requiresStatic;
        }
    }
}

