/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger;

import javax.swing.SwingUtilities;
import org.netbeans.modules.lsp.client.debugger.DebuggerAnnotation;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public final class DAPStackTraceAnnotationHolder {
    private static DebuggerAnnotation[] currentAnnotations;

    private DAPStackTraceAnnotationHolder() {
    }

    static synchronized void markCurrent(Annotatable[] annotatables) {
        DAPStackTraceAnnotationHolder.unmarkCurrent();
        int i = 0;
        int k = annotatables.length;
        DebuggerAnnotation[] annotations = new DebuggerAnnotation[k];
        annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation("CurrentPCLinePart", annotatables[i]) : new DebuggerAnnotation("CurrentPC", annotatables[i]);
        for (i = 1; i < k; ++i) {
            annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation("CallSite", annotatables[i]) : new DebuggerAnnotation("CallSite", annotatables[i]);
        }
        currentAnnotations = annotations;
        DAPStackTraceAnnotationHolder.showLine(annotatables);
    }

    static synchronized void unmarkCurrent() {
        if (currentAnnotations != null) {
            int k = currentAnnotations.length;
            for (int i = 0; i < k; ++i) {
                currentAnnotations[i].detach();
            }
            currentAnnotations = null;
        }
    }

    public static void showLine(final Annotatable[] a) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (a[0] instanceof Line) {
                    ((Line)a[0]).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                } else if (a[0] instanceof Line.Part) {
                    ((Line.Part)a[0]).getLine().show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                } else {
                    throw new InternalError(a[0].toString());
                }
            }
        });
    }

    public static boolean contains(Object currentLine, Line line) {
        if (currentLine == null) {
            return false;
        }
        Annotatable[] a = (Annotatable[])currentLine;
        int k = a.length;
        for (int i = 0; i < k; ++i) {
            if (a[i].equals(line)) {
                return true;
            }
            if (!(a[i] instanceof Line.Part) || !((Line.Part)a[i]).getLine().equals(line)) continue;
            return true;
        }
        return false;
    }
}

