/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldInfo;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;

public class FoldManagerImpl
implements FoldManager,
LSPBindings.BackgroundTask {
    private FoldOperation operation;
    private FileObject file;
    private static final Logger LOG = Logger.getLogger(FoldManagerImpl.class.getName());

    public void init(FoldOperation operation) {
        this.operation = operation;
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.operation.getHierarchy().getComponent().getDocument();
        this.file = NbEditorUtilities.getFileObject((Document)doc);
        if (this.file == null) {
            return;
        }
        LSPBindings.addBackgroundTask(this.file, this);
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void release() {
        if (this.file != null) {
            LSPBindings.removeBackgroundTask(this.file, this);
            this.file = null;
        }
    }

    @Override
    public void run(LSPBindings bindings, FileObject file) {
        StyledDocument doc;
        EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
        StyledDocument styledDocument = doc = ec != null ? ec.getDocument() : null;
        if (doc == null) {
            return;
        }
        List<FoldingRange> ranges = FoldManagerImpl.computeRanges(bindings, file);
        List<FoldInfo> infos = FoldManagerImpl.computeInfos(doc, ranges);
        SwingUtilities.invokeLater(() -> doc.render(() -> this.operation.getHierarchy().render(() -> {
            try {
                this.operation.update((Collection)infos, null, null);
            }
            catch (BadLocationException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        })));
    }

    static List<FoldInfo> computeInfos(Document doc, List<FoldingRange> ranges) {
        HashSet<FoldingRangeInfo2> foldingRangesSeen = new HashSet<FoldingRangeInfo2>();
        ArrayList<FoldInfo> infos = new ArrayList<FoldInfo>();
        if (ranges != null) {
            for (FoldingRange r : ranges) {
                FoldType foldType;
                FoldingRangeInfo2 fri2;
                int end;
                int start;
                if (r.getStartCharacter() == null) {
                    int endCharacter = Utils.getEndCharacter(doc, r.getStartLine());
                    start = Utils.getOffset(doc, new Position(r.getStartLine(), endCharacter));
                } else {
                    start = Utils.getOffset(doc, new Position(r.getStartLine(), r.getStartCharacter()));
                }
                if (r.getEndCharacter() == null) {
                    int endCharacter = Utils.getEndCharacter(doc, r.getEndLine());
                    end = Utils.getOffset(doc, new Position(r.getEndLine(), endCharacter));
                } else {
                    end = Utils.getOffset(doc, new Position(r.getEndLine(), r.getEndCharacter()));
                }
                if (foldingRangesSeen.contains(fri2 = new FoldingRangeInfo2(start, end, foldType = "comment".equals(r.getKind()) ? FoldType.COMMENT : ("imports".equals(r.getKind()) ? FoldType.IMPORT : FoldType.CODE_BLOCK)))) continue;
                infos.add(FoldInfo.range((int)start, (int)end, (FoldType)foldType));
                foldingRangesSeen.add(fri2);
            }
        }
        return infos;
    }

    static List<FoldingRange> computeRanges(LSPBindings bindings, FileObject file) {
        if (bindings.getInitResult() != null && bindings.getInitResult().getCapabilities() != null && bindings.getInitResult().getCapabilities().getFoldingRangeProvider() != null) {
            try {
                return bindings.getTextDocumentService().foldingRange(new FoldingRangeRequestParams(new TextDocumentIdentifier(Utils.toURI(file)))).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        return Collections.emptyList();
    }

    static class FoldingRangeInfo2 {
        private int start;
        private int end;
        private FoldType type;

        public FoldingRangeInfo2(int start, int end, FoldType type) {
            this.start = start;
            this.end = end;
            this.type = type;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public FoldType getType() {
            return this.type;
        }

        public int hashCode() {
            int hash = 3;
            hash = 23 * hash + this.start;
            hash = 23 * hash + this.end;
            hash = 23 * hash + Objects.hashCode(this.type);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FoldingRangeInfo2 other = (FoldingRangeInfo2)obj;
            if (this.start != other.start) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            return Objects.equals(this.type, other.type);
        }
    }

    public static final class FactoryImpl
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new FoldManagerImpl();
        }
    }
}

