/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.completion;

import java.util.Arrays;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.twig.editor.lexer.TwigBlockTokenId;
import org.netbeans.modules.php.twig.editor.lexer.TwigLexerUtils;
import org.netbeans.modules.php.twig.editor.lexer.TwigVariableTokenId;
import org.netbeans.modules.php.twig.editor.parsing.TwigParserResult;

public final class TwigCompletionContextFinder {
    private static final List<Object[]> FILTER_TOKEN_CHAINS = Arrays.asList({ValuedTokenId.FILTER_PUNCTUATION_TOKEN_BLOCK}, {ValuedTokenId.FILTER_PUNCTUATION_TOKEN_BLOCK, TwigBlockTokenId.T_TWIG_NAME}, {ValuedTokenId.FILTER_PUNCTUATION_TOKEN_VAR_IABLE}, {ValuedTokenId.FILTER_PUNCTUATION_TOKEN_VAR_IABLE, TwigVariableTokenId.T_TWIG_NAME}, {ValuedTokenId.FILTER_TAG_TOKEN}, {ValuedTokenId.FILTER_TAG_TOKEN, TwigBlockTokenId.T_TWIG_WHITESPACE}, {ValuedTokenId.FILTER_TAG_TOKEN, TwigBlockTokenId.T_TWIG_WHITESPACE, TwigBlockTokenId.T_TWIG_NAME});

    private TwigCompletionContextFinder() {
    }

    public static CompletionContext find(TwigParserResult parserResult, int offset) {
        assert (parserResult != null);
        CompletionContext result = CompletionContext.NONE;
        TokenSequence<? extends TokenId> tokenSequence = TwigLexerUtils.getTwigMarkupTokenSequence(parserResult.getSnapshot(), offset);
        if (tokenSequence != null) {
            tokenSequence.move(offset);
            if (!tokenSequence.moveNext()) {
                tokenSequence.movePrevious();
            }
            result = TwigCompletionContextFinder.findContext(tokenSequence);
        }
        return result;
    }

    private static CompletionContext findContext(TokenSequence<? extends TokenId> tokenSequence) {
        Token token;
        CompletionContext result = CompletionContext.ALL;
        while ((token = tokenSequence.token()) != null) {
            TokenId tokenId = token.id();
            if (TwigBlockTokenId.T_TWIG_OTHER.equals(tokenId) || TwigVariableTokenId.T_TWIG_OTHER.equals(tokenId)) {
                result = CompletionContext.NONE;
                break;
            }
            if (TwigCompletionContextFinder.acceptTokenChains(tokenSequence, FILTER_TOKEN_CHAINS, true)) {
                result = CompletionContext.FILTER;
                break;
            }
            if (tokenId instanceof TwigBlockTokenId) {
                result = CompletionContext.BLOCK;
                break;
            }
            if (tokenId instanceof TwigVariableTokenId) {
                result = CompletionContext.VARIABLE;
                break;
            }
            if (tokenSequence.movePrevious()) continue;
        }
        return result;
    }

    private static boolean acceptTokenChains(TokenSequence tokenSequence, List<Object[]> tokenIdChains, boolean movePrevious) {
        boolean result = false;
        for (Object[] tokenIDChain : tokenIdChains) {
            if (!TwigCompletionContextFinder.acceptTokenChain(tokenSequence, tokenIDChain, movePrevious)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean acceptTokenChain(TokenSequence tokenSequence, Object[] tokenIdChain, boolean movePrevious) {
        int originalPosition = tokenSequence.offset();
        boolean accept = true;
        boolean moreTokens = movePrevious ? tokenSequence.movePrevious() : true;
        for (int i = tokenIdChain.length - 1; i >= 0; --i) {
            Object tokenId = tokenIdChain[i];
            if (!moreTokens) {
                accept = false;
                break;
            }
            if (tokenId instanceof TwigBlockTokenId || tokenId instanceof TwigVariableTokenId) {
                if (tokenSequence.token().id() == tokenId) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            if (tokenId instanceof ValuedTokenId) {
                ValuedTokenId valuedToken = (ValuedTokenId)((Object)tokenId);
                Token token = tokenSequence.token();
                if (token != null && valuedToken.getId().equals((Object)token.id()) && token.text().equals(valuedToken.getValue())) {
                    moreTokens = tokenSequence.movePrevious();
                    continue;
                }
                accept = false;
                break;
            }
            assert (false) : "Unsupported token type: " + tokenId.getClass().getName();
        }
        tokenSequence.move(originalPosition);
        tokenSequence.moveNext();
        return accept;
    }

    public static enum CompletionContext {
        VARIABLE,
        BLOCK,
        FILTER,
        NONE,
        ALL;

    }

    private static enum ValuedTokenId {
        FILTER_PUNCTUATION_TOKEN_BLOCK(TwigBlockTokenId.T_TWIG_PUNCTUATION, "|"),
        FILTER_PUNCTUATION_TOKEN_VAR_IABLE(TwigVariableTokenId.T_TWIG_PUNCTUATION, "|"),
        FILTER_TAG_TOKEN(TwigBlockTokenId.T_TWIG_TAG, "filter");

        private final TokenId id;
        private final String value;

        private ValuedTokenId(TokenId id, String value) {
            this.id = id;
            this.value = value;
        }

        public TokenId getId() {
            return this.id;
        }

        public String getValue() {
            return this.value;
        }
    }
}

