/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import javax.swing.text.BadLocationException;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.refactoring.AttributeValueFinder;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyChildFinder {
    private final XMLSyntaxSupport syntaxSupport;
    private final int start;
    private int foundOffset = -1;
    private String value;

    public PropertyChildFinder(XMLSyntaxSupport syntaxSupport, int start) {
        this.syntaxSupport = syntaxSupport;
        this.start = start;
    }

    public boolean find(String propertyName) throws BadLocationException {
        this.foundOffset = -1;
        this.value = null;
        SyntaxElement beanElement = this.syntaxSupport.getElementChain(this.start + 1);
        if (!this.syntaxSupport.isStartTag(beanElement)) {
            return false;
        }
        Node beanTag = beanElement.getNode();
        if (!"bean".equals(beanTag.getNodeName())) {
            return false;
        }
        NodeList nl = beanTag.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            String name;
            Node n = nl.item(i);
            if (!"property".equals(n.getNodeName()) || !StringUtils.hasText(name = SpringXMLConfigEditorUtils.getAttribute(n, "name")) || !propertyName.equals(name)) continue;
            AttributeValueFinder delegate = new AttributeValueFinder(this.syntaxSupport, this.syntaxSupport.getNodeOffset(n));
            boolean retVal = delegate.find("name");
            this.foundOffset = delegate.getFoundOffset();
            this.value = delegate.getValue();
            return retVal;
        }
        return false;
    }

    public int getFoundOffset() {
        return this.foundOffset;
    }

    public String getValue() {
        return this.value;
    }
}

