/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.debugger.jpda.ui.completion.ClassCompletionProvider;
import org.netbeans.modules.debugger.jpda.ui.completion.ClassSearchScopeType;
import org.netbeans.modules.debugger.jpda.ui.completion.ElementCompletionItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class FieldsCompletionProvider
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1) {
            return null;
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            protected void query(final CompletionResultSet resultSet, Document doc, int caretOffset) {
                String simpleClassName;
                String packageName;
                String text;
                if (caretOffset < 0) {
                    caretOffset = 0;
                }
                try {
                    text = doc.getText(0, caretOffset);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    text = "";
                }
                String className = (String)doc.getProperty("class-name");
                if (className == null) {
                    resultSet.finish();
                    return;
                }
                int dot = className.lastIndexOf(46);
                if (dot > 0) {
                    packageName = className.substring(0, dot + 1);
                    simpleClassName = className.substring(dot + 1);
                } else {
                    packageName = "";
                    simpleClassName = className;
                }
                Set<ClassSearchScopeType> scope = Collections.singleton(new ClassSearchScopeType(packageName));
                int n = text.length();
                ClasspathInfo cpi = ClassCompletionProvider.getClassPathInfo();
                ClassIndex classIndex = cpi.getClassIndex();
                Set declaredTypes = classIndex.getDeclaredTypes(simpleClassName, ClassIndex.NameKind.PREFIX, scope);
                ElementHandle theType = null;
                for (ElementHandle type : declaredTypes) {
                    if (!className.equals(type.getQualifiedName())) continue;
                    theType = type;
                    break;
                }
                if (theType != null) {
                    final ElementHandle type = theType;
                    final int caret = caretOffset;
                    try {
                        JavaSource.create((ClasspathInfo)cpi, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run(CompilationController cc) throws Exception {
                                TypeElement te = (TypeElement)type.resolve((CompilationInfo)cc);
                                List<? extends Element> enclosedElements = te.getEnclosedElements();
                                for (Element element : enclosedElements) {
                                    if (element.getKind() != ElementKind.FIELD) continue;
                                    ElementCompletionItem eci = new ElementCompletionItem(element.getSimpleName().toString(), element.getKind(), element.getModifiers(), caret);
                                    eci.setElementType(element.asType());
                                    resultSet.addItem((CompletionItem)eci);
                                }
                            }
                        }, true);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FieldsCompletionProvider.class.getName()).log(Level.CONFIG, className, ex);
                    }
                }
                resultSet.finish();
            }
        }, component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 1;
    }
}

