/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.actions.ActionsSynchronizer;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ui.actions.ToggleBreakpointActionProvider;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ClassBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.FieldBreakpointPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.MethodBreakpointPanel;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ToggleMethodFieldBreakpointAction
extends AbstractAction {
    private static final String[] BREAKPOINT_ANNOTATION_TYPES = new String[]{"Breakpoint_broken", "Breakpoint", "Breakpoint_stroke", "CondBreakpoint_broken", "CondBreakpoint", "CondBreakpoint_stroke", "DisabledBreakpoint", "DisabledCondBreakpoint", "DisabledBreakpoint_stroke", "ClassBreakpoint", "DisabledClassBreakpoint", "DisabledFieldBreakpoint", "DisabledMethodBreakpoint", "FieldBreakpoint", "MethodBreakpoint", "CurrentExpressionLine", "CurrentExpression"};
    private Object action;
    private RequestProcessor postponedToggleRP;

    public ToggleMethodFieldBreakpointAction() {
        this.setEnabled(true);
        this.putValue("default-action", true);
        this.putValue("supported-annotation-types", BREAKPOINT_ANNOTATION_TYPES);
    }

    public Object getAction() {
        return this.action;
    }

    @Override
    public Object getValue(String key) {
        if (key == "Name") {
            return NbBundle.getMessage(ToggleMethodFieldBreakpointAction.class, (String)"CTL_ToggleMethodFieldBreakpointAction");
        }
        return super.getValue(key);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.submitFieldOrMethodOrClassBreakpoint()) {
            DebuggerManager.getDebuggerManager().getActionsManager().postAction(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
        }
    }

    private synchronized RequestProcessor getPostponedToggleRP() {
        if (this.postponedToggleRP == null) {
            this.postponedToggleRP = new RequestProcessor("Postponed ToggleMethodFieldBreakpointAction", 1);
        }
        return this.postponedToggleRP;
    }

    static JPDADebugger getCurrentDebugger() {
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (session != null) {
            return (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
        }
        return null;
    }

    private boolean submitFieldOrMethodOrClassBreakpoint() {
        String methodSignature;
        String methodName;
        IllegalComponentStateException mex;
        IllegalComponentStateException fex;
        IllegalComponentStateException cex;
        IllegalComponentStateException cdex;
        final String[] classDeclaration = new String[]{null};
        final String[] className = new String[]{null};
        final String[] fieldName = new String[]{null};
        try {
            classDeclaration[0] = EditorContextBridge.getCurrentClassDeclaration();
            cdex = null;
        }
        catch (IllegalComponentStateException icsex) {
            cdex = icsex;
        }
        if (classDeclaration[0] == null) {
            try {
                className[0] = EditorContextBridge.getContext().getCurrentClassName();
                cex = null;
            }
            catch (IllegalComponentStateException icsex) {
                cex = icsex;
            }
            try {
                fieldName[0] = EditorContextBridge.getContext().getCurrentFieldName();
                fex = null;
            }
            catch (IllegalComponentStateException icsex) {
                fex = icsex;
            }
            if (fieldName[0] == null || fieldName[0].length() == 0) {
                String[] methodInfo;
                fieldName[0] = null;
                try {
                    methodInfo = EditorContextBridge.getContext().getCurrentMethodDeclaration();
                    mex = null;
                }
                catch (IllegalComponentStateException icsex) {
                    mex = icsex;
                    methodInfo = null;
                }
                if (methodInfo != null) {
                    methodName = methodInfo[0];
                    methodSignature = methodInfo[1];
                    if (methodInfo[2] != null) {
                        className[0] = methodInfo[2];
                    }
                } else {
                    if (mex == null) {
                        return false;
                    }
                    methodName = null;
                    methodSignature = null;
                }
            } else {
                mex = null;
                methodName = null;
                methodSignature = null;
            }
        } else {
            methodSignature = null;
            methodName = null;
            mex = null;
            fex = null;
            cex = null;
        }
        if (cdex != null || cex != null || fex != null || mex != null) {
            final int ln = EditorContextBridge.getContext().getCurrentLineNumber();
            final String url = EditorContextBridge.getContext().getCurrentURL();
            final IllegalComponentStateException[] exs = new IllegalComponentStateException[]{cdex, cex, fex, mex};
            final JPDADebugger debugger = ToggleMethodFieldBreakpointAction.getCurrentDebugger();
            if (debugger != null) {
                ActionsSynchronizer.get((JPDADebugger)debugger).actionScheduled(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
            }
            this.getPostponedToggleRP().post(new Runnable(){
                final /* synthetic */ ToggleMethodFieldBreakpointAction this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        LineBreakpoint lb;
                        String ms;
                        if (debugger != null) {
                            ActionsSynchronizer.get((JPDADebugger)debugger).actionStarts(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
                        }
                        String cdn = exs[0] != null ? exs[0].getMessage() : classDeclaration[0];
                        String cn = exs[1] != null ? exs[1].getMessage() : className[0];
                        String fn = exs[2] != null ? exs[2].getMessage() : fieldName[0];
                        String mn = exs[3] != null ? exs[3].getMessage() : methodName;
                        String string = ms = exs[3] != null ? exs[3].getLocalizedMessage() : methodSignature;
                        if (fn != null && fn.length() == 0) {
                            fn = null;
                        }
                        if (cdn != null) {
                            cn = cdn;
                            ms = null;
                            mn = null;
                            fn = null;
                        } else if (fn == null && mn == null) {
                            return;
                        }
                        if (this.this$0.submitFieldOrMethodOrClassBreakpoint(cn, fn, mn, ms, null, ln) && (lb = ToggleBreakpointActionProvider.findBreakpoint(url, ln)) != null) {
                            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)lb);
                        }
                    }
                    finally {
                        if (debugger != null) {
                            ActionsSynchronizer.get((JPDADebugger)debugger).actionEnds(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
                        }
                    }
                }
            });
            return false;
        }
        int ln = EditorContextBridge.getContext().getCurrentLineNumber();
        String url = EditorContextBridge.getContext().getCurrentURL();
        if (classDeclaration[0] != null) {
            return this.submitFieldOrMethodOrClassBreakpoint(classDeclaration[0], null, null, null, url, ln);
        }
        return this.submitFieldOrMethodOrClassBreakpoint(className[0], fieldName[0], methodName, methodSignature, url, ln);
    }

    private boolean submitFieldOrMethodOrClassBreakpoint(final String className, final String fieldName, final String methodName, final String methodSignature, String url, int line) {
        if (className == null) {
            return false;
        }
        Object b = fieldName != null ? ToggleMethodFieldBreakpointAction.findBreakpoint(className, fieldName) : (methodName != null ? ToggleMethodFieldBreakpointAction.findBreakpoint(className, methodName, methodSignature) : ToggleMethodFieldBreakpointAction.findBreakpoint(className));
        if (b == null && url != null) {
            b = ToggleBreakpointActionProvider.findBreakpoint(url, line);
        }
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        if (b != null) {
            d.removeBreakpoint((Breakpoint)b);
            return true;
        }
        final JPDADebugger debugger = ToggleMethodFieldBreakpointAction.getCurrentDebugger();
        if (debugger != null) {
            ActionsSynchronizer.get((JPDADebugger)debugger).actionScheduled(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
        }
        this.getPostponedToggleRP().post(new Runnable(){
            final /* synthetic */ ToggleMethodFieldBreakpointAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    FieldBreakpoint b;
                    if (debugger != null) {
                        ActionsSynchronizer.get((JPDADebugger)debugger).actionStarts(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
                    }
                    if (fieldName != null) {
                        b = FieldBreakpoint.create((String)className, (String)fieldName, (int)3);
                        b.setPrintText(NbBundle.getMessage(FieldBreakpointPanel.class, (String)"CTL_Field_Breakpoint_Print_Text"));
                    } else if (methodName != null) {
                        b = MethodBreakpoint.create((String)className, (String)methodName);
                        ((MethodBreakpoint)b).setMethodSignature(methodSignature);
                        b.setPrintText(NbBundle.getMessage(MethodBreakpointPanel.class, (String)"CTL_Method_Breakpoint_Print_Text"));
                    } else {
                        b = ClassLoadUnloadBreakpoint.create((String)className, (boolean)false, (int)3);
                        b.setPrintText(NbBundle.getMessage(ClassBreakpointPanel.class, (String)"CTL_Class_Breakpoint_Print_Text"));
                    }
                    DebuggerManager d = DebuggerManager.getDebuggerManager();
                    d.addBreakpoint((Breakpoint)b);
                }
                finally {
                    if (debugger != null) {
                        ActionsSynchronizer.get((JPDADebugger)debugger).actionEnds(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
                    }
                }
            }
        });
        return true;
    }

    static JPDABreakpoint getCurrentFieldMethodBreakpoint() {
        String className = EditorContextBridge.getContext().getCurrentClassName();
        String fieldName = EditorContextBridge.getContext().getCurrentFieldName();
        String methodName = null;
        String methodSignature = null;
        if (fieldName == null || fieldName.length() == 0) {
            fieldName = null;
            String[] methodInfo = EditorContextBridge.getContext().getCurrentMethodDeclaration();
            if (methodInfo != null) {
                methodName = methodInfo[0];
                methodSignature = methodInfo[1];
            } else {
                return null;
            }
        }
        Object b = fieldName != null ? ToggleMethodFieldBreakpointAction.findBreakpoint(className, fieldName) : ToggleMethodFieldBreakpointAction.findBreakpoint(className, methodName, methodSignature);
        return b;
    }

    private static ClassLoadUnloadBreakpoint findBreakpoint(String className) {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            int j;
            if (!(breakpoints[i] instanceof ClassLoadUnloadBreakpoint)) continue;
            ClassLoadUnloadBreakpoint cb = (ClassLoadUnloadBreakpoint)breakpoints[i];
            String[] classFilters = cb.getClassFilters();
            for (j = 0; j < classFilters.length && !ToggleMethodFieldBreakpointAction.match(className, classFilters[j]); ++j) {
            }
            if (j >= classFilters.length) continue;
            String[] exClassFilters = cb.getClassExclusionFilters();
            for (j = 0; j < exClassFilters.length; ++j) {
                if (!ToggleMethodFieldBreakpointAction.match(className, exClassFilters[j])) continue;
                j = -1;
                break;
            }
            if (j < 0) continue;
            return cb;
        }
        return null;
    }

    private static FieldBreakpoint findBreakpoint(String className, String fieldName) {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            FieldBreakpoint fb;
            if (!(breakpoints[i] instanceof FieldBreakpoint) || !(fb = (FieldBreakpoint)breakpoints[i]).getClassName().equals(className) || !fb.getFieldName().equals(fieldName)) continue;
            return fb;
        }
        return null;
    }

    private static MethodBreakpoint findBreakpoint(String className, String methodName, String methodSignature) {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpoints.length; ++i) {
            String signature;
            int j;
            if (!(breakpoints[i] instanceof MethodBreakpoint)) continue;
            MethodBreakpoint mb = (MethodBreakpoint)breakpoints[i];
            String[] classFilters = mb.getClassFilters();
            for (j = 0; j < classFilters.length && !ToggleMethodFieldBreakpointAction.match(className, classFilters[j]); ++j) {
            }
            if (j >= classFilters.length || !mb.getMethodName().equals(methodName) || (signature = mb.getMethodSignature()) != null && !ToggleMethodFieldBreakpointAction.egualMethodSignatures(signature, methodSignature)) continue;
            return mb;
        }
        return null;
    }

    private static boolean egualMethodSignatures(String s1, String s2) {
        int i = s1.lastIndexOf(")");
        if (i > 0) {
            s1 = s1.substring(0, i);
        }
        if ((i = s2.lastIndexOf(")")) > 0) {
            s2 = s2.substring(0, i);
        }
        return s1.equals(s2);
    }

    private static boolean match(String name, String pattern) {
        if (pattern.startsWith("*")) {
            return name.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return name.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return name.equals(pattern);
    }
}

