/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.ant.AntArtifactQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class AntArtifactQuery {
    private AntArtifactQuery() {
    }

    public static AntArtifact findArtifactFromFile(File file) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + String.valueOf(file) + " instead of " + String.valueOf(FileUtil.normalizeFile((File)file)));
        }
        for (AntArtifactQueryImplementation aaqi : Lookup.getDefault().lookupAll(AntArtifactQueryImplementation.class)) {
            AntArtifact artifact = aaqi.findArtifact(file);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    public static AntArtifact findArtifactByID(Project p, String id) {
        AntArtifactProvider prov = (AntArtifactProvider)p.getLookup().lookup(AntArtifactProvider.class);
        if (prov == null) {
            return null;
        }
        for (AntArtifact artifact : prov.getBuildArtifacts()) {
            if (!artifact.getID().equals(id)) continue;
            return artifact;
        }
        return null;
    }

    public static AntArtifact[] findArtifactsByType(Project p, String type) {
        AntArtifactProvider prov = (AntArtifactProvider)p.getLookup().lookup(AntArtifactProvider.class);
        if (prov == null) {
            return new AntArtifact[0];
        }
        AntArtifact[] artifacts = prov.getBuildArtifacts();
        ArrayList<AntArtifact> l = new ArrayList<AntArtifact>(artifacts.length);
        for (AntArtifact aa : artifacts) {
            if (!aa.getType().equals(type)) continue;
            l.add(aa);
        }
        return l.toArray(new AntArtifact[0]);
    }
}

