/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutable;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.composer.commands.Bundle;
import org.netbeans.modules.php.composer.options.ComposerOptions;
import org.netbeans.modules.php.composer.options.ComposerOptionsValidator;
import org.netbeans.modules.php.composer.output.model.SearchResult;
import org.netbeans.modules.php.composer.output.parsers.Parsers;
import org.netbeans.modules.php.composer.ui.options.ComposerOptionsPanelController;
import org.netbeans.modules.php.composer.util.ComposerUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class Composer {
    static final Logger LOGGER = Logger.getLogger(Composer.class.getName());
    public static final String COMPOSER_FILENAME = "composer.json";
    public static final List<String> COMPOSER_FILENAMES;
    private static final String COMPOSER = "composer";
    private static final String COMPOSER_PHAR = "composer.phar";
    private static final String COMPOSER_BAT = "composer.bat";
    private static final String INIT_COMMAND = "init";
    private static final String INSTALL_COMMAND = "install";
    private static final String UPDATE_COMMAND = "update";
    private static final String UPDATE_AUTOLOADER_COMMAND = "dump-autoload";
    private static final String REQUIRE_COMMAND = "require";
    private static final String RUN_SCRIPT_COMMAND = "run-script";
    private static final String VALIDATE_COMMAND = "validate";
    private static final String SELF_UPDATE_COMMAND = "self-update";
    private static final String SEARCH_COMMAND = "search";
    private static final String SHOW_COMMAND = "show";
    private static final String ANSI_PARAM = "--ansi";
    private static final String NO_ANSI_PARAM = "--no-ansi";
    private static final String NO_INTERACTION_PARAM = "--no-interaction";
    private static final String NAME_PARAM = "--name=%s";
    private static final String AUTHOR_PARAM = "--author=%s <%s>";
    private static final String DESCRIPTION_PARAM = "--description=%s";
    private static final String DEV_PARAM = "--dev";
    private static final String NO_DEV_PARAM = "--no-dev";
    private static final String ONLY_NAME_PARAM = "--only-name";
    private static final String ALL_PARAM = "--all";
    private static final List<String> DEFAULT_PARAMS;
    private final String composerPath;
    private volatile File workDir;

    public Composer(String composerPath) {
        this.composerPath = composerPath;
    }

    public static Composer getDefault() throws InvalidPhpExecutableException {
        String composerPath = ComposerOptions.getInstance().getComposerPath();
        String error = Composer.validate(composerPath);
        if (error != null) {
            throw new InvalidPhpExecutableException(error);
        }
        return new Composer(composerPath);
    }

    public static String validate(String composerPath) {
        return PhpExecutableValidator.validateCommand((String)composerPath, (String)Bundle.Composer_script_label());
    }

    public static boolean isValidOutput(String output) {
        return !output.startsWith("Warning:") && !output.startsWith("No composer.json found");
    }

    public Future<Integer> initIfNotPresent(PhpModule phpModule) {
        assert (phpModule != null);
        FileObject composerJson = this.getComposerJson(phpModule);
        if (composerJson != null && composerJson.isValid()) {
            return null;
        }
        return this.init(phpModule);
    }

    public Future<Integer> init(PhpModule phpModule) {
        assert (phpModule != null);
        FileObject composerJson = this.getComposerJson(phpModule);
        if (composerJson != null && composerJson.isValid() && !this.userConfirmation(phpModule.getDisplayName(), Bundle.Composer_file_exists())) {
            return null;
        }
        ComposerOptions options = ComposerOptions.getInstance();
        ValidationResult result = new ComposerOptionsValidator().validate(options).getResult();
        if (!result.isFaultless()) {
            UiUtils.showOptions((String)"FrameworksAndTools/Composer");
            return null;
        }
        List<String> params = Arrays.asList(String.format(NAME_PARAM, this.getInitName(options.getVendor(), phpModule.getName())), String.format(AUTHOR_PARAM, options.getAuthorName(), options.getAuthorEmail()), String.format(DESCRIPTION_PARAM, Bundle.Composer_init_description(phpModule.getDisplayName())));
        return this.runCommand(phpModule, true, INIT_COMMAND, params);
    }

    private String getInitName(String vendor, String projectName) {
        StringBuilder name = new StringBuilder(50);
        name.append(vendor);
        name.append('/');
        name.append(StringUtils.webalize((String)projectName));
        return name.toString();
    }

    public Future<Integer> install(PhpModule phpModule) {
        assert (phpModule != null);
        return this.runCommand(phpModule, INSTALL_COMMAND);
    }

    public Future<Integer> installDev(PhpModule phpModule) {
        return this.install(phpModule);
    }

    public Future<Integer> installNoDev(PhpModule phpModule) {
        assert (phpModule != null);
        return this.runCommand(phpModule, INSTALL_COMMAND, Collections.singletonList(NO_DEV_PARAM));
    }

    public Future<Integer> update(PhpModule phpModule) {
        assert (phpModule != null);
        return this.runCommand(phpModule, UPDATE_COMMAND);
    }

    public Future<Integer> updateDev(PhpModule phpModule) {
        return this.update(phpModule);
    }

    public Future<Integer> updateNoDev(PhpModule phpModule) {
        assert (phpModule != null);
        return this.runCommand(phpModule, UPDATE_COMMAND, Collections.singletonList(NO_DEV_PARAM));
    }

    public Future<Integer> updateAutoloader(PhpModule phpModule) {
        assert (phpModule != null);
        return this.runCommand(phpModule, UPDATE_AUTOLOADER_COMMAND);
    }

    public Future<Integer> updateAutoloaderDev(PhpModule phpModule) {
        return this.updateAutoloader(phpModule);
    }

    public Future<Integer> updateAutoloaderNoDev(PhpModule phpModule) {
        assert (phpModule != null);
        return this.runCommand(phpModule, UPDATE_AUTOLOADER_COMMAND, Collections.singletonList(NO_DEV_PARAM));
    }

    public Future<Integer> require(PhpModule phpModule, String ... packages) {
        assert (phpModule != null);
        return this.runCommand(phpModule, REQUIRE_COMMAND, Arrays.asList(packages));
    }

    public Future<Integer> requireDev(PhpModule phpModule, String ... packages) {
        assert (phpModule != null);
        ArrayList<String> params = new ArrayList<String>(packages.length + 1);
        params.add(DEV_PARAM);
        params.addAll(Arrays.asList(packages));
        return this.runCommand(phpModule, REQUIRE_COMMAND, params);
    }

    public Future<Integer> runScript(PhpModule phpModule, String scriptName) {
        assert (phpModule != null);
        return this.runCommand(phpModule, RUN_SCRIPT_COMMAND, Collections.singletonList(scriptName));
    }

    public Future<Integer> validate(PhpModule phpModule) {
        assert (phpModule != null);
        return this.runCommand(phpModule, VALIDATE_COMMAND);
    }

    public Future<Integer> selfUpdate() {
        return this.runCommand(null, SELF_UPDATE_COMMAND);
    }

    public Future<Integer> search(@NullAllowed PhpModule phpModule, String token, boolean onlyName, final OutputProcessor<SearchResult> outputProcessor) {
        PhpExecutable composer = this.getComposerExecutable(phpModule, false);
        if (composer == null) {
            return null;
        }
        ArrayList<String> defaultParams = new ArrayList<String>(DEFAULT_PARAMS);
        defaultParams.remove(ANSI_PARAM);
        defaultParams.add(NO_ANSI_PARAM);
        ArrayList<String> params = new ArrayList<String>(2);
        if (onlyName) {
            params.add(ONLY_NAME_PARAM);
        }
        params.add(token);
        composer = composer.additionalParameters(this.mergeParameters(SEARCH_COMMAND, defaultParams, params)).redirectErrorStream(false);
        ExecutionDescriptor descriptor = this.getDescriptor(phpModule).frontWindow(false);
        return composer.run(descriptor, new ExecutionDescriptor.InputProcessorFactory2(){
            final /* synthetic */ Composer this$0;
            {
                this.this$0 = this$0;
            }

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return new OutputProcessorImpl(new OutputParser(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void parse(char[] chars) {
                        for (SearchResult result : Parsers.parseSearch(new String(chars))) {
                            outputProcessor.process(result);
                        }
                    }
                });
            }
        });
    }

    public Future<Integer> show(@NullAllowed PhpModule phpModule, String name, final OutputProcessor<String> outputProcessor) {
        PhpExecutable composer = this.getComposerExecutable(phpModule, false);
        if (composer == null) {
            return null;
        }
        ArrayList<String> defaultParams = new ArrayList<String>(DEFAULT_PARAMS);
        defaultParams.remove(ANSI_PARAM);
        defaultParams.add(NO_ANSI_PARAM);
        composer = composer.additionalParameters(this.mergeParameters(SHOW_COMMAND, defaultParams, Arrays.asList(ALL_PARAM, name))).redirectErrorStream(false);
        ExecutionDescriptor descriptor = this.getDescriptor(phpModule).frontWindow(false);
        return composer.run(descriptor, new ExecutionDescriptor.InputProcessorFactory2(){
            final /* synthetic */ Composer this$0;
            {
                this.this$0 = this$0;
            }

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return new OutputProcessorImpl(new OutputParser(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void parse(char[] chars) {
                        String chunk = new String(chars);
                        if (!Composer.isValidOutput(chunk)) {
                            return;
                        }
                        outputProcessor.process(chunk);
                    }
                });
            }
        });
    }

    private Future<Integer> runCommand(@NullAllowed PhpModule phpModule, String command) {
        return this.runCommand(phpModule, command, Collections.emptyList());
    }

    private Future<Integer> runCommand(@NullAllowed PhpModule phpModule, String command, List<String> commandParams) {
        return this.runCommand(phpModule, false, command, commandParams);
    }

    private Future<Integer> runCommand(@NullAllowed PhpModule phpModule, boolean forceProjectDir, String command, List<String> commandParams) {
        PhpExecutable composer = this.getComposerExecutable(phpModule, forceProjectDir);
        if (composer == null) {
            return null;
        }
        return composer.additionalParameters(this.mergeParameters(command, DEFAULT_PARAMS, commandParams)).run(this.getDescriptor(phpModule));
    }

    @CheckForNull
    private PhpExecutable getComposerExecutable(@NullAllowed PhpModule phpModule, boolean forceProjectDir) {
        File dir = this.resolveWorkDir(phpModule, forceProjectDir);
        if (dir == null && phpModule != null) {
            Composer.warnNoSources(phpModule.getDisplayName());
            return null;
        }
        PhpExecutable composer = new PhpExecutable(this.composerPath).optionsSubcategory("FrameworksAndTools/Composer").displayName(phpModule != null ? Bundle.Composer_run_title(phpModule.getDisplayName()) : Bundle.Composer_run_title_pure());
        if (dir != null) {
            composer.workDir(dir);
        }
        return composer;
    }

    private List<String> mergeParameters(String command, List<String> defaultParams, List<String> commandParams) {
        ArrayList<String> allParams = new ArrayList<String>(defaultParams.size() + commandParams.size() + 1);
        allParams.addAll(defaultParams);
        allParams.add(command);
        allParams.addAll(commandParams);
        return allParams;
    }

    private ExecutionDescriptor getDescriptor(@NullAllowed PhpModule phpModule) {
        FileObject sourceDirectory;
        ExecutionDescriptor descriptor = PhpExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath(ComposerOptionsPanelController.getOptionsPath()).inputVisible(false);
        if (phpModule != null && (sourceDirectory = phpModule.getSourceDirectory()) != null) {
            descriptor = descriptor.postExecution(new Runnable(){
                final /* synthetic */ Composer this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    sourceDirectory.refresh();
                }
            });
        }
        return descriptor;
    }

    private static void warnNoSources(String projectName) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.Composer_project_noSources(projectName), 2));
    }

    @CheckForNull
    private FileObject getComposerJson(PhpModule phpModule) {
        assert (phpModule != null);
        if (this.workDir != null) {
            FileObject fo = FileUtil.toFileObject((File)this.workDir);
            if (fo == null) {
                LOGGER.log(Level.INFO, "Valid workdir expected but invalid given: {0}", this.workDir);
                return null;
            }
            return fo.getFileObject(COMPOSER_FILENAME);
        }
        return ComposerUtils.getComposerWorkDir(phpModule).getFileObject(COMPOSER_FILENAME);
    }

    private boolean userConfirmation(String title, String question) {
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)question, title, 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == DialogDescriptor.YES_OPTION;
    }

    @CheckForNull
    private File resolveWorkDir(PhpModule phpModule, boolean forceProjectDir) {
        FileObject dir;
        if (this.workDir != null) {
            return this.workDir;
        }
        if (phpModule == null) {
            return null;
        }
        FileObject composerJson = this.getComposerJson(phpModule);
        if (composerJson != null) {
            return FileUtil.toFile((FileObject)composerJson.getParent());
        }
        FileObject fileObject = dir = forceProjectDir ? phpModule.getProjectDirectory() : phpModule.getSourceDirectory();
        if (dir == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)dir);
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        assert (workDir == null || workDir.isDirectory()) : "Existing directory or null expected: " + workDir;
        this.workDir = workDir;
    }

    static {
        DEFAULT_PARAMS = Arrays.asList(ANSI_PARAM, NO_INTERACTION_PARAM);
        ArrayList<String> fileNames = new ArrayList<String>(2);
        if (Utilities.isWindows()) {
            fileNames.add(COMPOSER_BAT);
            fileNames.add(COMPOSER_PHAR);
        } else {
            fileNames.add(COMPOSER);
            fileNames.add(COMPOSER_PHAR);
        }
        COMPOSER_FILENAMES = new CopyOnWriteArrayList<String>(fileNames);
    }

    public static interface OutputProcessor<T> {
        public void process(T var1);
    }

    private static final class OutputProcessorImpl
    implements InputProcessor {
        private final OutputParser outputParser;

        public OutputProcessorImpl(OutputParser outputParser) {
            this.outputParser = outputParser;
        }

        public void processInput(char[] chars) throws IOException {
            this.outputParser.parse(chars);
        }

        public void reset() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    private static interface OutputParser {
        public void parse(char[] var1);
    }
}

