/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.c14n;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.c14n.Canonicalizer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.xml.crypto.dsig.TransformException;

public class ImageCanonicalizer
extends Canonicalizer {
    public ImageCanonicalizer() {
    }

    public ImageCanonicalizer(String charset) {
        super(charset);
    }

    @Override
    public byte[] canonicalize(byte[] input) throws XWSSecurityException {
        return input;
    }

    @Override
    public InputStream canonicalize(InputStream input, OutputStream outputStream) throws TransformException {
        try {
            int len;
            if (outputStream == null) {
                return input;
            }
            byte[] data = new byte[128];
            while ((len = input.read(data)) > 0) {
                outputStream.write(data, 0, len);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WSS1001.error.canonicalizing.image", new Object[]{ex.getMessage()});
            throw new TransformException(ex.getMessage());
        }
        return null;
    }
}

