/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.uddi.FuturesRequestManager;
import com.sun.xml.registry.uddi.JAXRCommand;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.infomodel.AssociationImpl;
import com.sun.xml.registry.uddi.infomodel.ClassificationImpl;
import com.sun.xml.registry.uddi.infomodel.ClassificationSchemeImpl;
import com.sun.xml.registry.uddi.infomodel.ConceptImpl;
import com.sun.xml.registry.uddi.infomodel.EmailAddressImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalIdentifierImpl;
import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import com.sun.xml.registry.uddi.infomodel.LocalizedStringImpl;
import com.sun.xml.registry.uddi.infomodel.OrganizationImpl;
import com.sun.xml.registry.uddi.infomodel.PersonNameImpl;
import com.sun.xml.registry.uddi.infomodel.PostalAddressImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceBindingImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceImpl;
import com.sun.xml.registry.uddi.infomodel.SlotImpl;
import com.sun.xml.registry.uddi.infomodel.SpecificationLinkImpl;
import com.sun.xml.registry.uddi.infomodel.TelephoneNumberImpl;
import com.sun.xml.registry.uddi.infomodel.UserImpl;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.activation.DataHandler;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Classification;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.EmailAddress;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.ExtrinsicObject;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.LocalizedString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PersonName;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.RegistryPackage;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.Slot;
import javax.xml.registry.infomodel.SpecificationLink;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class LifeCycleManagerImpl
implements LifeCycleManager {
    RegistryServiceImpl service;
    UDDIMapper uddi;
    String[] names = new String[]{"Association", "Classification", "ClassificationScheme", "Concept", "EmailAddress", "ExternalIdentifier", "ExternalLink", "InternationalString", "Key", "LocalizedString", "Organization", "PersonName", "PostalAddress", "Service", "ServiceBinding", "Slot", "SpecificationLink", "TelephoneNumber", "User"};
    Class[] infoModelClass = new Class[]{AssociationImpl.class, ClassificationImpl.class, ClassificationSchemeImpl.class, ConceptImpl.class, EmailAddressImpl.class, ExternalIdentifierImpl.class, ExternalLinkImpl.class, InternationalStringImpl.class, KeyImpl.class, LocalizedStringImpl.class, OrganizationImpl.class, PersonNameImpl.class, PostalAddressImpl.class, ServiceImpl.class, ServiceBindingImpl.class, SlotImpl.class, SpecificationLinkImpl.class, TelephoneNumberImpl.class, UserImpl.class};

    public LifeCycleManagerImpl() {
        String country = Locale.getDefault().getCountry();
        if (country == null || country == "") {
            Locale.setDefault(Locale.US);
        }
        System.out.println("Default locale: " + Locale.getDefault().toString());
    }

    public LifeCycleManagerImpl(RegistryServiceImpl service) {
        this();
        this.service = service;
        this.uddi = service.getUDDIMapper();
    }

    public RegistryService getRegistryService() {
        return this.service;
    }

    public Object createObject(String className) throws JAXRException {
        try {
            for (int i = 0; i < this.names.length; ++i) {
                if (!className.equals(this.names[i])) continue;
                Class infoClass = this.infoModelClass[i];
                Object object = infoClass.newInstance();
                if (object instanceof RegistryObjectImpl) {
                    RegistryObjectImpl ro = (RegistryObjectImpl)object;
                    ro.setLifeCycleManager(this);
                    ro.setRegistryService(this.service);
                    ro.setIsModified(true);
                }
                return object;
            }
            if (className.equals("AuditableEvent") || className.equals("ExtrinsicObject") || className.equals("RegistryEntry") || className.equals("Versionable") || className.equals("RegistryPackage")) {
                throw new UnsupportedCapabilityException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:Can_not_create_object_of_type_") + className + ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:_at_Capability_Level_0"));
            }
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:Class_Name_is_not_an_interface_in_the_javax.xml.registry.infomodel_package"));
        }
        catch (InstantiationException ie) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:InstantiationException_in_createObject()_"), (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:IllegalAccessException_in_createObject()_"), (Throwable)iae);
        }
    }

    public Association createAssociation(RegistryObject targetObject, Concept associationType) throws JAXRException {
        AssociationImpl association = new AssociationImpl(targetObject, associationType);
        association.setLifeCycleManager(this);
        association.setIsModified(true);
        return association;
    }

    public Classification createClassification(ClassificationScheme scheme, String name, String value) throws JAXRException {
        ClassificationImpl classification = new ClassificationImpl(scheme, name, value);
        classification.setLifeCycleManager(this);
        classification.setIsModified(true);
        return classification;
    }

    public Classification createClassification(Concept concept) throws JAXRException, InvalidRequestException {
        if (concept.getClassificationScheme() == null) {
            throw new InvalidRequestException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:Concept_has_no_ClassificationScheme"));
        }
        ClassificationImpl classification = new ClassificationImpl(concept);
        classification.setLifeCycleManager(this);
        classification.setIsModified(true);
        return classification;
    }

    public ClassificationScheme createClassificationScheme(Concept concept) throws JAXRException, InvalidRequestException {
        if (concept.getClassificationScheme() == null && concept.getParentConcept() == null) {
            ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(concept);
            scheme.setLifeCycleManager(this);
            scheme.setIsModified(true);
            return scheme;
        }
        throw new InvalidRequestException();
    }

    public ClassificationScheme createClassificationScheme(String name, String description) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(name, description);
        scheme.setLifeCycleManager(this);
        scheme.setIsModified(true);
        return scheme;
    }

    public Concept createConcept(RegistryObject parent, String name, String value) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(parent, name, value);
        concept.setLifeCycleManager(this);
        concept.setIsModified(true);
        return concept;
    }

    public Concept createConcept(RegistryObject parent, InternationalString name, String value) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(parent, "", value);
        concept.setName(name);
        concept.setLifeCycleManager(this);
        concept.setIsModified(true);
        return concept;
    }

    public EmailAddress createEmailAddress(String address) throws JAXRException {
        return new EmailAddressImpl(address);
    }

    public EmailAddress createEmailAddress(String address, String type) throws JAXRException {
        return new EmailAddressImpl(address, type);
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme identificationScheme, String name, String value) throws JAXRException {
        ExternalIdentifierImpl identifier = new ExternalIdentifierImpl(identificationScheme, name, value);
        identifier.setLifeCycleManager(this);
        identifier.setIsModified(true);
        return identifier;
    }

    public ExternalLink createExternalLink(String externalURI, String description) throws JAXRException {
        ExternalLinkImpl link = new ExternalLinkImpl(externalURI, description);
        link.setLifeCycleManager(this);
        link.setIsModified(true);
        return link;
    }

    public Key createKey(String id) throws JAXRException {
        return new KeyImpl(id);
    }

    public PersonName createPersonName(String fullName) throws JAXRException {
        return new PersonNameImpl(fullName);
    }

    public PostalAddress createPostalAddress(String streetNumber, String street, String city, String stateOrProvince, String country, String postalCode, String type) throws JAXRException {
        PostalAddressImpl address = new PostalAddressImpl(streetNumber, street, city, stateOrProvince, country, postalCode, type);
        if (this.service != null) {
            address.setPostalScheme(this.service.getDefaultPostalScheme());
        }
        return address;
    }

    public Service createService(String name) throws JAXRException {
        ServiceImpl service = new ServiceImpl(name);
        service.setLifeCycleManager(this);
        service.setIsModified(true);
        return service;
    }

    public ServiceBinding createServiceBinding() throws JAXRException {
        ServiceBindingImpl binding = new ServiceBindingImpl();
        binding.setLifeCycleManager(this);
        binding.setIsModified(true);
        return binding;
    }

    public Slot createSlot(String name, String value, String slotType) throws JAXRException {
        return new SlotImpl(name, value, slotType);
    }

    public Slot createSlot(String name, Collection values, String slotType) throws JAXRException {
        return new SlotImpl(name, values, slotType);
    }

    public SpecificationLink createSpecificationLink() throws JAXRException {
        SpecificationLinkImpl specificationLink = new SpecificationLinkImpl();
        specificationLink.setLifeCycleManager(this);
        specificationLink.setIsModified(true);
        return specificationLink;
    }

    public TelephoneNumber createTelephoneNumber() throws JAXRException {
        return new TelephoneNumberImpl();
    }

    public User createUser() throws JAXRException {
        UserImpl user = new UserImpl();
        user.setLifeCycleManager(this);
        user.setIsModified(true);
        return user;
    }

    public BulkResponse saveObjects(Collection cataloguedObjects) throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl response = new BulkResponseImpl();
            response.setStatus(3);
            Utility.getInstance();
            response.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(response);
            FuturesRequestManager.invokeCommand(new JAXRCommand.SaveObjectsCommand(this.service, response, cataloguedObjects));
            return response;
        }
        return this.uddi.saveObjects(cataloguedObjects);
    }

    public BulkResponse deleteObjects(Collection keys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse deleteObjects(Collection keys, String objectType) throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl response = new BulkResponseImpl();
            response.setStatus(3);
            Utility.getInstance();
            response.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(response);
            FuturesRequestManager.invokeCommand(new JAXRCommand.DeleteObjectsCommand(this.service, response, keys, objectType));
            return response;
        }
        return this.uddi.deleteObjects(keys, objectType);
    }

    public void createConceptEquivalence(Concept concept1, Concept concept2) throws JAXRException {
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:UDDI_V2_functionality_is_not_supported_in_this_release"));
    }

    public void deleteConceptEquivalence(Concept concept1, Concept concept2) throws JAXRException {
        throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("LifeCycleManagerImpl:UDDI_V2_functionality_is_not_supported_in_this_release"));
    }

    public LocalizedString createLocalizedString(Locale locale, String str) throws JAXRException {
        return new LocalizedStringImpl(locale, str);
    }

    public InternationalString createInternationalString(Locale locale, String str) throws JAXRException {
        return new InternationalStringImpl(locale, str);
    }

    public InternationalString createInternationalString() throws JAXRException {
        return new InternationalStringImpl();
    }

    public InternationalString createInternationalString(String str) throws JAXRException {
        return new InternationalStringImpl(str);
    }

    public Classification createClassification(ClassificationScheme classificationScheme, InternationalString name, String value) throws JAXRException {
        ClassificationImpl classification = new ClassificationImpl(classificationScheme, "", value);
        classification.setName(name);
        classification.setLifeCycleManager(this);
        classification.setIsModified(true);
        return classification;
    }

    public ClassificationScheme createClassificationScheme(InternationalString name, InternationalString description) throws JAXRException, InvalidRequestException {
        ClassificationSchemeImpl scheme = new ClassificationSchemeImpl();
        scheme.setName(name);
        scheme.setDescription(description);
        scheme.setLifeCycleManager(this);
        scheme.setIsModified(true);
        return scheme;
    }

    public LocalizedString createLocalizedString(Locale locale, String s, String charsetName) throws JAXRException {
        LocalizedStringImpl lString = new LocalizedStringImpl(locale, s);
        lString.setCharsetName(charsetName);
        return lString;
    }

    public Organization createOrganization(InternationalString name) throws JAXRException {
        OrganizationImpl organization = new OrganizationImpl();
        organization.setName(name);
        organization.setLifeCycleManager(this);
        organization.setIsModified(true);
        return organization;
    }

    public Organization createOrganization(String name) throws JAXRException {
        return this.createOrganization(this.createInternationalString(name));
    }

    public ExternalLink createExternalLink(String externalURI, InternationalString description) throws JAXRException {
        ExternalLinkImpl link = new ExternalLinkImpl(externalURI);
        link.setDescription(description);
        link.setLifeCycleManager(this);
        link.setIsModified(true);
        return link;
    }

    public ExternalIdentifier createExternalIdentifier(ClassificationScheme identificationScheme, InternationalString name, String value) throws JAXRException {
        ExternalIdentifierImpl exId = new ExternalIdentifierImpl(identificationScheme, "", value);
        exId.setName(name);
        exId.setLifeCycleManager(this);
        exId.setIsModified(true);
        return exId;
    }

    public Service createService(InternationalString name) throws JAXRException {
        ServiceImpl service = new ServiceImpl();
        service.setName(name);
        service.setLifeCycleManager(this);
        service.setIsModified(true);
        return service;
    }

    public RegistryPackage createRegistryPackage(InternationalString internationalString) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public ExtrinsicObject createExtrinsicObject() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public PersonName createPersonName(String firstName, String middleName, String lastName) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public RegistryPackage createRegistryPackage(String name) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse deprecateObjects(Collection keys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse unDeprecateObjects(Collection keys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public ExtrinsicObject createExtrinsicObject(DataHandler repositoryItem) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

