/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.sources;

import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.security.Permission;
import org.netbeans.modules.javascript2.debug.sources.SourceURLMapper;
import org.openide.filesystems.FileObject;

final class SourceConnection
extends URLConnection {
    private FileObject fo;
    private InputStream iStream = null;

    SourceConnection(URL url) {
        super(url);
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.fo == null) {
            this.fo = SourceURLMapper.find(this.url);
        }
        if (this.fo == null) {
            throw new FileNotFoundException(this.url.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws IOException, UnknownServiceException {
        this.connect();
        if (this.iStream == null) {
            if (this.fo.isFolder()) {
                throw new FileNotFoundException("Can not read from a folder.");
            }
            this.iStream = this.fo.getInputStream();
        }
        return this.iStream;
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
            return (int)this.fo.getSize();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public String getHeaderField(String name) {
        if (name.equalsIgnoreCase("content-type")) {
            try {
                this.connect();
                if (this.fo.isData()) {
                    return this.fo.getMIMEType();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getHeaderField(name);
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        if (name.equalsIgnoreCase("last-modified")) {
            try {
                this.connect();
                return this.fo.lastModified().getTime();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getHeaderFieldDate(name, Default);
    }

    @Override
    public Permission getPermission() throws IOException {
        return new FilePermission("<<ALL FILES>>", "read");
    }
}

