/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.AbstractJaxRsFeatureIterator;
import org.netbeans.modules.websvc.rest.wizard.InterceptorPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class InterceptorIterator
extends AbstractJaxRsFeatureIterator {
    @Override
    protected WizardDescriptor.Panel<?> createPanel(WizardDescriptor wizard) {
        return new InterceptorPanel(wizard);
    }

    @Override
    protected String getTitleKey() {
        return "TXT_CreateJaxRsInterceptor";
    }

    public Set<?> instantiate(ProgressHandle handle) throws IOException {
        handle.start();
        handle.progress(NbBundle.getMessage(InterceptorIterator.class, (String)"TXT_GenerateInterceptorFile"));
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.getWizard());
        String name = Templates.getTargetName((WizardDescriptor)this.getWizard());
        FileObject interceptorClass = GenerationUtils.createClass((FileObject)targetFolder, (String)name, null);
        this.implementInterceptors(interceptorClass);
        handle.finish();
        return Collections.singleton(interceptorClass);
    }

    private void implementInterceptors(FileObject filterClass) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)filterClass);
        if (javaSource == null) {
            return;
        }
        final boolean reader = Boolean.TRUE.equals(this.getWizard().getProperty("reader.interceptor"));
        final boolean writer = Boolean.TRUE.equals(this.getWizard().getProperty("writer.interceptor"));
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){
            final /* synthetic */ InterceptorIterator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy copy) throws Exception {
                MethodTree method;
                ClassTree tree;
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree newTree = tree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                TreeMaker treeMaker = copy.getTreeMaker();
                GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)copy);
                AnnotationTree provider = genUtils.createAnnotation("javax.ws.rs.ext.Provider");
                newTree = genUtils.addAnnotation(newTree, provider);
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                if (reader) {
                    params.put("context", "javax.ws.rs.ext.ReaderInterceptorContext");
                    newTree = genUtils.addImplementsClause(newTree, "javax.ws.rs.ext.ReaderInterceptor");
                    method = AbstractJaxRsFeatureIterator.createMethod(genUtils, treeMaker, "aroundReadFrom", Object.class.getName(), params);
                    newTree = treeMaker.addClassMember(newTree, (Tree)method);
                }
                if (writer) {
                    params.clear();
                    params.put("responseContext", "javax.ws.rs.ext.WriterInterceptorContext");
                    newTree = genUtils.addImplementsClause(newTree, "javax.ws.rs.ext.WriterInterceptor");
                    method = AbstractJaxRsFeatureIterator.createMethod(genUtils, treeMaker, "aroundWriteTo", params);
                    newTree = treeMaker.addClassMember(newTree, (Tree)method);
                }
                copy.rewrite((Tree)tree, (Tree)newTree);
            }
        }).commit();
    }
}

