/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.DOMHelper;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PersistenceHelper {
    private static final String PERSISTENCE_UNIT_TAG = "persistence-unit";
    private static final String PROPERTIES_TAG = "properties";
    private static final String NAME_ATTR = "name";
    private static final String EXCLUDE_UNLISTED_CLASSES_TAG = "exclude-unlisted-classes";
    private static final String TRANSACTION_TYPE_ATTR = "transaction-type";
    private static final String RESOURCE_LOCAL_VALUE = "RESOURCE_LOCAL";
    private static final String JTA_DATA_SOURCE_TAG = "jta-data-source";
    private static final String NON_JTA_DATA_SOURCE_TAG = "non-jta-data-source";
    private static final String CLASS_TAG = "class";
    private static final String PROVIDER_TAG = "provider";
    private static final String DEFAULT_GFV2_PROVIDER = "oracle.toplink.essentials.PersistenceProvider";
    private static final String DEFAULT_GFV3_PROVIDER = "org.eclipse.persistence.jpa.PersistenceProvider";
    private Project project;
    private DOMHelper helper;

    public PersistenceHelper(Project project) {
        this.project = project;
        FileObject fobj = this.getPersistenceXML();
        if (fobj != null) {
            this.helper = new DOMHelper(fobj);
        }
    }

    public PersistenceUnit getPersistenceUnit() {
        Element puElement;
        if (this.helper != null && (puElement = this.helper.findElement(PERSISTENCE_UNIT_TAG)) != null) {
            Attr puNameNode = puElement.getAttributeNode(NAME_ATTR);
            String puName = puNameNode == null ? null : puNameNode.getValue();
            NodeList nodes = puElement.getElementsByTagName(PROVIDER_TAG);
            String provider = nodes.getLength() > 0 ? this.helper.getValue((Element)nodes.item(0)) : (RestUtils.isServerGFV3(this.project) ? DEFAULT_GFV3_PROVIDER : DEFAULT_GFV3_PROVIDER);
            Datasource datasource = null;
            NodeList nodeList = puElement.getElementsByTagName(JTA_DATA_SOURCE_TAG);
            if (nodeList.getLength() > 0) {
                Element dsElement = (Element)nodeList.item(0);
                String jndiName = this.helper.getValue(dsElement);
                datasource = RestUtils.getDatasource(this.project, jndiName);
            }
            return new PersistenceUnit(puName, provider, datasource);
        }
        return null;
    }

    public void configure(Collection<String> classNames, boolean useResourceLocalTx) throws IOException {
        if (this.helper == null) {
            return;
        }
        if (RestUtils.isServerTomcat(this.project)) {
            this.unsetExcludeEnlistedClasses();
            this.addEntityClasses(classNames);
        }
        if (useResourceLocalTx) {
            this.switchToResourceLocalTransaction();
        }
        this.helper.save();
    }

    private void unsetExcludeEnlistedClasses() throws IOException {
        Element puElement = this.helper.findElement(PERSISTENCE_UNIT_TAG);
        NodeList nodes = puElement.getElementsByTagName(EXCLUDE_UNLISTED_CLASSES_TAG);
        if (nodes.getLength() > 0) {
            this.helper.setValue((Element)nodes.item(0), "false");
        } else {
            puElement.insertBefore(this.helper.createElement(EXCLUDE_UNLISTED_CLASSES_TAG, "false"), this.helper.findElement(PROPERTIES_TAG));
        }
    }

    private void switchToResourceLocalTransaction() throws IOException {
        Element puElement = this.helper.findElement(PERSISTENCE_UNIT_TAG);
        puElement.setAttribute(TRANSACTION_TYPE_ATTR, RESOURCE_LOCAL_VALUE);
        NodeList nodes = puElement.getElementsByTagName(JTA_DATA_SOURCE_TAG);
        String dataSource = null;
        if (nodes.getLength() > 0) {
            Element oldElement = (Element)nodes.item(0);
            dataSource = this.helper.getValue(oldElement);
            Element newElement = this.helper.createElement(NON_JTA_DATA_SOURCE_TAG, dataSource);
            puElement.replaceChild(newElement, oldElement);
        }
    }

    private void addEntityClasses(Collection<String> classNames) throws IOException {
        ArrayList<String> toAdd = new ArrayList<String>(classNames);
        Element puElement = this.helper.findElement(PERSISTENCE_UNIT_TAG);
        NodeList nodes = puElement.getElementsByTagName(CLASS_TAG);
        int length = nodes.getLength();
        for (int i = 0; i < length; ++i) {
            toAdd.remove(this.helper.getValue((Element)nodes.item(i)));
        }
        for (String className : toAdd) {
            puElement.insertBefore(this.helper.createElement(CLASS_TAG, className), this.helper.findElement(EXCLUDE_UNLISTED_CLASSES_TAG));
        }
    }

    private FileObject getPersistenceXML() {
        RestSupport rs = RestUtils.getRestSupport(this.project);
        if (rs != null) {
            return rs.getPersistenceXml();
        }
        return null;
    }

    public static class PersistenceUnit {
        private String name;
        private String provider;
        private Datasource datasource;

        public PersistenceUnit(String name, String provider, Datasource datasource) {
            this.name = name;
            this.provider = provider;
            this.datasource = datasource;
        }

        public String getName() {
            return this.name;
        }

        public String getProvider() {
            return this.provider;
        }

        public Datasource getDatasource() {
            return this.datasource;
        }
    }
}

