/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermInputListener;

public class StreamTerm
extends Term {
    private boolean connected = false;
    private transient Writer writer;
    private Pipe pipe;
    private OutputStreamWriter outputStreamWriter;
    private InputMonitor stdinMonitor;
    private OutputMonitor stdoutMonitor;
    private OutputMonitor stderrMonitor;
    private static final int BUFSZ = 1024;

    public OutputStreamWriter getOutputStreamWriter() {
        if (!this.connected) {
            throw new IllegalStateException("getOutputStreamWriter() can only be used after connect()");
        }
        return this.outputStreamWriter;
    }

    public void connect(OutputStream pin, InputStream pout, InputStream perr, String charSet) {
        if (this.connected) {
            throw new IllegalStateException("Cannot call connect() twice");
        }
        this.updateTtySize();
        if (pin != null) {
            if (charSet == null) {
                this.outputStreamWriter = new OutputStreamWriter(pin);
            } else {
                try {
                    this.outputStreamWriter = new OutputStreamWriter(pin, charSet);
                }
                catch (UnsupportedEncodingException ex) {
                    this.outputStreamWriter = new OutputStreamWriter(pin);
                }
            }
            this.stdinMonitor = new InputMonitor(this.outputStreamWriter);
            this.addInputListener(this.stdinMonitor);
        }
        if (pout != null) {
            InputStreamReader pout_reader;
            if (charSet == null) {
                pout_reader = new InputStreamReader(pout);
            } else {
                try {
                    pout_reader = new InputStreamReader(pout, charSet);
                }
                catch (UnsupportedEncodingException ex) {
                    pout_reader = new InputStreamReader(pout);
                }
            }
            this.stdoutMonitor = new OutputMonitor(pout_reader, this);
            this.stdoutMonitor.start();
        }
        if (perr != null) {
            InputStreamReader err_reader;
            if (charSet == null) {
                err_reader = new InputStreamReader(perr);
            } else {
                try {
                    err_reader = new InputStreamReader(perr, charSet);
                }
                catch (UnsupportedEncodingException ex) {
                    err_reader = new InputStreamReader(perr);
                }
            }
            this.stderrMonitor = new OutputMonitor(err_reader, this);
            this.stderrMonitor.start();
        }
        this.connected = true;
    }

    public void connect(OutputStream pin, InputStream pout, InputStream perr) {
        this.connect(pin, pout, perr, null);
    }

    private void disconnectWork() {
        if (this.stdoutMonitor != null) {
            try {
                this.stdoutMonitor.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(StreamTerm.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.stderrMonitor != null) {
            try {
                this.stderrMonitor.join();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(StreamTerm.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.connected = false;
    }

    public void disconnect(final Runnable continuation) {
        if (!this.connected) {
            return;
        }
        if (this.stdinMonitor != null) {
            this.removeInputListener(this.stdinMonitor);
        }
        Thread drainer = new Thread(this){
            final /* synthetic */ StreamTerm this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.disconnectWork();
                if (continuation != null) {
                    SwingUtilities.invokeLater(continuation);
                }
            }
        };
        drainer.start();
    }

    public Reader getIn() {
        if (this.pipe == null) {
            try {
                this.pipe = new Pipe(this);
            }
            catch (IOException ex) {
                return null;
            }
        }
        return this.pipe.reader();
    }

    public Writer getOut() {
        if (this.writer == null) {
            this.writer = new TermWriter();
        }
        return this.writer;
    }

    private static final class InputMonitor
    implements TermInputListener {
        private final OutputStreamWriter outputStreamWriter;
        private final ExecutorService singlePool = Executors.newSingleThreadExecutor();

        public InputMonitor(OutputStreamWriter outputStreamWriter) {
            this.outputStreamWriter = outputStreamWriter;
        }

        @Override
        public void sendChars(char[] c, int offset, final int count) {
            final char[] copy = new char[count];
            System.arraycopy(c, offset, copy, 0, count);
            this.singlePool.submit(new Runnable(){
                final /* synthetic */ InputMonitor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.outputStreamWriter.write(copy, 0, count);
                        this.this$0.outputStreamWriter.flush();
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception x) {
                        Logger.getLogger(StreamTerm.class.getName()).log(Level.SEVERE, null, x);
                    }
                }
            });
        }

        @Override
        public void sendChar(final char c) {
            this.singlePool.submit(new Runnable(){
                final /* synthetic */ InputMonitor this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        this.this$0.outputStreamWriter.write(c);
                        this.this$0.outputStreamWriter.flush();
                    }
                    catch (IOException iOException) {
                    }
                    catch (Exception x) {
                        Logger.getLogger(StreamTerm.class.getName()).log(Level.SEVERE, null, x);
                    }
                }
            });
        }
    }

    private static final class OutputMonitor
    extends Thread {
        private final char[] buf = new char[1024];
        private final Term term;
        private final InputStreamReader reader;

        OutputMonitor(InputStreamReader reader, Term term) {
            super("StreamTerm.OutputMonitor");
            this.reader = reader;
            this.term = term;
            this.setPriority(1);
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                Logger.getLogger(StreamTerm.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        private void db_echo_receipt(char[] buf, int offset, int count) {
            System.out.println("Received:");
            int width = 20;
            int cx = 0;
            while (cx < count) {
                int x;
                int cx0 = cx;
                System.out.printf("%4d: ", cx);
                for (x = 0; x < 20 && cx < count; ++cx, ++x) {
                    System.out.printf("%02x ", buf[offset + cx]);
                }
                System.out.println();
                cx = cx0;
                System.out.print("      ");
                for (x = 0; x < 20 && cx < count; ++cx, ++x) {
                    char c = buf[offset + cx];
                    if (Character.isISOControl(c)) {
                        c = ' ';
                    }
                    System.out.printf("%2c ", Character.valueOf(c));
                }
                System.out.println();
            }
        }

        @Override
        public void run() {
            Trampoline tramp = new Trampoline();
            try {
                while (true) {
                    int nread = -1;
                    try {
                        nread = this.reader.read(this.buf, 0, 1024);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (nread == -1) break;
                    if (this.term.debugInput()) {
                        this.db_echo_receipt(this.buf, 0, nread);
                    }
                    tramp.nread = nread;
                    SwingUtilities.invokeAndWait(tramp);
                }
                this.reader.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        private final class Trampoline
        implements Runnable {
            public int nread;

            private Trampoline() {
            }

            @Override
            public void run() {
                OutputMonitor.this.term.putChars(OutputMonitor.this.buf, 0, this.nread);
            }
        }
    }

    private static final class Pipe {
        private final PipedReader pipedReader = new PipedReader();
        private final PipedWriter pipedWriter = new PipedWriter(this.pipedReader);

        Pipe(Term term) throws IOException {
            term.addInputListener(new TermListener());
        }

        Reader reader() {
            return this.pipedReader;
        }

        private final class TermListener
        implements TermInputListener {
            private TermListener() {
            }

            @Override
            public void sendChars(char[] c, int offset, int count) {
                try {
                    Pipe.this.pipedWriter.write(c, offset, count);
                    Pipe.this.pipedWriter.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public void sendChar(char c) {
                try {
                    Pipe.this.pipedWriter.write(c);
                    Pipe.this.pipedWriter.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private final class TermWriter
    extends Writer {
        private boolean closed = false;

        TermWriter() {
        }

        @Override
        public void write(final char[] cbuf, final int off, final int len) throws IOException {
            if (this.closed) {
                throw new IOException();
            }
            if (SwingUtilities.isEventDispatchThread()) {
                StreamTerm.this.putChars(cbuf, off, len);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){
                        final /* synthetic */ TermWriter this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.StreamTerm.this.putChars(cbuf, off, len);
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    Logger.getLogger(StreamTerm.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.flush();
            this.closed = true;
        }
    }
}

