/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaUtil;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.RestClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.wadl.Application;
import org.netbeans.modules.websvc.saas.model.wadl.Method;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.filesystems.FileObject;

public class SaasClientJavaAuthenticationGenerator
extends SaasClientAuthenticationGenerator {
    private JavaSource loginJS;
    private JavaSource callbackJS;
    private JavaSource saasAuthJS;
    private FileObject saasAuthFile;
    private FileObject loginFile;
    private FileObject callbackFile;

    public SaasClientJavaAuthenticationGenerator(SaasBean bean, Project project) {
        super(bean, project);
    }

    public String getPreAuthenticationCode() {
        String methodBody = "";
        Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.API_KEY) {
            methodBody = methodBody + "        String apiKey = " + this.getBean().getAuthenticatorClassName() + ".getApiKey();";
        } else if (authType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            methodBody = methodBody + "        " + this.getBean().getAuthenticatorClassName() + ".login(" + this.getLoginArguments() + ");\n";
            List signParams = sessionKey.getParameters();
            String paramStr = "";
            if (signParams != null && signParams.size() > 0) {
                paramStr = Util.getSignParamDeclaration((SaasBean)this.getBean(), (List)signParams, Collections.emptyList());
            }
            String sigName = sessionKey.getSigKeyName();
            paramStr = paramStr + "        String " + Util.getVariableName((String)sigName) + " = " + this.getBean().getAuthenticatorClassName() + ".sign(\n";
            paramStr = paramStr + "                new String[][] {";
            for (ParameterInfo p : this.getBean().getInputParameters()) {
                if (p.getName().equals(sigName)) continue;
                paramStr = paramStr + "                    {\"" + p.getName() + "\", " + Util.getVariableName((String)p.getName()) + "}, ";
            }
            if (this.getBean().getInputParameters().size() > 0) {
                paramStr = paramStr.substring(0, paramStr.length() - 2);
            }
            paramStr = paramStr + "});\n";
            methodBody = methodBody + paramStr;
        } else if (authType == Constants.SaasAuthenticationType.HTTP_BASIC) {
            SaasBean.HttpBasicAuthentication httpBasic = (SaasBean.HttpBasicAuthentication)this.getBean().getAuthentication();
            methodBody = methodBody + "        " + this.getBean().getAuthenticatorClassName() + ".login(" + this.getLoginArguments() + ");\n";
        }
        return methodBody;
    }

    public String getPostAuthenticationCode() {
        SaasBean.SignedUrlAuthentication signedUrl;
        List signParams;
        String methodBody = "";
        Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
        if (authType == Constants.SaasAuthenticationType.SIGNED_URL && (signParams = (signedUrl = (SaasBean.SignedUrlAuthentication)this.getBean().getAuthentication()).getParameters()) != null && signParams.size() > 0) {
            String paramStr = Util.getSignParamDeclaration((SaasBean)this.getBean(), (List)signParams, (List)this.getBean().getInputParameters());
            paramStr = paramStr + "        String " + Util.getVariableName((String)signedUrl.getSigKeyName()) + " = " + this.getBean().getAuthenticatorClassName() + ".sign(\n";
            paramStr = paramStr + "                new String[][] {";
            for (ParameterInfo p : signParams) {
                paramStr = paramStr + "                    {\"" + p.getName() + "\", " + Util.getVariableName((String)p.getName()) + "}, ";
            }
            if (this.getBean().getInputParameters().size() > 0) {
                paramStr = paramStr.substring(0, paramStr.length() - 2);
            }
            paramStr = paramStr + "});\n";
            methodBody = methodBody + paramStr;
        }
        return methodBody;
    }

    public void createAuthenticatorClass() throws IOException {
        FileObject targetFolder;
        block19: {
            block18: {
                targetFolder = this.getSaasServiceFolder();
                if (this.getBean().isUseTemplates()) break block18;
                if (this.saasAuthFile != null) break block19;
                String authFileName = this.getBean().getAuthenticatorClassName();
                String authTemplate = null;
                Constants.SaasAuthenticationType authType = this.getBean().getAuthenticationType();
                if (authType == Constants.SaasAuthenticationType.API_KEY) {
                    authTemplate = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                } else if (authType == Constants.SaasAuthenticationType.HTTP_BASIC) {
                    authTemplate = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                } else if (authType == Constants.SaasAuthenticationType.SIGNED_URL) {
                    authTemplate = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                } else if (authType == Constants.SaasAuthenticationType.SESSION_KEY) {
                    authTemplate = "Templates/SaaSServices/" + this.getAuthenticationType().getClassIdentifier();
                }
                if (authTemplate == null) break block19;
                this.saasAuthJS = JavaSourceHelper.createJavaSource(authTemplate + "Authenticator" + "." + "java", targetFolder, this.getBean().getSaasServicePackageName(), authFileName);
                HashSet files = new HashSet(this.saasAuthJS.getFileObjects());
                if (files == null || files.size() <= 0) break block19;
                this.saasAuthFile = (FileObject)files.iterator().next();
                break block19;
            }
            SaasBean.SaasAuthentication.UseTemplates useTemplates = null;
            if (this.getBean().getAuthentication() instanceof SaasBean.SessionKeyAuthentication) {
                SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
                useTemplates = sessionKey.getUseTemplates();
            } else if (this.getBean().getAuthentication() instanceof SaasBean.HttpBasicAuthentication) {
                SaasBean.HttpBasicAuthentication httpBasic = (SaasBean.HttpBasicAuthentication)this.getBean().getAuthentication();
                useTemplates = httpBasic.getUseTemplates();
            }
            if (useTemplates != null) {
                for (SaasBean.SaasAuthentication.UseTemplates.Template template : useTemplates.getTemplates()) {
                    FileObject fobj;
                    if (!template.getDropTypeList().contains(this.getDropFileType().prefix())) continue;
                    String id = template.getId();
                    String type = template.getType();
                    String templateUrl = template.getUrl();
                    if (!templateUrl.contains("Desktop")) continue;
                    String fileName = null;
                    if (!templateUrl.contains("Authenticator")) continue;
                    fileName = this.getBean().getAuthenticatorClassName();
                    if (templateUrl.endsWith(".java")) {
                        JavaSourceHelper.createJavaSource(templateUrl, targetFolder, this.getBean().getSaasServicePackageName(), fileName);
                        continue;
                    }
                    if (templateUrl.indexOf("/") != -1) {
                        fileName = this.getBean().getSaasName() + templateUrl.substring(templateUrl.lastIndexOf("/") + 1);
                    }
                    if (fileName == null || (fobj = targetFolder.getFileObject(fileName)) != null) continue;
                    Util.createDataObjectFromTemplate((String)templateUrl, (FileObject)targetFolder, (String)fileName);
                }
            }
        }
        if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.PLAIN) {
            String profileName = this.getBean().getAuthenticatorClassName().toLowerCase();
            if (this.getAuthenticationProfile() != null && !this.getAuthenticationProfile().trim().equals("")) {
                try {
                    Util.createDataObjectFromTemplate((String)this.getAuthenticationProfile(), (FileObject)targetFolder, (String)profileName);
                }
                catch (Exception ex) {
                    throw new IOException("Profile file specified in saas-services/service-metadata/authentication/@profile, not found: " + this.getAuthenticationProfile());
                }
            }
        }
    }

    public void createAuthorizationClasses() throws IOException {
    }

    public void modifyAuthenticationClass() throws IOException {
        if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
            return;
        }
        Modifier[] modifiers = JavaUtil.PUBLIC_STATIC;
        Object[] throwList = null;
        SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
        if (sessionKey.getUseGenerator() != null) {
            SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKey.getUseGenerator();
            String methodName = "getSessionKey";
            String comment = "";
            String bodyText = "";
            String returnType = null;
            if (sessionKey.getSessionKeyName() != null) {
                String name = Util.getParameterName((String)sessionKey.getSessionKeyName(), (boolean)true, (boolean)true);
                ArrayList<ParameterInfo> fields = new ArrayList<ParameterInfo>();
                fields.add(new ParameterInfo(name, String.class));
                Modifier[] modifier = JavaUtil.PRIVATE_STATIC;
                JavaUtil.addInputParamFields(this.saasAuthJS, fields, modifier);
                methodName = Util.getSessionKeyMethodName((String)name);
                comment = methodName + "\n";
                returnType = "String";
                bodyText = "return " + name + ";\n";
                if (bodyText != null) {
                    this.modifyAuthenticationClass(comment, (Object[])modifiers, returnType, methodName, null, null, throwList, bodyText);
                }
            }
            returnType = "void";
            methodName = "login";
            comment = methodName + "\n";
            List filterParams = this.getAuthenticatorMethodParameters();
            String[] parameters = Util.getGetParamNames((List)filterParams);
            Object[] paramTypes = Util.getGetParamTypes((List)filterParams);
            bodyText = this.getLoginBody(this.getBean(), this.getBean().getDisplayName(), "queryParams");
            if (bodyText != null) {
                this.modifyAuthenticationClass(comment, (Object[])modifiers, returnType, methodName, parameters, paramTypes, throwList, bodyText);
            }
            methodName = Util.getTokenMethodName((SaasBean.SaasAuthentication.UseGenerator)useGenerator);
            comment = methodName + "\n";
            returnType = "String";
            bodyText = this.getTokenBody(this.getBean(), this.getBean().getDisplayName(), "queryParams", this.getBean().getSaasServicePackageName());
            if (bodyText != null) {
                this.modifyAuthenticationClass(comment, (Object[])modifiers, returnType, methodName, parameters, paramTypes, throwList, bodyText);
            }
            methodName = "logout";
            comment = methodName + "\n";
            returnType = "void";
            bodyText = this.getLogoutBody();
            if (bodyText != null) {
                this.modifyAuthenticationClass(comment, (Object[])modifiers, returnType, methodName, parameters, paramTypes, throwList, bodyText);
            }
        }
    }

    public void modifyAuthenticationClass(final String comment, final Object[] modifiers, final Object returnType, final String name, final String[] parameters, final Object[] paramTypes, final Object[] throwList, final String bodyText) throws IOException {
        if (JavaSourceHelper.isContainsMethod(this.saasAuthJS, name, parameters, paramTypes)) {
            return;
        }
        ModificationResult result = this.saasAuthJS.runModificationTask((Task)new AbstractTask<WorkingCopy>(this){
            final /* synthetic */ SaasClientJavaAuthenticationGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy copy) throws IOException {
                copy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree initial = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                ClassTree tree = JavaSourceHelper.addMethod(copy, initial, (Modifier[])modifiers, null, null, name, returnType, parameters, paramTypes, null, null, throwList, "{ \n" + bodyText + "\n }", comment);
                copy.rewrite((Tree)initial, (Tree)tree);
            }
        });
        result.commit();
    }

    public String getLoginBody(SaasBean bean, String groupName, String paramVariableName) throws IOException {
        SaasBean.SaasAuthentication.UseGenerator.Login login;
        if (this.getBean().isDropTargetWeb()) {
            if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
                return null;
            }
            return Util.createSessionKeyLoginBodyForWeb((SaasBean)bean, (String)groupName, (String)paramVariableName);
        }
        String methodBody = "";
        SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
        SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKey.getUseGenerator();
        if (useGenerator != null && (login = useGenerator.getLogin()) != null) {
            String tokenName = Util.getTokenName((SaasBean.SaasAuthentication.UseGenerator)useGenerator);
            String tokenMethodName = Util.getTokenMethodName((SaasBean.SaasAuthentication.UseGenerator)useGenerator);
            methodBody = methodBody + "        if (" + Util.getVariableName((String)sessionKey.getSessionKeyName()) + " == null) {\n";
            methodBody = methodBody + "            String " + tokenName + " = " + tokenMethodName + "(" + Util.getHeaderOrParameterUsage((List)this.getAuthenticatorMethodParameters()) + ");\n\n";
            methodBody = methodBody + "            if (" + tokenName + " != null) {\n";
            methodBody = methodBody + "                try {\n";
            HashMap tokenMap = new HashMap();
            methodBody = methodBody + Util.getLoginBody((SaasBean.SaasAuthentication.UseGenerator.Login)login, (SaasBean)this.getBean(), (String)groupName, tokenMap);
            methodBody = methodBody + "                } catch (IOException ex) {\n";
            methodBody = methodBody + "                    Logger.getLogger(" + this.getBean().getAuthenticatorClassName() + ".class.getName()).log(Level.SEVERE, null, ex);\n";
            methodBody = methodBody + "                }\n\n";
            methodBody = methodBody + "            }\n";
            methodBody = methodBody + "        }\n";
        }
        return methodBody;
    }

    public String getLogoutBody() {
        String methodBody = "";
        return methodBody;
    }

    /*
     * WARNING - void declaration
     */
    public String getTokenBody(SaasBean bean, String groupName, String paramVariableName, String saasServicePkgName) throws IOException {
        SaasBean.SaasAuthentication.UseGenerator.Token token;
        if (this.getBean().isDropTargetWeb()) {
            if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.SESSION_KEY) {
                return null;
            }
            return Util.createSessionKeyTokenBodyForWeb((SaasBean)bean, (String)groupName, (String)paramVariableName, (String)saasServicePkgName);
        }
        String authFileName = this.getBean().getAuthorizationFrameClassName();
        String methodBody = "";
        SaasBean.SessionKeyAuthentication sessionKey = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
        SaasBean.SaasAuthentication.UseGenerator useGenerator = sessionKey.getUseGenerator();
        if (useGenerator != null && (token = useGenerator.getToken()) != null) {
            String tokenName = Util.getTokenName((SaasBean.SaasAuthentication.UseGenerator)useGenerator);
            String sigId = "sig";
            if (token.getSignId() != null) {
                sigId = token.getSignId();
            }
            String methodName = null;
            SaasBean.SaasAuthentication.UseGenerator.Method method = token.getMethod();
            if (method != null) {
                methodName = method.getHref();
                if (methodName == null) {
                    return methodBody;
                }
                methodName = methodName.startsWith("#") ? methodName.substring(1) : methodName;
            }
            methodBody = methodBody + "       String " + tokenName + " = null;\n";
            methodBody = methodBody + "       try {\n";
            methodBody = methodBody + "            String method = \"" + methodName + "\";\n";
            methodBody = methodBody + "            String v = \"1.0\";\n\n";
            List signParams = token.getParameters();
            if (signParams != null && signParams.size() > 0) {
                String paramStr = "";
                paramStr = paramStr + "        String " + sigId + " = sign(secret, \n";
                paramStr = paramStr + this.getSignParamUsage(signParams, groupName);
                paramStr = paramStr + ");\n\n";
                methodBody = methodBody + paramStr;
            }
            String queryParamsCode = "";
            HashMap<String, String> tokenMap = new HashMap<String, String>();
            if (method != null) {
                ArrayList params;
                Method method2;
                Object href;
                String id = method.getId();
                if (id != null) {
                    String[] tokens;
                    for (String tk : tokens = id.split(",")) {
                        String[] tokenElem = tk.split("=");
                        if (tokenElem.length != 2) continue;
                        tokenMap.put(tokenElem[0], tokenElem[1]);
                    }
                }
                if ((href = method.getHref()) != null && bean instanceof RestClientSaasBean && (method2 = SaasUtil.wadlMethodFromIdRef((Application)((RestClientSaasBean)bean).getMethod().getSaas().getWadlModel(), (String)href)) != null && (params = ((RestClientSaasBean)bean).findWadlParams(method2)) != null && params.size() > 0) {
                    queryParamsCode = Util.getHeaderOrParameterDefinition((List)params, (String)paramVariableName, (boolean)false);
                }
            }
            methodBody = methodBody + "        " + queryParamsCode;
            String url = "";
            if (bean instanceof RestClientSaasBean) {
                url = ((RestClientSaasBean)bean).getUrl();
            }
            methodBody = methodBody + "             RestConnection conn = new RestConnection(\"" + url + "\"";
            if (!queryParamsCode.trim().equals("")) {
                methodBody = methodBody + ", " + paramVariableName;
            }
            methodBody = methodBody + ");\n";
            methodBody = methodBody + "            String result = conn.get();\n";
            for (Map.Entry entry : tokenMap.entrySet()) {
                String name = Util.getVariableName((String)((String)entry.getKey()));
                String val = (String)entry.getValue();
                if (val.startsWith("{")) {
                    val = val.substring(1);
                }
                if (val.endsWith("}")) {
                    val = val.substring(0, val.length() - 1);
                }
                methodBody = methodBody + "            " + name + " = result.substring(result.indexOf(\"<" + val + "\"),\n";
                methodBody = methodBody + "                            result.indexOf(\"</" + val + ">\"));\n\n";
                methodBody = methodBody + "            " + name + " = " + name + ".substring(" + name + ".indexOf(\">\") + 1);\n\n";
            }
            if (token.getPrompt() != null) {
                SaasBean.SaasAuthentication.UseGenerator.Token.Prompt prompt = token.getPrompt();
                signParams = prompt.getParameters();
                if (signParams != null && signParams.size() > 0) {
                    void var19_27;
                    methodBody = methodBody + "            String perms = \"write\";";
                    String string3 = "";
                    string3 = string3 + "        " + sigId + " = sign(\n";
                    string3 = string3 + "                new String[][] {\n";
                    for (ParameterInfo p : signParams) {
                        String string4 = (String)var19_27 + "                    {\"" + p.getName() + "\", " + Util.getParameterName((ParameterInfo)p, (boolean)true, (boolean)true) + "},\n";
                    }
                    String string5 = (String)var19_27 + "        });\n\n";
                    methodBody = methodBody + string5;
                }
                url = prompt.getDesktopUrl();
                methodBody = methodBody + "            String loginUrl = \"" + Util.getTokenPromptUrl((SaasBean.SaasAuthentication.UseGenerator.Token)token, (String)url) + "\";\n";
            }
            methodBody = methodBody + "            " + authFileName + " frame = new " + authFileName + "(loginUrl);\n";
            methodBody = methodBody + "            synchronized (frame) {\n";
            methodBody = methodBody + "                try {\n";
            methodBody = methodBody + "                    frame.wait();\n";
            methodBody = methodBody + "                } catch (InterruptedException ex) {\n";
            methodBody = methodBody + "                    Logger.getLogger(" + this.getBean().getAuthenticatorClassName() + ".class.getName()).log(Level.SEVERE, null, ex);\n";
            methodBody = methodBody + "                }\n";
            methodBody = methodBody + "            }\n";
            methodBody = methodBody + "       } catch (IOException ex) {\n";
            methodBody = methodBody + "            Logger.getLogger(" + this.getBean().getAuthenticatorClassName() + ".class.getName()).log(Level.SEVERE, null, ex);\n";
            methodBody = methodBody + "       }\n\n";
            methodBody = methodBody + "       return " + tokenName + ";\n";
        }
        return methodBody;
    }

    public String getSignParamUsage(List<ParameterInfo> signParams, String groupName) {
        return Util.getSignParamUsage(signParams, (String)groupName, (boolean)this.getBean().isDropTargetWeb());
    }
}

