/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import org.netbeans.lib.profiler.results.locks.ThreadInfo;

final class ThreadInfos {
    ThreadInfo[] threadInfos;
    int threadInfosLastIdx;
    ThreadInfo unknownThread = new ThreadInfo(-1, "Unknown", "N/A");

    ThreadInfos() {
        this.reset();
    }

    boolean isEmpty() {
        if (this.threadInfos == null || this.threadInfos.length == 0) {
            return true;
        }
        for (int i = 0; i < this.threadInfos.length; ++i) {
            if (this.threadInfos[i] == null) continue;
            return false;
        }
        return true;
    }

    void newThreadInfo(int threadId, String threadName, String threadClassName) {
        if (threadId > this.threadInfosLastIdx || this.threadInfos == null) {
            int newLen = threadId + 1;
            ThreadInfo[] newInfos = new ThreadInfo[newLen];
            if (this.threadInfos != null) {
                System.arraycopy(this.threadInfos, 0, newInfos, 0, this.threadInfos.length);
            }
            this.threadInfos = newInfos;
            this.threadInfosLastIdx = threadId;
        }
        this.threadInfos[threadId] = new ThreadInfo(threadId, threadName, threadClassName);
    }

    void reset() {
        this.threadInfos = null;
        this.threadInfosLastIdx = -1;
    }

    ThreadInfo getThreadInfo(int threadId) {
        if (threadId == -1) {
            return this.unknownThread;
        }
        if (!this.isEmpty()) {
            return this.threadInfos[threadId];
        }
        return null;
    }
}

