/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.lib.profiler.heap.ArrayDump;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.TagBounds;

class ClassDumpSegment
extends TagBounds {
    HprofHeap hprofHeap;
    Map arrayMap;
    final int classIDOffset;
    final int classLoaderIDOffset;
    final int constantPoolSizeOffset;
    final int fieldNameIDOffset;
    final int fieldSize;
    final int fieldTypeOffset;
    final int fieldValueOffset;
    final int instanceSizeOffset;
    final int minimumInstanceSize;
    final int protectionDomainIDOffset;
    final int reserved1;
    final int reserver2;
    final int signersID;
    final int stackTraceSerialNumberOffset;
    final int superClassIDOffset;
    ClassDump java_lang_Class;
    boolean newSize;
    Map<JavaClass, List<Field>> fieldsCache;
    private List<ClassDump> classes;
    private Map<Integer, ClassDump> primitiveArrayMap;

    ClassDumpSegment(HprofHeap heap, long start, long end) {
        super(32, start, end);
        int idSize = heap.dumpBuffer.getIDSize();
        this.hprofHeap = heap;
        this.classIDOffset = 1;
        this.stackTraceSerialNumberOffset = this.classIDOffset + idSize;
        this.superClassIDOffset = this.stackTraceSerialNumberOffset + 4;
        this.classLoaderIDOffset = this.superClassIDOffset + idSize;
        this.signersID = this.classLoaderIDOffset + idSize;
        this.protectionDomainIDOffset = this.signersID + idSize;
        this.reserved1 = this.protectionDomainIDOffset + idSize;
        this.reserver2 = this.reserved1 + idSize;
        this.instanceSizeOffset = this.reserver2 + idSize;
        this.constantPoolSizeOffset = this.instanceSizeOffset + 4;
        this.fieldNameIDOffset = 0;
        this.fieldTypeOffset = this.fieldNameIDOffset + idSize;
        this.fieldValueOffset = this.fieldTypeOffset + 1;
        this.fieldSize = this.fieldTypeOffset + 1;
        this.minimumInstanceSize = 2 * idSize;
        this.fieldsCache = Collections.synchronizedMap(new FieldsCache());
    }

    ClassDump getClassDumpByID(long classObjectID) {
        if (classObjectID == 0L) {
            return null;
        }
        List<ClassDump> allClasses = this.createClassCollection();
        LongMap.Entry entry = this.hprofHeap.idToOffsetMap.get(classObjectID);
        if (entry != null) {
            try {
                ClassDump dump = allClasses.get(entry.getIndex() - 1);
                if (dump.fileOffset == entry.getOffset()) {
                    return dump;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
            catch (ClassCastException ex) {
                return null;
            }
        }
        return null;
    }

    JavaClass getJavaClassByName(String fqn) {
        for (ClassDump cls : this.createClassCollection()) {
            if (!fqn.equals(cls.getName())) continue;
            return cls;
        }
        return null;
    }

    Collection getJavaClassesByRegExp(String regexp) {
        Iterator<ClassDump> classIt = this.createClassCollection().iterator();
        ArrayList<ClassDump> result = new ArrayList<ClassDump>(256);
        Pattern pattern = Pattern.compile(regexp);
        while (classIt.hasNext()) {
            ClassDump cls = classIt.next();
            if (!pattern.matcher(cls.getName()).matches()) continue;
            result.add(cls);
        }
        return result;
    }

    int getMinimumInstanceSize() {
        return this.minimumInstanceSize;
    }

    ClassDump getPrimitiveArrayClass(byte type) {
        ClassDump primitiveArray = this.primitiveArrayMap.get(type);
        if (primitiveArray == null) {
            throw new IllegalArgumentException("Invalid type " + type);
        }
        return primitiveArray;
    }

    Map getClassIdToClassMap() {
        List<ClassDump> allClasses = this.createClassCollection();
        HashMap<Long, ClassDump> map = new HashMap<Long, ClassDump>(allClasses.size() * 4 / 3);
        for (ClassDump cls : allClasses) {
            map.put(cls.getJavaClassId(), cls);
        }
        return map;
    }

    void addInstanceSize(ClassDump cls, int tag, long instanceOffset) {
        if (tag == 34 || tag == 35) {
            Long sizeLong = (Long)this.arrayMap.get(cls);
            long size = 0L;
            HprofByteBuffer dumpBuffer = this.hprofHeap.dumpBuffer;
            int idSize = dumpBuffer.getIDSize();
            long elementsOffset = instanceOffset + 1L + (long)idSize + 4L;
            if (sizeLong != null) {
                size = sizeLong;
            }
            int elements = dumpBuffer.getInt(elementsOffset);
            int elSize = tag == 35 ? this.hprofHeap.getValueSize(dumpBuffer.get(elementsOffset + 4L)) : idSize;
            this.arrayMap.put(cls, size += (long)(this.getMinimumInstanceSize() + ArrayDump.HPROF_ARRAY_OVERHEAD) + (long)elements * (long)elSize);
        }
    }

    synchronized List<ClassDump> createClassCollection() {
        if (this.classes != null) {
            return this.classes;
        }
        ArrayList<ClassDump> cls = new ArrayList<ClassDump>(1000);
        long[] offset = new long[]{this.startOffset};
        while (offset[0] < this.endOffset) {
            long start = offset[0];
            if (this.hprofHeap.readDumpTag(offset) != 32) continue;
            ClassDump classDump = new ClassDump(this, start);
            long classId = classDump.getJavaClassId();
            LongMap.Entry classEntry = this.hprofHeap.idToOffsetMap.put(classId, start);
            cls.add(classDump);
            classEntry.setIndex(cls.size());
        }
        this.classes = Collections.unmodifiableList(cls);
        this.hprofHeap.getLoadClassSegment().setLoadClassOffsets();
        this.arrayMap = new HashMap(this.classes.size() / 15);
        this.extractSpecialClasses();
        return this.classes;
    }

    void extractSpecialClasses() {
        ClassDump java_lang_Object = null;
        this.primitiveArrayMap = new HashMap<Integer, ClassDump>();
        for (ClassDump jcls : this.classes) {
            String vmName = jcls.getLoadClass().getVMName();
            Integer typeObj = null;
            switch (vmName) {
                case "[Z": {
                    typeObj = 4;
                    break;
                }
                case "[C": {
                    typeObj = 5;
                    break;
                }
                case "[F": {
                    typeObj = 6;
                    break;
                }
                case "[D": {
                    typeObj = 7;
                    break;
                }
                case "[B": {
                    typeObj = 8;
                    break;
                }
                case "[S": {
                    typeObj = 9;
                    break;
                }
                case "[I": {
                    typeObj = 10;
                    break;
                }
                case "[J": {
                    typeObj = 11;
                    break;
                }
                case "java/lang/Class": {
                    this.java_lang_Class = jcls;
                    break;
                }
                case "java/lang/Object": {
                    java_lang_Object = jcls;
                    break;
                }
                case "boolean[]": {
                    typeObj = 4;
                    break;
                }
                case "char[]": {
                    typeObj = 5;
                    break;
                }
                case "float[]": {
                    typeObj = 6;
                    break;
                }
                case "double[]": {
                    typeObj = 7;
                    break;
                }
                case "byte[]": {
                    typeObj = 8;
                    break;
                }
                case "short[]": {
                    typeObj = 9;
                    break;
                }
                case "int[]": {
                    typeObj = 10;
                    break;
                }
                case "long[]": {
                    typeObj = 11;
                    break;
                }
                case "java.lang.Class": {
                    this.java_lang_Class = jcls;
                    break;
                }
                case "java.lang.Object": {
                    java_lang_Object = jcls;
                    break;
                }
            }
            if (typeObj == null) continue;
            this.primitiveArrayMap.put(typeObj, jcls);
        }
        if (java_lang_Object != null) {
            this.newSize = java_lang_Object.getRawInstanceSize() > 0;
        }
    }

    @Override
    void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        if (this.classes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.classes.size());
            for (int i = 0; i < this.classes.size(); ++i) {
                ClassDump classDump = this.classes.get(i);
                classDump.writeToStream(out);
                Long size = (Long)this.arrayMap.get(classDump);
                out.writeBoolean(size != null);
                if (size == null) continue;
                out.writeLong(size);
            }
        }
    }

    ClassDumpSegment(HprofHeap heap, long start, long end, DataInputStream dis) throws IOException {
        this(heap, start, end);
        int classesSize = dis.readInt();
        if (classesSize != 0) {
            ArrayList<ClassDump> cls = new ArrayList<ClassDump>(classesSize);
            this.arrayMap = new HashMap(classesSize / 15);
            for (int i = 0; i < classesSize; ++i) {
                ClassDump c = new ClassDump(this, dis.readLong(), dis);
                cls.add(c);
                if (!dis.readBoolean()) continue;
                Long size = dis.readLong();
                this.arrayMap.put(c, size);
            }
            this.classes = Collections.unmodifiableList(cls);
        }
    }

    private static class FieldsCache
    extends LinkedHashMap {
        private static final int SIZE = 500;

        FieldsCache() {
            super(500, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 500;
        }
    }
}

