/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.rest.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.web.client.rest.wizard.RestPanel;
import org.netbeans.modules.websvc.rest.client.RESTExplorerPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class RestPanelVisual
extends JPanel {
    private static final String UNDERSCORE = "underscore";
    private static final String UNDERSCORE_JS_ = "underscore.js-";
    private static final String JQUERY_JS = "jquery";
    private static final String JQUERY_JS_ = "jquery-";
    private static final String BACKBONE = "backbone";
    private static final String BACKBONE_JS_ = "backbone.js-";
    private static String REST_CLIENT = "RestClient";
    private static String JS = ".js";
    private JCheckBox backboneCheckBox;
    private JButton browseButton;
    private JLabel projectLbl;
    private JTextField restProjectResource;
    private JComboBox ui;
    private JLabel uiLbl;
    private RestPanel myPanel;
    private Node myRestNode;
    private FileObject myBackbone;
    private FileObject myUnderscore;
    private FileObject myJQuery;

    public RestPanelVisual(RestPanel panel) {
        this.myPanel = panel;
        this.initComponents();
        String jsName = this.suggestJsName(panel.getDescriptor());
        Templates.setTargetName((WizardDescriptor)panel.getDescriptor(), (String)jsName);
        this.ui.setModel(new DefaultComboBoxModel<RestPanel.JsUi>(RestPanel.JsUi.values()));
        this.backboneCheckBox.setVisible(false);
    }

    private void initComponents() {
        this.restProjectResource = new JTextField();
        this.browseButton = new JButton();
        this.backboneCheckBox = new JCheckBox();
        this.projectLbl = new JLabel();
        this.uiLbl = new JLabel();
        this.ui = new JComboBox();
        this.restProjectResource.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(RestPanelVisual.class, (String)"LBL_BrowseProject"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RestPanelVisual.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.backboneCheckBox, (String)NbBundle.getMessage(RestPanelVisual.class, (String)"LBL_Backbone"));
        this.projectLbl.setLabelFor(this.restProjectResource);
        Mnemonics.setLocalizedText((JLabel)this.projectLbl, (String)NbBundle.getMessage(RestPanelVisual.class, (String)"LBL_Project"));
        Mnemonics.setLocalizedText((JLabel)this.uiLbl, (String)NbBundle.getMessage(RestPanelVisual.class, (String)"LBL_GeneratedUI"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.projectLbl, -2, 119, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.uiLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.restProjectResource, -1, 259, Short.MAX_VALUE).addComponent(this.ui, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton, -2, 91, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.backboneCheckBox, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.restProjectResource, -2, -1, -2).addComponent(this.browseButton).addComponent(this.projectLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ui, -2, -1, -2).addComponent(this.uiLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.backboneCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.restProjectResource.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RestPanelVisual.class, (String)"ACSN_ProjectPath"));
        this.restProjectResource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestPanelVisual.class, (String)"ACSD_ProjectPath"));
        this.browseButton.getAccessibleContext().setAccessibleName("Browse");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(RestPanelVisual.class).getString("A11Y_BrowseWSDLProject"));
        this.backboneCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RestPanelVisual.class, (String)"ACSN_Backbone"));
        this.backboneCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestPanelVisual.class, (String)"ACSD_Backbone"));
        this.projectLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RestPanelVisual.class, (String)"ACSN_Project"));
        this.projectLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestPanelVisual.class, (String)"ACSD_Project"));
        this.uiLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RestPanelVisual.class, (String)"ACSN_GeneratedUI"));
        this.uiLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestPanelVisual.class, (String)"ACSD_GeneratedUI"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RestPanelVisual.class, (String)"LBL_RestSource"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.browseProjectServices();
        this.myPanel.fireChangeEvent();
    }

    private void browseProjectServices() {
        RESTExplorerPanel panel = new RESTExplorerPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(RestPanelVisual.class, (String)"TTL_RESTResources"));
        panel.setDescriptor(descriptor);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor).equals(NotifyDescriptor.OK_OPTION)) {
            this.myRestNode = panel.getSelectedService();
            this.restProjectResource.setText(this.myRestNode.getDisplayName());
        }
    }

    void store(WizardDescriptor descriptor) {
        descriptor.putProperty(BACKBONE, (Object)this.backboneCheckBox.isSelected());
        descriptor.putProperty("existed-backbone", (Object)this.myBackbone);
        descriptor.putProperty("existed-underscore", (Object)this.myUnderscore);
        descriptor.putProperty("existed-jquery", (Object)this.myJQuery);
        descriptor.putProperty("ui", this.ui.getSelectedItem());
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.myBackbone = null;
        Object fileName = wizardDescriptor.getProperty("js-file-name");
        String jsName = null;
        jsName = fileName == null ? this.suggestJsName(wizardDescriptor) : fileName.toString();
        Templates.setTargetName((WizardDescriptor)wizardDescriptor, (String)jsName);
    }

    private String suggestJsName(WizardDescriptor descriptor) {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)descriptor);
        String suggestName = REST_CLIENT;
        if (targetFolder == null) {
            return suggestName;
        }
        FileObject restClient = null;
        int count = 0;
        String result = null;
        while (true) {
            if ((restClient = targetFolder.getFileObject(suggestName + JS)) == null) break;
            suggestName = REST_CLIENT + ++count;
        }
        result = suggestName;
        return result;
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (wizardDescriptor == null) {
            return true;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        if (this.getRestNode() == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RestPanelVisual.class, (String)"ERR_NoRestResource"));
            return false;
        }
        String targetName = Templates.getTargetName((WizardDescriptor)wizardDescriptor);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
        if (targetFolder != null && targetFolder.getFileObject(targetName) != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RestPanelVisual.class, (String)"ERR_ExistedFile", (Object)targetName));
            return false;
        }
        return true;
    }

    Node getRestNode() {
        return this.myRestNode;
    }
}

