/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.util.StringValue;

public class LobHelper {
    private static final Logger LOG = Logger.getLogger(LobHelper.class.getName());
    private static final Comparator<Blob> blobComparator = new Comparator<Blob>(){

        @Override
        public int compare(Blob o1, Blob o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            try {
                return Long.compare(o1.length(), o2.length());
            }
            catch (SQLException ex) {
                return 0;
            }
        }
    };
    private static final Comparator<Clob> clobComparator = new Comparator<Clob>(){

        @Override
        public int compare(Clob o1, Clob o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String s1 = LobHelper.clobToString(o1);
            String s2 = LobHelper.clobToString(o2);
            return s1.compareToIgnoreCase(s2);
        }
    };
    private static final StringValue blobConverter = new StringValue(){

        @Override
        public String getString(Object o) {
            if (o == null) {
                return "";
            }
            if (o instanceof Blob) {
                return LobHelper.blobToString((Blob)o);
            }
            return "<Illegal value>";
        }
    };
    private static final StringValue clobConverter = new StringValue(){

        @Override
        public String getString(Object o) {
            if (o == null) {
                return "";
            }
            if (o instanceof Clob) {
                return LobHelper.clobToString((Clob)o);
            }
            return "<Illegal value>";
        }
    };

    public static Comparator<Blob> getBlobComparator() {
        return blobComparator;
    }

    public static Comparator<Clob> getClobComparator() {
        return clobComparator;
    }

    public static StringValue getBlobConverter() {
        return blobConverter;
    }

    public static StringValue getClobConverter() {
        return clobConverter;
    }

    public static String blobToString(Blob blob) {
        try {
            Long size = blob.length();
            StringBuilder stringValue = new StringBuilder();
            stringValue.append("<BLOB ");
            if (size < 1000L) {
                stringValue.append(String.format("%1$d bytes", size));
            } else if (size < 1000000L) {
                stringValue.append(String.format("%1$d kB", size / 1000L));
            } else {
                stringValue.append(String.format("%1$d MB", size / 1000000L));
            }
            stringValue.append(">");
            return stringValue.toString();
        }
        catch (SQLException ex) {
            return "<BLOB of unkown size>";
        }
    }

    public static String clobToString(Clob clobValue) {
        StringBuilder contentPart = new StringBuilder();
        try {
            long size = clobValue.length();
            long retrievalCount = Math.min(size, 255L);
            String sampleContent = clobValue.getSubString(1L, (int)retrievalCount);
            contentPart.append(sampleContent.replaceAll("[\n\r]+", " "));
            if (size > 255L) {
                contentPart.append(" [...]");
            }
            return contentPart.toString();
        }
        catch (SQLException ex) {
            LOG.log(Level.INFO, "Failed to retrieve CLOB content", ex);
            return LobHelper.clobToDescription(clobValue);
        }
    }

    public static String clobToDescription(Clob clobValue) {
        StringBuilder clobDescription = new StringBuilder("<CLOB ");
        try {
            long size = clobValue.length();
            if (size < 1000L) {
                clobDescription.append(String.format("%1$d Chars", size));
            } else if (size < 1000000L) {
                clobDescription.append(String.format("%1$d kChars", size / 1000L));
            } else {
                clobDescription.append(String.format("%1$d MChars", size / 1000000L));
            }
        }
        catch (SQLException ex) {
            clobDescription.append("of unknown size");
        }
        clobDescription.append(">");
        return clobDescription.toString();
    }
}

