/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsExecutor;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ResultProcessor {
    private static final Logger LOG = Logger.getLogger(ResultProcessor.class.getName());
    protected final GitClient client;
    protected final File repository;
    private final String revision;
    protected final ProgressMonitor pm;

    public ResultProcessor(GitClient client, File repository, String revision, ProgressMonitor pm) {
        this.client = client;
        this.repository = repository;
        this.revision = revision;
        this.pm = pm;
    }

    protected final void printConflicts(OutputLogger logger, StringBuilder sb, Collection<File> conflicts) {
        if (sb.length() > 0) {
            if (sb.charAt(sb.length() - 1) == '\n') {
                sb.delete(sb.length() - 1, sb.length());
            }
            logger.outputLine(sb.toString());
            sb.delete(0, sb.length());
        }
        for (File f : conflicts) {
            logger.outputFile(f.getAbsolutePath(), f, 0);
        }
    }

    protected final void resolveConflicts(Collection<File> conflicts) {
        JButton resolve = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)resolve, (String)NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.resolveButton.text"));
        resolve.setToolTipText(NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.resolveButton.TTtext"));
        JButton review = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)review, (String)NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.reviewButton.text"));
        review.setToolTipText(NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.reviewButton.TTtext"));
        Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(ResultProcessor.class, (String)"MSG_ResultProcessor.resolveConflicts"), NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.resolveConflicts"), 2, 3, new Object[]{resolve, review, NotifyDescriptor.CANCEL_OPTION}, (Object)resolve));
        if (o == review) {
            this.openInVersioningView(conflicts);
        } else if (o == resolve) {
            ResolveConflictsExecutor supp = new ResolveConflictsExecutor(conflicts.toArray(new File[0]));
            supp.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_PreparingMerge"));
        }
    }

    public final boolean resolveLocalChanges(String[] conflicts) throws GitException {
        return this.resolveLocalChanges(this.getFilesInConflict(conflicts));
    }

    public final boolean resolveLocalChanges(File[] localChanges) throws GitException {
        JButton revert = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)revert, (String)NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.revertButton.text"));
        revert.setToolTipText(NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.revertButton.TTtext"));
        JButton review = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)review, (String)NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.reviewButton.text"));
        review.setToolTipText(NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.reviewButton.TTtext"));
        Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(ResultProcessor.class, (String)"MSG_ResultProcessor.localModifications"), NbBundle.getMessage(ResultProcessor.class, (String)"LBL_ResultProcessor.localModifications"), 2, 3, new Object[]{revert, review, NotifyDescriptor.CANCEL_OPTION}, (Object)revert));
        if (o == revert) {
            LOG.log(Level.FINE, "Checking out paths from HEAD");
            this.client.checkout(localChanges, "HEAD", true, this.pm);
            LOG.log(Level.FINE, "Cleanup new files");
            this.client.clean(localChanges, this.pm);
            LOG.log(Level.FINE, "Checking out branch: {0}, second shot", this.revision);
            return true;
        }
        if (o == review) {
            this.openInVersioningView(Arrays.asList(localChanges));
            return false;
        }
        return false;
    }

    private File[] getFilesInConflict(String[] conflicts) {
        ArrayList<File> files = new ArrayList<File>(conflicts.length);
        for (String path : conflicts) {
            files.add(new File(this.repository, path));
        }
        return files.toArray(new File[0]);
    }

    protected final void openInVersioningView(final Collection<File> files) {
        new GitProgressSupport(this){
            final /* synthetic */ ResultProcessor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            protected void perform() {
                GitUtils.openInVersioningView(files, this.this$0.repository, this.getProgressMonitor());
            }
        }.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
    }
}

