/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.Bundle;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class Hacks {
    private static final Logger LOG = Logger.getLogger(Hacks.class.getName());
    static final RequestProcessor RP = new RequestProcessor("Project UI");

    private Hacks() {
    }

    static void keepCurrentProjectNameUpdated() {
        ResourceBundle bundle;
        final TopComponent.Registry r = TopComponent.getRegistry();
        final AtomicReference displayNameListener = new AtomicReference();
        try {
            bundle = NbBundle.getBundle((String)"org.netbeans.core.windows.view.ui.Bundle");
        }
        catch (MissingResourceException x) {
            LOG.log(Level.FINE, "Running from a unit test?", x);
            return;
        }
        final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
        final String NO_PROJECT_TITLE = MessageFormat.format(bundle.getString("CTL_MainWindow_Title_No_Project"), BUILD_NUMBER);
        final String PROJECT_TITLE_FORMAT = bundle.getString("CTL_MainWindow_Title");
        final RequestProcessor.Task task = RP.create(new Runnable(){
            String lastKnownTitle;

            @Override
            public void run() {
                String pname;
                Object[] sel = r.getActivatedNodes();
                HashSet<Project> projects = new HashSet<Project>();
                boolean noProjectsOpen = OpenProjectList.getDefault().getOpenProjects().length == 0;
                for (int i = 0; i < sel.length; ++i) {
                    FileObject f;
                    Lookup l = sel[i].getLookup();
                    Project p = (Project)l.lookup(Project.class);
                    if (p != null) {
                        projects.add(p);
                        if (!noProjectsOpen) continue;
                        LOG.log(Level.FINE, "Activated node selection {0} contains nonopen project {1} though none are open; leak? activated TC: {2} current nodes: {3} (report in issue #102805)", new Object[]{Arrays.toString(sel), p, r.getActivated(), Arrays.toString(r.getCurrentNodes())});
                        continue;
                    }
                    DataObject d = (DataObject)l.lookup(DataObject.class);
                    if (d == null || (p = ProjectConvertors.getNonConvertorOwner((FileObject)(f = d.getPrimaryFile()))) == null) continue;
                    projects.add(p);
                }
                LOG.log(Level.FINER, "found project selection: {0}", projects);
                if (projects.size() == 1) {
                    Project p = (Project)projects.iterator().next();
                    ProjectInformation info = ProjectUtils.getInformation((Project)p);
                    info.removePropertyChangeListener((PropertyChangeListener)displayNameListener.get());
                    info.addPropertyChangeListener((PropertyChangeListener)displayNameListener.get());
                    pname = info.getDisplayName();
                    assert (pname != null) : p;
                } else {
                    pname = projects.isEmpty() ? null : Bundle.LBL_MultipleProjects();
                }
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        String title = pname != null ? MessageFormat.format(PROJECT_TITLE_FORMAT, BUILD_NUMBER, pname) : NO_PROJECT_TITLE;
                        Frame mainWindow = WindowManager.getDefault().getMainWindow();
                        String currTitle = mainWindow.getTitle();
                        if (currTitle == null || currTitle.isEmpty() || currTitle.equals(this.this$0.lastKnownTitle) || currTitle.equals(NO_PROJECT_TITLE)) {
                            this.this$0.lastKnownTitle = title;
                            mainWindow.setTitle(title);
                        } else {
                            LOG.log(Level.FINE, "not replacing {0} with {1} since it was last set to {2}", new Object[]{currTitle, title, this.this$0.lastKnownTitle});
                        }
                    }
                });
            }
        });
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                task.schedule(0);
                displayNameListener.set(new PropertyChangeListener(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent ev) {
                        String prop = ev.getPropertyName();
                        if (prop == null || prop.equals("displayName")) {
                            LOG.finer("got PROP_DISPLAY_NAME");
                            task.schedule(0);
                        }
                    }
                });
                r.addPropertyChangeListener(new PropertyChangeListener(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void propertyChange(PropertyChangeEvent ev) {
                        if ("activatedNodes".equals(ev.getPropertyName())) {
                            LOG.finer("got PROP_ACTIVATED_NODES");
                            task.schedule(200);
                        }
                    }
                });
            }
        });
    }

    static void reloadPanelsInWizard(TemplateWizard tw, DataObject dobj) {
        try {
            Class<?> twClazz = Class.forName("org.openide.loaders.TemplateWizard", true, Thread.currentThread().getContextClassLoader());
            if (twClazz != null) {
                Method reloadPanels = twClazz.getDeclaredMethod("reload", DataObject.class);
                reloadPanels.setAccessible(true);
                reloadPanels.invoke((Object)tw, dobj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

