/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PhaseOneConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="isCustomPhaseOneConfig")
    private final Boolean isCustomPhaseOneConfig;
    @JsonProperty(value="authenticationAlgorithm")
    private final AuthenticationAlgorithm authenticationAlgorithm;
    @JsonProperty(value="encryptionAlgorithm")
    private final EncryptionAlgorithm encryptionAlgorithm;
    @JsonProperty(value="diffieHelmanGroup")
    private final DiffieHelmanGroup diffieHelmanGroup;
    @JsonProperty(value="lifetimeInSeconds")
    private final Integer lifetimeInSeconds;

    @Deprecated
    @ConstructorProperties(value={"isCustomPhaseOneConfig", "authenticationAlgorithm", "encryptionAlgorithm", "diffieHelmanGroup", "lifetimeInSeconds"})
    public PhaseOneConfigDetails(Boolean isCustomPhaseOneConfig, AuthenticationAlgorithm authenticationAlgorithm, EncryptionAlgorithm encryptionAlgorithm, DiffieHelmanGroup diffieHelmanGroup, Integer lifetimeInSeconds) {
        this.isCustomPhaseOneConfig = isCustomPhaseOneConfig;
        this.authenticationAlgorithm = authenticationAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.diffieHelmanGroup = diffieHelmanGroup;
        this.lifetimeInSeconds = lifetimeInSeconds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Boolean getIsCustomPhaseOneConfig() {
        return this.isCustomPhaseOneConfig;
    }

    public AuthenticationAlgorithm getAuthenticationAlgorithm() {
        return this.authenticationAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public DiffieHelmanGroup getDiffieHelmanGroup() {
        return this.diffieHelmanGroup;
    }

    public Integer getLifetimeInSeconds() {
        return this.lifetimeInSeconds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PhaseOneConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("isCustomPhaseOneConfig=").append(String.valueOf(this.isCustomPhaseOneConfig));
        sb.append(", authenticationAlgorithm=").append(String.valueOf((Object)this.authenticationAlgorithm));
        sb.append(", encryptionAlgorithm=").append(String.valueOf((Object)this.encryptionAlgorithm));
        sb.append(", diffieHelmanGroup=").append(String.valueOf((Object)this.diffieHelmanGroup));
        sb.append(", lifetimeInSeconds=").append(String.valueOf(this.lifetimeInSeconds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhaseOneConfigDetails)) {
            return false;
        }
        PhaseOneConfigDetails other = (PhaseOneConfigDetails)((Object)o);
        return Objects.equals(this.isCustomPhaseOneConfig, other.isCustomPhaseOneConfig) && Objects.equals((Object)this.authenticationAlgorithm, (Object)other.authenticationAlgorithm) && Objects.equals((Object)this.encryptionAlgorithm, (Object)other.encryptionAlgorithm) && Objects.equals((Object)this.diffieHelmanGroup, (Object)other.diffieHelmanGroup) && Objects.equals(this.lifetimeInSeconds, other.lifetimeInSeconds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCustomPhaseOneConfig == null ? 43 : this.isCustomPhaseOneConfig.hashCode());
        result = result * 59 + (this.authenticationAlgorithm == null ? 43 : this.authenticationAlgorithm.hashCode());
        result = result * 59 + (this.encryptionAlgorithm == null ? 43 : this.encryptionAlgorithm.hashCode());
        result = result * 59 + (this.diffieHelmanGroup == null ? 43 : this.diffieHelmanGroup.hashCode());
        result = result * 59 + (this.lifetimeInSeconds == null ? 43 : this.lifetimeInSeconds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DiffieHelmanGroup implements BmcEnum
    {
        Group2("GROUP2"),
        Group5("GROUP5"),
        Group14("GROUP14"),
        Group19("GROUP19"),
        Group20("GROUP20"),
        Group24("GROUP24");

        private final String value;
        private static Map<String, DiffieHelmanGroup> map;

        private DiffieHelmanGroup(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DiffieHelmanGroup create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DiffieHelmanGroup: " + key);
        }

        static {
            map = new HashMap<String, DiffieHelmanGroup>();
            for (DiffieHelmanGroup v : DiffieHelmanGroup.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EncryptionAlgorithm implements BmcEnum
    {
        Aes256Cbc("AES_256_CBC"),
        Aes192Cbc("AES_192_CBC"),
        Aes128Cbc("AES_128_CBC");

        private final String value;
        private static Map<String, EncryptionAlgorithm> map;

        private EncryptionAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EncryptionAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid EncryptionAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, EncryptionAlgorithm>();
            for (EncryptionAlgorithm v : EncryptionAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AuthenticationAlgorithm implements BmcEnum
    {
        Sha2384("SHA2_384"),
        Sha2256("SHA2_256"),
        Sha196("SHA1_96");

        private final String value;
        private static Map<String, AuthenticationAlgorithm> map;

        private AuthenticationAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuthenticationAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AuthenticationAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, AuthenticationAlgorithm>();
            for (AuthenticationAlgorithm v : AuthenticationAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="isCustomPhaseOneConfig")
        private Boolean isCustomPhaseOneConfig;
        @JsonProperty(value="authenticationAlgorithm")
        private AuthenticationAlgorithm authenticationAlgorithm;
        @JsonProperty(value="encryptionAlgorithm")
        private EncryptionAlgorithm encryptionAlgorithm;
        @JsonProperty(value="diffieHelmanGroup")
        private DiffieHelmanGroup diffieHelmanGroup;
        @JsonProperty(value="lifetimeInSeconds")
        private Integer lifetimeInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder isCustomPhaseOneConfig(Boolean isCustomPhaseOneConfig) {
            this.isCustomPhaseOneConfig = isCustomPhaseOneConfig;
            this.__explicitlySet__.add("isCustomPhaseOneConfig");
            return this;
        }

        public Builder authenticationAlgorithm(AuthenticationAlgorithm authenticationAlgorithm) {
            this.authenticationAlgorithm = authenticationAlgorithm;
            this.__explicitlySet__.add("authenticationAlgorithm");
            return this;
        }

        public Builder encryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.__explicitlySet__.add("encryptionAlgorithm");
            return this;
        }

        public Builder diffieHelmanGroup(DiffieHelmanGroup diffieHelmanGroup) {
            this.diffieHelmanGroup = diffieHelmanGroup;
            this.__explicitlySet__.add("diffieHelmanGroup");
            return this;
        }

        public Builder lifetimeInSeconds(Integer lifetimeInSeconds) {
            this.lifetimeInSeconds = lifetimeInSeconds;
            this.__explicitlySet__.add("lifetimeInSeconds");
            return this;
        }

        public PhaseOneConfigDetails build() {
            PhaseOneConfigDetails model = new PhaseOneConfigDetails(this.isCustomPhaseOneConfig, this.authenticationAlgorithm, this.encryptionAlgorithm, this.diffieHelmanGroup, this.lifetimeInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PhaseOneConfigDetails model) {
            if (model.wasPropertyExplicitlySet("isCustomPhaseOneConfig")) {
                this.isCustomPhaseOneConfig(model.getIsCustomPhaseOneConfig());
            }
            if (model.wasPropertyExplicitlySet("authenticationAlgorithm")) {
                this.authenticationAlgorithm(model.getAuthenticationAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("encryptionAlgorithm")) {
                this.encryptionAlgorithm(model.getEncryptionAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("diffieHelmanGroup")) {
                this.diffieHelmanGroup(model.getDiffieHelmanGroup());
            }
            if (model.wasPropertyExplicitlySet("lifetimeInSeconds")) {
                this.lifetimeInSeconds(model.getLifetimeInSeconds());
            }
            return this;
        }
    }
}

