/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.AttachLoadBalancerDetails;
import com.oracle.bmc.core.model.CreateInstancePoolPlacementConfigurationDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateInstancePoolDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="instanceConfigurationId")
    private final String instanceConfigurationId;
    @JsonProperty(value="placementConfigurations")
    private final List<CreateInstancePoolPlacementConfigurationDetails> placementConfigurations;
    @JsonProperty(value="size")
    private final Integer size;
    @JsonProperty(value="loadBalancers")
    private final List<AttachLoadBalancerDetails> loadBalancers;
    @JsonProperty(value="instanceDisplayNameFormatter")
    private final String instanceDisplayNameFormatter;
    @JsonProperty(value="instanceHostnameFormatter")
    private final String instanceHostnameFormatter;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "definedTags", "displayName", "freeformTags", "instanceConfigurationId", "placementConfigurations", "size", "loadBalancers", "instanceDisplayNameFormatter", "instanceHostnameFormatter"})
    public CreateInstancePoolDetails(String compartmentId, Map<String, Map<String, Object>> definedTags, String displayName, Map<String, String> freeformTags, String instanceConfigurationId, List<CreateInstancePoolPlacementConfigurationDetails> placementConfigurations, Integer size, List<AttachLoadBalancerDetails> loadBalancers, String instanceDisplayNameFormatter, String instanceHostnameFormatter) {
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.instanceConfigurationId = instanceConfigurationId;
        this.placementConfigurations = placementConfigurations;
        this.size = size;
        this.loadBalancers = loadBalancers;
        this.instanceDisplayNameFormatter = instanceDisplayNameFormatter;
        this.instanceHostnameFormatter = instanceHostnameFormatter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getInstanceConfigurationId() {
        return this.instanceConfigurationId;
    }

    public List<CreateInstancePoolPlacementConfigurationDetails> getPlacementConfigurations() {
        return this.placementConfigurations;
    }

    public Integer getSize() {
        return this.size;
    }

    public List<AttachLoadBalancerDetails> getLoadBalancers() {
        return this.loadBalancers;
    }

    public String getInstanceDisplayNameFormatter() {
        return this.instanceDisplayNameFormatter;
    }

    public String getInstanceHostnameFormatter() {
        return this.instanceHostnameFormatter;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateInstancePoolDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", instanceConfigurationId=").append(String.valueOf(this.instanceConfigurationId));
        sb.append(", placementConfigurations=").append(String.valueOf(this.placementConfigurations));
        sb.append(", size=").append(String.valueOf(this.size));
        sb.append(", loadBalancers=").append(String.valueOf(this.loadBalancers));
        sb.append(", instanceDisplayNameFormatter=").append(String.valueOf(this.instanceDisplayNameFormatter));
        sb.append(", instanceHostnameFormatter=").append(String.valueOf(this.instanceHostnameFormatter));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateInstancePoolDetails)) {
            return false;
        }
        CreateInstancePoolDetails other = (CreateInstancePoolDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.instanceConfigurationId, other.instanceConfigurationId) && Objects.equals(this.placementConfigurations, other.placementConfigurations) && Objects.equals(this.size, other.size) && Objects.equals(this.loadBalancers, other.loadBalancers) && Objects.equals(this.instanceDisplayNameFormatter, other.instanceDisplayNameFormatter) && Objects.equals(this.instanceHostnameFormatter, other.instanceHostnameFormatter) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.instanceConfigurationId == null ? 43 : this.instanceConfigurationId.hashCode());
        result = result * 59 + (this.placementConfigurations == null ? 43 : this.placementConfigurations.hashCode());
        result = result * 59 + (this.size == null ? 43 : this.size.hashCode());
        result = result * 59 + (this.loadBalancers == null ? 43 : this.loadBalancers.hashCode());
        result = result * 59 + (this.instanceDisplayNameFormatter == null ? 43 : this.instanceDisplayNameFormatter.hashCode());
        result = result * 59 + (this.instanceHostnameFormatter == null ? 43 : this.instanceHostnameFormatter.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="instanceConfigurationId")
        private String instanceConfigurationId;
        @JsonProperty(value="placementConfigurations")
        private List<CreateInstancePoolPlacementConfigurationDetails> placementConfigurations;
        @JsonProperty(value="size")
        private Integer size;
        @JsonProperty(value="loadBalancers")
        private List<AttachLoadBalancerDetails> loadBalancers;
        @JsonProperty(value="instanceDisplayNameFormatter")
        private String instanceDisplayNameFormatter;
        @JsonProperty(value="instanceHostnameFormatter")
        private String instanceHostnameFormatter;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder instanceConfigurationId(String instanceConfigurationId) {
            this.instanceConfigurationId = instanceConfigurationId;
            this.__explicitlySet__.add("instanceConfigurationId");
            return this;
        }

        public Builder placementConfigurations(List<CreateInstancePoolPlacementConfigurationDetails> placementConfigurations) {
            this.placementConfigurations = placementConfigurations;
            this.__explicitlySet__.add("placementConfigurations");
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            this.__explicitlySet__.add("size");
            return this;
        }

        public Builder loadBalancers(List<AttachLoadBalancerDetails> loadBalancers) {
            this.loadBalancers = loadBalancers;
            this.__explicitlySet__.add("loadBalancers");
            return this;
        }

        public Builder instanceDisplayNameFormatter(String instanceDisplayNameFormatter) {
            this.instanceDisplayNameFormatter = instanceDisplayNameFormatter;
            this.__explicitlySet__.add("instanceDisplayNameFormatter");
            return this;
        }

        public Builder instanceHostnameFormatter(String instanceHostnameFormatter) {
            this.instanceHostnameFormatter = instanceHostnameFormatter;
            this.__explicitlySet__.add("instanceHostnameFormatter");
            return this;
        }

        public CreateInstancePoolDetails build() {
            CreateInstancePoolDetails model = new CreateInstancePoolDetails(this.compartmentId, this.definedTags, this.displayName, this.freeformTags, this.instanceConfigurationId, this.placementConfigurations, this.size, this.loadBalancers, this.instanceDisplayNameFormatter, this.instanceHostnameFormatter);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateInstancePoolDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("instanceConfigurationId")) {
                this.instanceConfigurationId(model.getInstanceConfigurationId());
            }
            if (model.wasPropertyExplicitlySet("placementConfigurations")) {
                this.placementConfigurations(model.getPlacementConfigurations());
            }
            if (model.wasPropertyExplicitlySet("size")) {
                this.size(model.getSize());
            }
            if (model.wasPropertyExplicitlySet("loadBalancers")) {
                this.loadBalancers(model.getLoadBalancers());
            }
            if (model.wasPropertyExplicitlySet("instanceDisplayNameFormatter")) {
                this.instanceDisplayNameFormatter(model.getInstanceDisplayNameFormatter());
            }
            if (model.wasPropertyExplicitlySet("instanceHostnameFormatter")) {
                this.instanceHostnameFormatter(model.getInstanceHostnameFormatter());
            }
            return this;
        }
    }
}

