/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AllowedPhaseTwoParameters
extends ExplicitlySetBmcModel {
    @JsonProperty(value="encryptionAlgorithms")
    private final List<String> encryptionAlgorithms;
    @JsonProperty(value="authenticationAlgorithms")
    private final List<String> authenticationAlgorithms;
    @JsonProperty(value="pfsDhGroups")
    private final List<String> pfsDhGroups;

    @Deprecated
    @ConstructorProperties(value={"encryptionAlgorithms", "authenticationAlgorithms", "pfsDhGroups"})
    public AllowedPhaseTwoParameters(List<String> encryptionAlgorithms, List<String> authenticationAlgorithms, List<String> pfsDhGroups) {
        this.encryptionAlgorithms = encryptionAlgorithms;
        this.authenticationAlgorithms = authenticationAlgorithms;
        this.pfsDhGroups = pfsDhGroups;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getEncryptionAlgorithms() {
        return this.encryptionAlgorithms;
    }

    public List<String> getAuthenticationAlgorithms() {
        return this.authenticationAlgorithms;
    }

    public List<String> getPfsDhGroups() {
        return this.pfsDhGroups;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AllowedPhaseTwoParameters(");
        sb.append("super=").append(super.toString());
        sb.append("encryptionAlgorithms=").append(String.valueOf(this.encryptionAlgorithms));
        sb.append(", authenticationAlgorithms=").append(String.valueOf(this.authenticationAlgorithms));
        sb.append(", pfsDhGroups=").append(String.valueOf(this.pfsDhGroups));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AllowedPhaseTwoParameters)) {
            return false;
        }
        AllowedPhaseTwoParameters other = (AllowedPhaseTwoParameters)((Object)o);
        return Objects.equals(this.encryptionAlgorithms, other.encryptionAlgorithms) && Objects.equals(this.authenticationAlgorithms, other.authenticationAlgorithms) && Objects.equals(this.pfsDhGroups, other.pfsDhGroups) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.encryptionAlgorithms == null ? 43 : this.encryptionAlgorithms.hashCode());
        result = result * 59 + (this.authenticationAlgorithms == null ? 43 : this.authenticationAlgorithms.hashCode());
        result = result * 59 + (this.pfsDhGroups == null ? 43 : this.pfsDhGroups.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="encryptionAlgorithms")
        private List<String> encryptionAlgorithms;
        @JsonProperty(value="authenticationAlgorithms")
        private List<String> authenticationAlgorithms;
        @JsonProperty(value="pfsDhGroups")
        private List<String> pfsDhGroups;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder encryptionAlgorithms(List<String> encryptionAlgorithms) {
            this.encryptionAlgorithms = encryptionAlgorithms;
            this.__explicitlySet__.add("encryptionAlgorithms");
            return this;
        }

        public Builder authenticationAlgorithms(List<String> authenticationAlgorithms) {
            this.authenticationAlgorithms = authenticationAlgorithms;
            this.__explicitlySet__.add("authenticationAlgorithms");
            return this;
        }

        public Builder pfsDhGroups(List<String> pfsDhGroups) {
            this.pfsDhGroups = pfsDhGroups;
            this.__explicitlySet__.add("pfsDhGroups");
            return this;
        }

        public AllowedPhaseTwoParameters build() {
            AllowedPhaseTwoParameters model = new AllowedPhaseTwoParameters(this.encryptionAlgorithms, this.authenticationAlgorithms, this.pfsDhGroups);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AllowedPhaseTwoParameters model) {
            if (model.wasPropertyExplicitlySet("encryptionAlgorithms")) {
                this.encryptionAlgorithms(model.getEncryptionAlgorithms());
            }
            if (model.wasPropertyExplicitlySet("authenticationAlgorithms")) {
                this.authenticationAlgorithms(model.getAuthenticationAlgorithms());
            }
            if (model.wasPropertyExplicitlySet("pfsDhGroups")) {
                this.pfsDhGroups(model.getPfsDhGroups());
            }
            return this;
        }
    }
}

