/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.ComputeManagementAsync;
import com.oracle.bmc.core.model.ClusterNetwork;
import com.oracle.bmc.core.model.ClusterNetworkSummary;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.core.model.InstanceConfiguration;
import com.oracle.bmc.core.model.InstanceConfigurationSummary;
import com.oracle.bmc.core.model.InstancePool;
import com.oracle.bmc.core.model.InstancePoolInstance;
import com.oracle.bmc.core.model.InstancePoolLoadBalancerAttachment;
import com.oracle.bmc.core.model.InstancePoolSummary;
import com.oracle.bmc.core.model.InstanceSummary;
import com.oracle.bmc.core.requests.AttachInstancePoolInstanceRequest;
import com.oracle.bmc.core.requests.AttachLoadBalancerRequest;
import com.oracle.bmc.core.requests.ChangeClusterNetworkCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceConfigurationCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstancePoolCompartmentRequest;
import com.oracle.bmc.core.requests.CreateClusterNetworkRequest;
import com.oracle.bmc.core.requests.CreateInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.CreateInstancePoolRequest;
import com.oracle.bmc.core.requests.DeleteInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.DetachInstancePoolInstanceRequest;
import com.oracle.bmc.core.requests.DetachLoadBalancerRequest;
import com.oracle.bmc.core.requests.GetClusterNetworkRequest;
import com.oracle.bmc.core.requests.GetInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.GetInstancePoolInstanceRequest;
import com.oracle.bmc.core.requests.GetInstancePoolLoadBalancerAttachmentRequest;
import com.oracle.bmc.core.requests.GetInstancePoolRequest;
import com.oracle.bmc.core.requests.LaunchInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.ListClusterNetworkInstancesRequest;
import com.oracle.bmc.core.requests.ListClusterNetworksRequest;
import com.oracle.bmc.core.requests.ListInstanceConfigurationsRequest;
import com.oracle.bmc.core.requests.ListInstancePoolInstancesRequest;
import com.oracle.bmc.core.requests.ListInstancePoolsRequest;
import com.oracle.bmc.core.requests.ResetInstancePoolRequest;
import com.oracle.bmc.core.requests.SoftresetInstancePoolRequest;
import com.oracle.bmc.core.requests.SoftstopInstancePoolRequest;
import com.oracle.bmc.core.requests.StartInstancePoolRequest;
import com.oracle.bmc.core.requests.StopInstancePoolRequest;
import com.oracle.bmc.core.requests.TerminateClusterNetworkRequest;
import com.oracle.bmc.core.requests.TerminateInstancePoolRequest;
import com.oracle.bmc.core.requests.UpdateClusterNetworkRequest;
import com.oracle.bmc.core.requests.UpdateInstanceConfigurationRequest;
import com.oracle.bmc.core.requests.UpdateInstancePoolRequest;
import com.oracle.bmc.core.responses.AttachInstancePoolInstanceResponse;
import com.oracle.bmc.core.responses.AttachLoadBalancerResponse;
import com.oracle.bmc.core.responses.ChangeClusterNetworkCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceConfigurationCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstancePoolCompartmentResponse;
import com.oracle.bmc.core.responses.CreateClusterNetworkResponse;
import com.oracle.bmc.core.responses.CreateInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.CreateInstancePoolResponse;
import com.oracle.bmc.core.responses.DeleteInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.DetachInstancePoolInstanceResponse;
import com.oracle.bmc.core.responses.DetachLoadBalancerResponse;
import com.oracle.bmc.core.responses.GetClusterNetworkResponse;
import com.oracle.bmc.core.responses.GetInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.GetInstancePoolInstanceResponse;
import com.oracle.bmc.core.responses.GetInstancePoolLoadBalancerAttachmentResponse;
import com.oracle.bmc.core.responses.GetInstancePoolResponse;
import com.oracle.bmc.core.responses.LaunchInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.ListClusterNetworkInstancesResponse;
import com.oracle.bmc.core.responses.ListClusterNetworksResponse;
import com.oracle.bmc.core.responses.ListInstanceConfigurationsResponse;
import com.oracle.bmc.core.responses.ListInstancePoolInstancesResponse;
import com.oracle.bmc.core.responses.ListInstancePoolsResponse;
import com.oracle.bmc.core.responses.ResetInstancePoolResponse;
import com.oracle.bmc.core.responses.SoftresetInstancePoolResponse;
import com.oracle.bmc.core.responses.SoftstopInstancePoolResponse;
import com.oracle.bmc.core.responses.StartInstancePoolResponse;
import com.oracle.bmc.core.responses.StopInstancePoolResponse;
import com.oracle.bmc.core.responses.TerminateClusterNetworkResponse;
import com.oracle.bmc.core.responses.TerminateInstancePoolResponse;
import com.oracle.bmc.core.responses.UpdateClusterNetworkResponse;
import com.oracle.bmc.core.responses.UpdateInstanceConfigurationResponse;
import com.oracle.bmc.core.responses.UpdateInstancePoolResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeManagementAsyncClient
extends BaseAsyncClient
implements ComputeManagementAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTEMANAGEMENT").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ComputeManagementAsyncClient.class);

    ComputeManagementAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AttachInstancePoolInstanceResponse> attachInstancePoolInstance(AttachInstancePoolInstanceRequest request, AsyncHandler<AttachInstancePoolInstanceRequest, AttachInstancePoolInstanceResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachInstancePoolInstanceDetails(), "attachInstancePoolInstanceDetails is required");
        return this.clientCall(request, AttachInstancePoolInstanceResponse::builder).logger(LOG, "attachInstancePoolInstance").serviceDetails("ComputeManagement", "AttachInstancePoolInstance", "").method(Method.POST).requestBuilder(AttachInstancePoolInstanceRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("instances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InstancePoolInstance.class, AttachInstancePoolInstanceResponse.Builder::instancePoolInstance).handleResponseHeaderString("opc-request-id", AttachInstancePoolInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("etag", AttachInstancePoolInstanceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", AttachInstancePoolInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", AttachInstancePoolInstanceResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<AttachLoadBalancerResponse> attachLoadBalancer(AttachLoadBalancerRequest request, AsyncHandler<AttachLoadBalancerRequest, AttachLoadBalancerResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAttachLoadBalancerDetails(), "attachLoadBalancerDetails is required");
        return this.clientCall(request, AttachLoadBalancerResponse::builder).logger(LOG, "attachLoadBalancer").serviceDetails("ComputeManagement", "AttachLoadBalancer", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/AttachLoadBalancer").method(Method.POST).requestBuilder(AttachLoadBalancerRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("attachLoadBalancer").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(InstancePool.class, AttachLoadBalancerResponse.Builder::instancePool).handleResponseHeaderString("etag", AttachLoadBalancerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AttachLoadBalancerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeClusterNetworkCompartmentResponse> changeClusterNetworkCompartment(ChangeClusterNetworkCompartmentRequest request, AsyncHandler<ChangeClusterNetworkCompartmentRequest, ChangeClusterNetworkCompartmentResponse> handler) {
        Validate.notBlank((String)request.getClusterNetworkId(), (String)"clusterNetworkId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeClusterNetworkCompartmentDetails(), "changeClusterNetworkCompartmentDetails is required");
        return this.clientCall(request, ChangeClusterNetworkCompartmentResponse::builder).logger(LOG, "changeClusterNetworkCompartment").serviceDetails("ComputeManagement", "ChangeClusterNetworkCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ClusterNetwork/ChangeClusterNetworkCompartment").method(Method.POST).requestBuilder(ChangeClusterNetworkCompartmentRequest::builder).basePath("/20160918").appendPathParam("clusterNetworks").appendPathParam(request.getClusterNetworkId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeClusterNetworkCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeClusterNetworkCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeInstanceConfigurationCompartmentResponse> changeInstanceConfigurationCompartment(ChangeInstanceConfigurationCompartmentRequest request, AsyncHandler<ChangeInstanceConfigurationCompartmentRequest, ChangeInstanceConfigurationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getInstanceConfigurationId(), (String)"instanceConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeInstanceConfigurationCompartmentDetails(), "changeInstanceConfigurationCompartmentDetails is required");
        return this.clientCall(request, ChangeInstanceConfigurationCompartmentResponse::builder).logger(LOG, "changeInstanceConfigurationCompartment").serviceDetails("ComputeManagement", "ChangeInstanceConfigurationCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConfiguration/ChangeInstanceConfigurationCompartment").method(Method.POST).requestBuilder(ChangeInstanceConfigurationCompartmentRequest::builder).basePath("/20160918").appendPathParam("instanceConfigurations").appendPathParam(request.getInstanceConfigurationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeInstanceConfigurationCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeInstanceConfigurationCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeInstancePoolCompartmentResponse> changeInstancePoolCompartment(ChangeInstancePoolCompartmentRequest request, AsyncHandler<ChangeInstancePoolCompartmentRequest, ChangeInstancePoolCompartmentResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeInstancePoolCompartmentDetails(), "changeInstancePoolCompartmentDetails is required");
        return this.clientCall(request, ChangeInstancePoolCompartmentResponse::builder).logger(LOG, "changeInstancePoolCompartment").serviceDetails("ComputeManagement", "ChangeInstancePoolCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/ChangeInstancePoolCompartment").method(Method.POST).requestBuilder(ChangeInstancePoolCompartmentRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeInstancePoolCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeInstancePoolCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateClusterNetworkResponse> createClusterNetwork(CreateClusterNetworkRequest request, AsyncHandler<CreateClusterNetworkRequest, CreateClusterNetworkResponse> handler) {
        Objects.requireNonNull(request.getCreateClusterNetworkDetails(), "createClusterNetworkDetails is required");
        return this.clientCall(request, CreateClusterNetworkResponse::builder).logger(LOG, "createClusterNetwork").serviceDetails("ComputeManagement", "CreateClusterNetwork", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ClusterNetwork/CreateClusterNetwork").method(Method.POST).requestBuilder(CreateClusterNetworkRequest::builder).basePath("/20160918").appendPathParam("clusterNetworks").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ClusterNetwork.class, CreateClusterNetworkResponse.Builder::clusterNetwork).handleResponseHeaderString("etag", CreateClusterNetworkResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateClusterNetworkResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateClusterNetworkResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateInstanceConfigurationResponse> createInstanceConfiguration(CreateInstanceConfigurationRequest request, AsyncHandler<CreateInstanceConfigurationRequest, CreateInstanceConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCreateInstanceConfiguration(), "createInstanceConfiguration is required");
        return this.clientCall(request, CreateInstanceConfigurationResponse::builder).logger(LOG, "createInstanceConfiguration").serviceDetails("ComputeManagement", "CreateInstanceConfiguration", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConfiguration/CreateInstanceConfiguration").method(Method.POST).requestBuilder(CreateInstanceConfigurationRequest::builder).basePath("/20160918").appendPathParam("instanceConfigurations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InstanceConfiguration.class, CreateInstanceConfigurationResponse.Builder::instanceConfiguration).handleResponseHeaderString("etag", CreateInstanceConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateInstanceConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateInstancePoolResponse> createInstancePool(CreateInstancePoolRequest request, AsyncHandler<CreateInstancePoolRequest, CreateInstancePoolResponse> handler) {
        Objects.requireNonNull(request.getCreateInstancePoolDetails(), "createInstancePoolDetails is required");
        return this.clientCall(request, CreateInstancePoolResponse::builder).logger(LOG, "createInstancePool").serviceDetails("ComputeManagement", "CreateInstancePool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/CreateInstancePool").method(Method.POST).requestBuilder(CreateInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InstancePool.class, CreateInstancePoolResponse.Builder::instancePool).handleResponseHeaderString("etag", CreateInstancePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteInstanceConfigurationResponse> deleteInstanceConfiguration(DeleteInstanceConfigurationRequest request, AsyncHandler<DeleteInstanceConfigurationRequest, DeleteInstanceConfigurationResponse> handler) {
        Validate.notBlank((String)request.getInstanceConfigurationId(), (String)"instanceConfigurationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteInstanceConfigurationResponse::builder).logger(LOG, "deleteInstanceConfiguration").serviceDetails("ComputeManagement", "DeleteInstanceConfiguration", "").method(Method.DELETE).requestBuilder(DeleteInstanceConfigurationRequest::builder).basePath("/20160918").appendPathParam("instanceConfigurations").appendPathParam(request.getInstanceConfigurationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteInstanceConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachInstancePoolInstanceResponse> detachInstancePoolInstance(DetachInstancePoolInstanceRequest request, AsyncHandler<DetachInstancePoolInstanceRequest, DetachInstancePoolInstanceResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachInstancePoolInstanceDetails(), "detachInstancePoolInstanceDetails is required");
        return this.clientCall(request, DetachInstancePoolInstanceResponse::builder).logger(LOG, "detachInstancePoolInstance").serviceDetails("ComputeManagement", "DetachInstancePoolInstance", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePoolInstance/DetachInstancePoolInstance").method(Method.POST).requestBuilder(DetachInstancePoolInstanceRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("detachInstance").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", DetachInstancePoolInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DetachInstancePoolInstanceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachLoadBalancerResponse> detachLoadBalancer(DetachLoadBalancerRequest request, AsyncHandler<DetachLoadBalancerRequest, DetachLoadBalancerResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDetachLoadBalancerDetails(), "detachLoadBalancerDetails is required");
        return this.clientCall(request, DetachLoadBalancerResponse::builder).logger(LOG, "detachLoadBalancer").serviceDetails("ComputeManagement", "DetachLoadBalancer", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/DetachLoadBalancer").method(Method.POST).requestBuilder(DetachLoadBalancerRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("detachLoadBalancer").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(InstancePool.class, DetachLoadBalancerResponse.Builder::instancePool).handleResponseHeaderString("etag", DetachLoadBalancerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", DetachLoadBalancerResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetClusterNetworkResponse> getClusterNetwork(GetClusterNetworkRequest request, AsyncHandler<GetClusterNetworkRequest, GetClusterNetworkResponse> handler) {
        Validate.notBlank((String)request.getClusterNetworkId(), (String)"clusterNetworkId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetClusterNetworkResponse::builder).logger(LOG, "getClusterNetwork").serviceDetails("ComputeManagement", "GetClusterNetwork", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ClusterNetwork/GetClusterNetwork").method(Method.GET).requestBuilder(GetClusterNetworkRequest::builder).basePath("/20160918").appendPathParam("clusterNetworks").appendPathParam(request.getClusterNetworkId()).accept(new String[]{"application/json"}).handleBody(ClusterNetwork.class, GetClusterNetworkResponse.Builder::clusterNetwork).handleResponseHeaderString("etag", GetClusterNetworkResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetClusterNetworkResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstanceConfigurationResponse> getInstanceConfiguration(GetInstanceConfigurationRequest request, AsyncHandler<GetInstanceConfigurationRequest, GetInstanceConfigurationResponse> handler) {
        Validate.notBlank((String)request.getInstanceConfigurationId(), (String)"instanceConfigurationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstanceConfigurationResponse::builder).logger(LOG, "getInstanceConfiguration").serviceDetails("ComputeManagement", "GetInstanceConfiguration", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConfiguration/GetInstanceConfiguration").method(Method.GET).requestBuilder(GetInstanceConfigurationRequest::builder).basePath("/20160918").appendPathParam("instanceConfigurations").appendPathParam(request.getInstanceConfigurationId()).accept(new String[]{"application/json"}).handleBody(InstanceConfiguration.class, GetInstanceConfigurationResponse.Builder::instanceConfiguration).handleResponseHeaderString("etag", GetInstanceConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInstanceConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstancePoolResponse> getInstancePool(GetInstancePoolRequest request, AsyncHandler<GetInstancePoolRequest, GetInstancePoolResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstancePoolResponse::builder).logger(LOG, "getInstancePool").serviceDetails("ComputeManagement", "GetInstancePool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/GetInstancePool").method(Method.GET).requestBuilder(GetInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).accept(new String[]{"application/json"}).handleBody(InstancePool.class, GetInstancePoolResponse.Builder::instancePool).handleResponseHeaderString("etag", GetInstancePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstancePoolInstanceResponse> getInstancePoolInstance(GetInstancePoolInstanceRequest request, AsyncHandler<GetInstancePoolInstanceRequest, GetInstancePoolInstanceResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstancePoolInstanceResponse::builder).logger(LOG, "getInstancePoolInstance").serviceDetails("ComputeManagement", "GetInstancePoolInstance", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePoolInstance/GetInstancePoolInstance").method(Method.GET).requestBuilder(GetInstancePoolInstanceRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("instances").appendPathParam(request.getInstanceId()).accept(new String[]{"application/json"}).handleBody(InstancePoolInstance.class, GetInstancePoolInstanceResponse.Builder::instancePoolInstance).handleResponseHeaderString("etag", GetInstancePoolInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInstancePoolInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstancePoolLoadBalancerAttachmentResponse> getInstancePoolLoadBalancerAttachment(GetInstancePoolLoadBalancerAttachmentRequest request, AsyncHandler<GetInstancePoolLoadBalancerAttachmentRequest, GetInstancePoolLoadBalancerAttachmentResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getInstancePoolLoadBalancerAttachmentId(), (String)"instancePoolLoadBalancerAttachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstancePoolLoadBalancerAttachmentResponse::builder).logger(LOG, "getInstancePoolLoadBalancerAttachment").serviceDetails("ComputeManagement", "GetInstancePoolLoadBalancerAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePoolLoadBalancerAttachment/GetInstancePoolLoadBalancerAttachment").method(Method.GET).requestBuilder(GetInstancePoolLoadBalancerAttachmentRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("loadBalancerAttachments").appendPathParam(request.getInstancePoolLoadBalancerAttachmentId()).accept(new String[]{"application/json"}).handleBody(InstancePoolLoadBalancerAttachment.class, GetInstancePoolLoadBalancerAttachmentResponse.Builder::instancePoolLoadBalancerAttachment).handleResponseHeaderString("opc-request-id", GetInstancePoolLoadBalancerAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<LaunchInstanceConfigurationResponse> launchInstanceConfiguration(LaunchInstanceConfigurationRequest request, AsyncHandler<LaunchInstanceConfigurationRequest, LaunchInstanceConfigurationResponse> handler) {
        Validate.notBlank((String)request.getInstanceConfigurationId(), (String)"instanceConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getInstanceConfiguration(), "instanceConfiguration is required");
        return this.clientCall(request, LaunchInstanceConfigurationResponse::builder).logger(LOG, "launchInstanceConfiguration").serviceDetails("ComputeManagement", "LaunchInstanceConfiguration", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/LaunchInstanceConfiguration").method(Method.POST).requestBuilder(LaunchInstanceConfigurationRequest::builder).basePath("/20160918").appendPathParam("instanceConfigurations").appendPathParam(request.getInstanceConfigurationId()).appendPathParam("actions").appendPathParam("launch").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Instance.class, LaunchInstanceConfigurationResponse.Builder::instance).handleResponseHeaderString("etag", LaunchInstanceConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", LaunchInstanceConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", LaunchInstanceConfigurationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ListClusterNetworkInstancesResponse> listClusterNetworkInstances(ListClusterNetworkInstancesRequest request, AsyncHandler<ListClusterNetworkInstancesRequest, ListClusterNetworkInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getClusterNetworkId(), (String)"clusterNetworkId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListClusterNetworkInstancesResponse::builder).logger(LOG, "listClusterNetworkInstances").serviceDetails("ComputeManagement", "ListClusterNetworkInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ClusterNetwork/ListClusterNetworkInstances").method(Method.GET).requestBuilder(ListClusterNetworkInstancesRequest::builder).basePath("/20160918").appendPathParam("clusterNetworks").appendPathParam(request.getClusterNetworkId()).appendPathParam("instances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(InstanceSummary.class, ListClusterNetworkInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListClusterNetworkInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListClusterNetworkInstancesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListClusterNetworksResponse> listClusterNetworks(ListClusterNetworksRequest request, AsyncHandler<ListClusterNetworksRequest, ListClusterNetworksResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListClusterNetworksResponse::builder).logger(LOG, "listClusterNetworks").serviceDetails("ComputeManagement", "ListClusterNetworks", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ClusterNetwork/ListClusterNetworks").method(Method.GET).requestBuilder(ListClusterNetworksRequest::builder).basePath("/20160918").appendPathParam("clusterNetworks").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(ClusterNetworkSummary.class, ListClusterNetworksResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListClusterNetworksResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListClusterNetworksResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstanceConfigurationsResponse> listInstanceConfigurations(ListInstanceConfigurationsRequest request, AsyncHandler<ListInstanceConfigurationsRequest, ListInstanceConfigurationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListInstanceConfigurationsResponse::builder).logger(LOG, "listInstanceConfigurations").serviceDetails("ComputeManagement", "ListInstanceConfigurations", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConfigurationSummary/ListInstanceConfigurations").method(Method.GET).requestBuilder(ListInstanceConfigurationsRequest::builder).basePath("/20160918").appendPathParam("instanceConfigurations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(InstanceConfigurationSummary.class, ListInstanceConfigurationsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstanceConfigurationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstanceConfigurationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstancePoolInstancesResponse> listInstancePoolInstances(ListInstancePoolInstancesRequest request, AsyncHandler<ListInstancePoolInstancesRequest, ListInstancePoolInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListInstancePoolInstancesResponse::builder).logger(LOG, "listInstancePoolInstances").serviceDetails("ComputeManagement", "ListInstancePoolInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceSummary/ListInstancePoolInstances").method(Method.GET).requestBuilder(ListInstancePoolInstancesRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("instances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(InstanceSummary.class, ListInstancePoolInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstancePoolInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstancePoolInstancesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstancePoolsResponse> listInstancePools(ListInstancePoolsRequest request, AsyncHandler<ListInstancePoolsRequest, ListInstancePoolsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListInstancePoolsResponse::builder).logger(LOG, "listInstancePools").serviceDetails("ComputeManagement", "ListInstancePools", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePoolSummary/ListInstancePools").method(Method.GET).requestBuilder(ListInstancePoolsRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(InstancePoolSummary.class, ListInstancePoolsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstancePoolsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstancePoolsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ResetInstancePoolResponse> resetInstancePool(ResetInstancePoolRequest request, AsyncHandler<ResetInstancePoolRequest, ResetInstancePoolResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ResetInstancePoolResponse::builder).logger(LOG, "resetInstancePool").serviceDetails("ComputeManagement", "ResetInstancePool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/ResetInstancePool").method(Method.POST).requestBuilder(ResetInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("reset").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleBody(InstancePool.class, ResetInstancePoolResponse.Builder::instancePool).handleResponseHeaderString("etag", ResetInstancePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ResetInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SoftresetInstancePoolResponse> softresetInstancePool(SoftresetInstancePoolRequest request, AsyncHandler<SoftresetInstancePoolRequest, SoftresetInstancePoolResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SoftresetInstancePoolResponse::builder).logger(LOG, "softresetInstancePool").serviceDetails("ComputeManagement", "SoftresetInstancePool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/SoftresetInstancePool").method(Method.POST).requestBuilder(SoftresetInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("softreset").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleBody(InstancePool.class, SoftresetInstancePoolResponse.Builder::instancePool).handleResponseHeaderString("etag", SoftresetInstancePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", SoftresetInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SoftstopInstancePoolResponse> softstopInstancePool(SoftstopInstancePoolRequest request, AsyncHandler<SoftstopInstancePoolRequest, SoftstopInstancePoolResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, SoftstopInstancePoolResponse::builder).logger(LOG, "softstopInstancePool").serviceDetails("ComputeManagement", "SoftstopInstancePool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/SoftstopInstancePool").method(Method.POST).requestBuilder(SoftstopInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("softstop").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleBody(InstancePool.class, SoftstopInstancePoolResponse.Builder::instancePool).handleResponseHeaderString("etag", SoftstopInstancePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", SoftstopInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StartInstancePoolResponse> startInstancePool(StartInstancePoolRequest request, AsyncHandler<StartInstancePoolRequest, StartInstancePoolResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartInstancePoolResponse::builder).logger(LOG, "startInstancePool").serviceDetails("ComputeManagement", "StartInstancePool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/StartInstancePool").method(Method.POST).requestBuilder(StartInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleBody(InstancePool.class, StartInstancePoolResponse.Builder::instancePool).handleResponseHeaderString("etag", StartInstancePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", StartInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopInstancePoolResponse> stopInstancePool(StopInstancePoolRequest request, AsyncHandler<StopInstancePoolRequest, StopInstancePoolResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopInstancePoolResponse::builder).logger(LOG, "stopInstancePool").serviceDetails("ComputeManagement", "StopInstancePool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/StopInstancePool").method(Method.POST).requestBuilder(StopInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleBody(InstancePool.class, StopInstancePoolResponse.Builder::instancePool).handleResponseHeaderString("etag", StopInstancePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", StopInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<TerminateClusterNetworkResponse> terminateClusterNetwork(TerminateClusterNetworkRequest request, AsyncHandler<TerminateClusterNetworkRequest, TerminateClusterNetworkResponse> handler) {
        Validate.notBlank((String)request.getClusterNetworkId(), (String)"clusterNetworkId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, TerminateClusterNetworkResponse::builder).logger(LOG, "terminateClusterNetwork").serviceDetails("ComputeManagement", "TerminateClusterNetwork", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ClusterNetwork/TerminateClusterNetwork").method(Method.DELETE).requestBuilder(TerminateClusterNetworkRequest::builder).basePath("/20160918").appendPathParam("clusterNetworks").appendPathParam(request.getClusterNetworkId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", TerminateClusterNetworkResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", TerminateClusterNetworkResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<TerminateInstancePoolResponse> terminateInstancePool(TerminateInstancePoolRequest request, AsyncHandler<TerminateInstancePoolRequest, TerminateInstancePoolResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, TerminateInstancePoolResponse::builder).logger(LOG, "terminateInstancePool").serviceDetails("ComputeManagement", "TerminateInstancePool", "").method(Method.DELETE).requestBuilder(TerminateInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", TerminateInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateClusterNetworkResponse> updateClusterNetwork(UpdateClusterNetworkRequest request, AsyncHandler<UpdateClusterNetworkRequest, UpdateClusterNetworkResponse> handler) {
        Validate.notBlank((String)request.getClusterNetworkId(), (String)"clusterNetworkId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateClusterNetworkDetails(), "updateClusterNetworkDetails is required");
        return this.clientCall(request, UpdateClusterNetworkResponse::builder).logger(LOG, "updateClusterNetwork").serviceDetails("ComputeManagement", "UpdateClusterNetwork", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ClusterNetwork/UpdateClusterNetwork").method(Method.PUT).requestBuilder(UpdateClusterNetworkRequest::builder).basePath("/20160918").appendPathParam("clusterNetworks").appendPathParam(request.getClusterNetworkId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ClusterNetwork.class, UpdateClusterNetworkResponse.Builder::clusterNetwork).handleResponseHeaderString("etag", UpdateClusterNetworkResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateClusterNetworkResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateInstanceConfigurationResponse> updateInstanceConfiguration(UpdateInstanceConfigurationRequest request, AsyncHandler<UpdateInstanceConfigurationRequest, UpdateInstanceConfigurationResponse> handler) {
        Validate.notBlank((String)request.getInstanceConfigurationId(), (String)"instanceConfigurationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInstanceConfigurationDetails(), "updateInstanceConfigurationDetails is required");
        return this.clientCall(request, UpdateInstanceConfigurationResponse::builder).logger(LOG, "updateInstanceConfiguration").serviceDetails("ComputeManagement", "UpdateInstanceConfiguration", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConfiguration/UpdateInstanceConfiguration").method(Method.PUT).requestBuilder(UpdateInstanceConfigurationRequest::builder).basePath("/20160918").appendPathParam("instanceConfigurations").appendPathParam(request.getInstanceConfigurationId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(InstanceConfiguration.class, UpdateInstanceConfigurationResponse.Builder::instanceConfiguration).handleResponseHeaderString("etag", UpdateInstanceConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInstanceConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateInstancePoolResponse> updateInstancePool(UpdateInstancePoolRequest request, AsyncHandler<UpdateInstancePoolRequest, UpdateInstancePoolResponse> handler) {
        Validate.notBlank((String)request.getInstancePoolId(), (String)"instancePoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInstancePoolDetails(), "updateInstancePoolDetails is required");
        return this.clientCall(request, UpdateInstancePoolResponse::builder).logger(LOG, "updateInstancePool").serviceDetails("ComputeManagement", "UpdateInstancePool", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstancePool/UpdateInstancePool").method(Method.PUT).requestBuilder(UpdateInstancePoolRequest::builder).basePath("/20160918").appendPathParam("instancePools").appendPathParam(request.getInstancePoolId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(InstancePool.class, UpdateInstancePoolResponse.Builder::instancePool).handleResponseHeaderString("etag", UpdateInstancePoolResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInstancePoolResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ComputeManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ComputeManagementAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ComputeManagementAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ComputeManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ComputeManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ComputeManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ComputeManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ComputeManagementAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "core";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"core");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ComputeManagementAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ComputeManagementAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

