/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.glassfish.javaee.Hk2LibraryProvider;
import org.netbeans.modules.glassfish.javaee.JavaEEServerModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModuleFactory;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class JavaEEServerModuleFactory
implements GlassfishModuleFactory {
    private static final JavaEEServerModuleFactory singleton = new JavaEEServerModuleFactory();
    private static final Logger LOG = Logger.getLogger(JavaEEServerModuleFactory.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("JavaEEServerModuleFactory");
    private static final String CLASS_LIBRARY_TYPE = "j2se";
    private static final String CLASSPATH_VOLUME = "classpath";
    private static final String SOURCE_VOLUME = "src";
    private static final String JAVADOC_VOLUME = "javadoc";
    private static final String ECLIPSE_LINK_LIB = "EclipseLink-GlassFish-v3-Prelude";
    private static final String ECLIPSE_LINK_LIB_2 = "EclipseLink-GlassFish-v3";
    private static final String EL_CORE_JAR_MATCHER = "eclipselink-wrapper(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_API_JAR_MATCHER_1 = "javax.javaee(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_API_JAR_MATCHER_2 = "javax.persistence(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String PERSISTENCE_JAVADOC = "javaee-doc-api.jar";
    private static final String COMET_LIB = "Comet-GlassFish-v3-Prelude";
    private static final String COMET_LIB_2 = "Comet-GlassFish-v3";
    private static final String COMET_JAR_MATCHER = "grizzly-module(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String COMET_JAR_2_MATCHER = "grizzly-comet(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String GRIZZLY_OPTIONAL_JAR_MATCHER = "grizzly-optional(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar";
    private static final String JERSEY_GF_SERVER = "jersey-gf-server";
    private static final String[] JAXRS_LIBRARIES = new String[]{"jackson-asl", "jackson-core-asl", "jersey-bundle", "jersey-gf-bundle", "jersey-multipart", "jettison", "mimepull", "jsr311-api"};
    private static final String[] JAXRS_LIBRARIES_31 = new String[]{"jackson-core-asl", "jackson-jaxrs", "jackson-mapper-asl", "jersey-client", "jersey-core", "jersey-gf-server", "jersey-json", "jersey-multipart", "jettison", "mimepull"};
    private static final String JAVA_EE_6_LIB = "Java-EE-GlassFish-v3";
    private static final String JAVA_EE_5_LIB = "Java-EE-GlassFish-v3-Prelude";
    private static final String JAVA_EE_JAVADOC = "javaee-doc-api.jar";
    private static final String JAKARTA_EE_8_JAVADOC = "jakartaee8-doc-api.jar";
    private static final String JAKARTA_EE_9_JAVADOC = "jakartaee9-doc-api.jar";
    private static final String JAKARTA_EE_10_JAVADOC = "jakartaee10-doc-api.jar";
    private static final String JAKARTA_EE_11_JAVADOC = "jakartaee11-doc-api.jar";

    private JavaEEServerModuleFactory() {
    }

    public static GlassfishModuleFactory getDefault() {
        return singleton;
    }

    public boolean isModuleSupported(String glassfishHome, Properties asenvProps) {
        File jar = ServerUtilities.getJarName((String)glassfishHome, (String)"glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (jar == null) {
            return false;
        }
        return jar.exists();
    }

    public Object createModule(Lookup instanceLookup) {
        InstanceProperties ip = null;
        final GlassfishModule commonModule = (GlassfishModule)instanceLookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            Map props = commonModule.getInstanceProperties();
            String url = (String)props.get("url");
            ip = InstanceProperties.getInstanceProperties((String)url);
            if (ip == null) {
                block6: {
                    String username = (String)props.get("username");
                    String password = null;
                    String displayName = (String)props.get("displayName");
                    try {
                        ip = InstanceProperties.createInstancePropertiesNonPersistent((String)url, (String)username, password, (String)displayName, (Map)props);
                    }
                    catch (InstanceCreationException ex) {
                        ip = InstanceProperties.getInstanceProperties((String)url);
                        if (null != ip) break block6;
                        LOG.log(Level.WARNING, null, ex);
                    }
                }
                if (ip == null) {
                    LOG.log(Level.INFO, "Unable to create/locate J2EE InstanceProperties for {0}", url);
                }
            }
            final String glassfishRoot = (String)commonModule.getInstanceProperties().get("homefolder");
            final String installRoot = (String)commonModule.getInstanceProperties().get("installfolder");
            RP.post(new Runnable(){
                final /* synthetic */ JavaEEServerModuleFactory this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    File ir;
                    File f;
                    JavaEEServerModuleFactory.ensureEclipseLinkSupport(glassfishRoot);
                    JavaEEServerModuleFactory.ensureCometSupport(glassfishRoot);
                    JavaEEServerModuleFactory.ensureGlassFishApiSupport(commonModule.getInstance());
                    RegisteredDerbyServer db = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
                    if (null != db && null != installRoot && (f = new File(ir = new File(installRoot), "javadb")).exists() && f.isDirectory() && f.canRead()) {
                        db.initialize(f.getAbsolutePath());
                    }
                }
            });
        } else {
            LOG.log(Level.WARNING, "commonModule is NULL");
        }
        return ip != null ? new JavaEEServerModule(instanceLookup, ip) : null;
    }

    private static boolean ensureEclipseLinkSupport(String installRoot) {
        ArrayList<URL> libraryList = new ArrayList<URL>();
        ArrayList<URL> docList = new ArrayList<URL>();
        try {
            File f = ServerUtilities.getJarName((String)installRoot, (String)EL_CORE_JAR_MATCHER);
            if (f != null && f.exists()) {
                libraryList.add(ServerUtilities.fileToUrl((File)f));
            } else {
                for (File candidate : new File(installRoot, "modules").listFiles()) {
                    if (candidate.getName().indexOf("org.eclipse.persistence") == -1) continue;
                    libraryList.add(ServerUtilities.fileToUrl((File)candidate));
                }
            }
            f = ServerUtilities.getJarName((String)installRoot, (String)PERSISTENCE_API_JAR_MATCHER_1);
            if (f != null && f.exists()) {
                libraryList.add(ServerUtilities.fileToUrl((File)f));
            } else {
                f = ServerUtilities.getJarName((String)installRoot, (String)PERSISTENCE_API_JAR_MATCHER_2);
                if (f != null && f.exists()) {
                    libraryList.add(ServerUtilities.fileToUrl((File)f));
                }
            }
            File j2eeDoc = InstalledFileLocator.getDefault().locate("docs/javaee-doc-api.jar", "org.netbeans.modules.j2ee.platform", false);
            if (j2eeDoc != null) {
                docList.add(ServerUtilities.fileToUrl((File)j2eeDoc));
            } else {
                LOG.log(Level.WARNING, "Warning: Java EE documentation not found when registering EclipseLink library.");
            }
        }
        catch (MalformedURLException ex) {
            LOG.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            return false;
        }
        String name = ECLIPSE_LINK_LIB;
        File f = ServerUtilities.getJarName((String)installRoot, (String)"gmbal(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (f != null && f.exists()) {
            name = ECLIPSE_LINK_LIB_2;
        }
        return JavaEEServerModuleFactory.addLibrary(name, libraryList, docList, NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DNAME_GF_ECLIPSELINK"), NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DESC_GF_ECLIPSELINK"));
    }

    private static boolean ensureCometSupport(String installRoot) {
        ArrayList<URL> libraryList = new ArrayList<URL>();
        String name = COMET_LIB;
        File f = ServerUtilities.getJarName((String)installRoot, (String)GRIZZLY_OPTIONAL_JAR_MATCHER);
        if (f == null || !f.exists()) {
            f = ServerUtilities.getJarName((String)installRoot, (String)COMET_JAR_MATCHER);
        }
        if (f == null || !f.exists()) {
            name = COMET_LIB_2;
            f = ServerUtilities.getJarName((String)installRoot, (String)COMET_JAR_2_MATCHER);
        }
        if (f != null && f.exists()) {
            try {
                libraryList.add(ServerUtilities.fileToUrl((File)f));
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.WARNING, ex.getLocalizedMessage(), ex);
                return false;
            }
        }
        return JavaEEServerModuleFactory.addLibrary(name, libraryList, null, NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DNAME_GF_COMET"), NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DESC_GF_COMET"));
    }

    private static boolean ensureGlassFishApiSupport(GlassFishServer server) {
        String[] JERSEY_LIBS;
        File jerseyGFServer;
        File j2eeDoc;
        String installRoot = server.getServerRoot();
        List<URL> libraryList = Hk2LibraryProvider.getProvider(server).getJavaEEClassPathURLs();
        ArrayList<URL> docList = new ArrayList<URL>();
        String name = JAVA_EE_5_LIB;
        File f = ServerUtilities.getJarName((String)installRoot, (String)"gmbal(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (f != null && f.exists()) {
            name = JAVA_EE_6_LIB;
        }
        if ((j2eeDoc = GlassFishVersion.ge((Enum)server.getVersion(), (Enum)GlassFishVersion.GF_8_0_0) ? InstalledFileLocator.getDefault().locate("docs/jakartaee11-doc-api.jar", "org.netbeans.modules.j2ee.platform", false) : (GlassFishVersion.ge((Enum)server.getVersion(), (Enum)GlassFishVersion.GF_7_0_0) ? InstalledFileLocator.getDefault().locate("docs/jakartaee10-doc-api.jar", "org.netbeans.modules.j2ee.platform", false) : (GlassFishVersion.ge((Enum)server.getVersion(), (Enum)GlassFishVersion.GF_6) ? InstalledFileLocator.getDefault().locate("docs/jakartaee9-doc-api.jar", "org.netbeans.modules.j2ee.platform", false) : (GlassFishVersion.ge((Enum)server.getVersion(), (Enum)GlassFishVersion.GF_5_1_0) ? InstalledFileLocator.getDefault().locate("docs/jakartaee8-doc-api.jar", "org.netbeans.modules.j2ee.platform", false) : InstalledFileLocator.getDefault().locate("docs/javaee-doc-api.jar", "org.netbeans.modules.j2ee.platform", false))))) != null) {
            try {
                docList.add(ServerUtilities.fileToUrl((File)j2eeDoc));
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.INFO, "Problem while registering Java EE API library JavaDoc.");
            }
        } else {
            LOG.log(Level.INFO, "Java EE documentation not found when registering Java EE API library.");
        }
        f = ServerUtilities.getJarName((String)installRoot, (String)"web-core(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (f != null && f.exists()) {
            try {
                libraryList.add(ServerUtilities.fileToUrl((File)f));
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.INFO, "Problem while registering web-core into GlassFish API library.");
            }
        }
        boolean isGFV31 = (jerseyGFServer = ServerUtilities.getJarName((String)installRoot, (String)"jersey-gf-server(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar")) != null;
        for (String entry : JERSEY_LIBS = isGFV31 ? JAXRS_LIBRARIES_31 : JAXRS_LIBRARIES) {
            f = ServerUtilities.getJarName((String)installRoot, (String)(entry + "(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar"));
            if (f == null || !f.exists()) continue;
            try {
                libraryList.add(FileUtil.getArchiveRoot((URL)Utilities.toURI((File)f).toURL()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return JavaEEServerModuleFactory.addLibrary(name, libraryList, docList, NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DNAME_GF_JAVA_EE_IMPL"), NbBundle.getMessage(JavaEEServerModuleFactory.class, (String)"DESC_GF_JAVA_EE_IMPL"));
    }

    private static boolean addLibrary(String name, List<URL> libraryList, List<URL> docList, String displayName, String description) {
        return JavaEEServerModuleFactory.addLibrary(name, CLASS_LIBRARY_TYPE, libraryList, docList, displayName, description);
    }

    private static synchronized boolean addLibrary(String name, String libType, List<URL> libraryList, List<URL> docList, String displayName, String description) {
        Library lib;
        block29: {
            String libPath;
            List libList;
            LibraryManager lmgr = LibraryManager.getDefault();
            int size = 0;
            lib = lmgr.getLibrary(name);
            if (lib != null) {
                libList = lib.getContent(CLASSPATH_VOLUME);
                size = libList.size();
                for (URL libUrl : libList) {
                    libPath = libUrl.getFile();
                    if (libPath.length() > 5) {
                        libPath = libPath.substring(5);
                    }
                    if (new File(libPath.replace("!/", "")).exists()) continue;
                    LOG.log(Level.FINE, "libPath does not exist.  Updating {0}", name);
                    try {
                        lmgr.removeLibrary(lib);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                    lib = null;
                    size = 0;
                    break;
                }
            }
            if (lib != null && size < libraryList.size()) {
                try {
                    lmgr.removeLibrary(lib);
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
                lib = null;
            }
            if (lib != null) {
                libList = lib.getContent(JAVADOC_VOLUME);
                size = libList.size();
                for (URL libUrl : libList) {
                    libPath = libUrl.getFile();
                    if (libPath.length() > 5) {
                        libPath = libPath.substring(5);
                    }
                    if (new File(libPath.replace("!/", "")).exists()) continue;
                    LOG.log(Level.FINE, "libPath does not exist.  Updating {0}", name);
                    try {
                        lmgr.removeLibrary(lib);
                    }
                    catch (IOException ex) {
                        LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    lib = null;
                    size = 0;
                    break;
                }
            }
            if (lib != null && null != docList && size < docList.size()) {
                try {
                    lmgr.removeLibrary(lib);
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
                lib = null;
            }
            if (lib == null) {
                try {
                    LibraryTypeProvider ltp;
                    HashMap<String, List<URL>> contents = new HashMap<String, List<URL>>();
                    if (null != libraryList) {
                        contents.put(CLASSPATH_VOLUME, libraryList);
                    }
                    if (null != docList) {
                        contents.put(JAVADOC_VOLUME, docList);
                    }
                    if (null != (ltp = LibrariesSupport.getLibraryTypeProvider((String)libType))) {
                        lib = lmgr.createLibrary(libType, name, displayName, description, contents);
                        LOG.log(Level.FINE, "Created library {0}", name);
                    } else {
                        lmgr.addPropertyChangeListener((PropertyChangeListener)new InitializeLibrary(lmgr, libType, name, contents, displayName, description));
                        LOG.log(Level.FINE, "schedule to create library {0}", name);
                    }
                }
                catch (IOException ex) {
                    lib = lmgr.getLibrary(name);
                    if (lib == null) {
                        LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                }
                catch (IllegalArgumentException ex) {
                    lib = lmgr.getLibrary(name);
                    if (lib != null) break block29;
                    LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        }
        return lib != null;
    }

    static class InitializeLibrary
    implements PropertyChangeListener {
        private final LibraryManager lmgr;
        private String name;
        private Map<String, List<URL>> content;
        private final String libType;
        private final String displayName;
        private final String description;

        InitializeLibrary(LibraryManager lmgr, String libType, String name, Map<String, List<URL>> content, String displayName, String description) {
            this.lmgr = lmgr;
            this.name = name;
            this.content = content;
            this.libType = libType;
            this.displayName = displayName;
            this.description = description;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JavaEEServerModuleFactory javaEEServerModuleFactory = singleton;
            synchronized (javaEEServerModuleFactory) {
                if (null != this.name) {
                    Library l = this.lmgr.getLibrary(this.name);
                    InitializeLibrary pcl = this;
                    if (null == l) {
                        try {
                            LibraryTypeProvider ltp = LibrariesSupport.getLibraryTypeProvider((String)this.libType);
                            if (null != ltp) {
                                this.lmgr.createLibrary(this.libType, this.name, this.displayName, this.description, this.content);
                                LOG.log(Level.FINE, "Created library {0}", this.name);
                                this.removeFromListenerList(pcl);
                            }
                        }
                        catch (IOException ex) {
                            LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
                        }
                        catch (IllegalArgumentException iae) {
                            LOG.log(Level.INFO, iae.getLocalizedMessage(), iae);
                        }
                    } else {
                        this.removeFromListenerList(pcl);
                    }
                }
            }
        }

        private void removeFromListenerList(final PropertyChangeListener pcl) {
            RP.post(new Runnable(){
                final /* synthetic */ InitializeLibrary this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JavaEEServerModuleFactory javaEEServerModuleFactory = singleton;
                    synchronized (javaEEServerModuleFactory) {
                        if (null != this.this$0.lmgr) {
                            this.this$0.lmgr.removePropertyChangeListener(pcl);
                            this.this$0.content = null;
                            this.this$0.name = null;
                        }
                    }
                }
            });
        }
    }
}

