/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdtdebug.ui.models;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.List;
import javax.swing.Action;
import org.netbeans.lib.chrome_devtools_protocol.debugger.CallFrame;
import org.netbeans.modules.javascript.cdtdebug.CDTDebugger;
import org.netbeans.modules.javascript.cdtdebug.ui.EditorUtils;
import org.netbeans.modules.javascript.cdtdebug.ui.models.Bundle;
import org.netbeans.modules.javascript.cdtdebug.ui.models.DebuggingModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Lookup;

public class DebuggingActionsModel
implements NodeActionsProvider {
    private final CDTDebugger dbg;
    private Action GO_TO_SOURCE;
    private Action MAKE_CURRENT_ACTION = Models.createAction((String)Bundle.CTL_DebuggingActionsModel_MakeCurrent_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return node != DebuggingActionsModel.this.dbg.getCurrentFrame();
        }

        public void perform(Object[] nodes) {
            DebuggingActionsModel.this.dbg.setCurrentFrame((CallFrame)nodes[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final Action COPY_TO_CLBD_ACTION = Models.createAction((String)Bundle.CTL_DebuggingActionsModel_Copy2CLBD_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return DebuggingActionsModel.this.dbg.isSuspended();
        }

        public void perform(Object[] nodes) {
            DebuggingActionsModel.this.stackToCLBD();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public DebuggingActionsModel(ContextProvider contextProvider) {
        this.dbg = (CDTDebugger)contextProvider.lookupFirst(null, CDTDebugger.class);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            CallFrame frame = (CallFrame)node;
            if (frame != this.dbg.getCurrentFrame()) {
                this.dbg.setCurrentFrame(frame);
            } else {
                EditorUtils.showFrameLine(this.dbg, frame, true);
            }
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof CallFrame) {
            return new Action[]{this.MAKE_CURRENT_ACTION, this.GO_TO_SOURCE, this.COPY_TO_CLBD_ACTION};
        }
        return new Action[]{this.COPY_TO_CLBD_ACTION};
    }

    private void stackToCLBD() {
        if (!this.dbg.isSuspended()) {
            return;
        }
        StringBuilder frameStr = new StringBuilder(500);
        List stack = this.dbg.getCurrentCallStack();
        if (stack != null) {
            for (CallFrame frame : stack) {
                String thisName = frame.getThisObject().getClassName();
                if ("Object".equals(thisName) || "global".equals(thisName)) {
                    thisName = null;
                }
                if (thisName != null && !thisName.isEmpty()) {
                    frameStr.append(thisName);
                    frameStr.append('.');
                }
                String functionName = frame.getFunctionName();
                frameStr.append(functionName);
                String scriptName = DebuggingModel.getScriptName(this.dbg.getScriptsHandler(), frame);
                if (scriptName == null) {
                    scriptName = "?";
                }
                frameStr.append(" (");
                frameStr.append(scriptName);
                long line = frame.getLocation().getLineNumber() + 1;
                long column = frame.getLocation().getColumnNumber() != null ? (long)(frame.getLocation().getColumnNumber() + 1) : 0L;
                frameStr.append(":");
                frameStr.append(line + 1L);
                frameStr.append(":");
                frameStr.append(column + 1L);
                frameStr.append(")\n");
            }
        }
        Clipboard systemClipboard = DebuggingActionsModel.getClipboard();
        StringSelection transferableText = new StringSelection(frameStr.toString());
        systemClipboard.setContents(transferableText, null);
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }
}

