/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.timer;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.messages.TimerEvent;
import mediathek.tool.MessageBus;
import mediathek.tool.timer.TimerPoolThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lmediathek/tool/timer/TimerPool;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "repeatingTimerFuture", "Ljava/util/concurrent/ScheduledFuture;", "getRepeatingTimerFuture$annotations", "getRepeatingTimerFuture", "()Ljava/util/concurrent/ScheduledFuture;", "setRepeatingTimerFuture", "(Ljava/util/concurrent/ScheduledFuture;)V", "timerPool", "Ljava/util/concurrent/ScheduledExecutorService;", "getTimerPool$annotations", "getTimerPool", "()Ljava/util/concurrent/ScheduledExecutorService;", "MediathekView"})
public final class TimerPool {
    @NotNull
    public static final TimerPool INSTANCE = new TimerPool();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static ScheduledFuture<?> repeatingTimerFuture;
    @NotNull
    private static final ScheduledExecutorService timerPool;

    private TimerPool() {
    }

    @NotNull
    public static final ScheduledFuture<?> getRepeatingTimerFuture() {
        return repeatingTimerFuture;
    }

    public static final void setRepeatingTimerFuture(@NotNull ScheduledFuture<?> scheduledFuture) {
        Intrinsics.checkNotNullParameter(scheduledFuture, (String)"<set-?>");
        repeatingTimerFuture = scheduledFuture;
    }

    @JvmStatic
    public static /* synthetic */ void getRepeatingTimerFuture$annotations() {
    }

    @NotNull
    public static final ScheduledExecutorService getTimerPool() {
        return timerPool;
    }

    @JvmStatic
    public static /* synthetic */ void getTimerPool$annotations() {
    }

    private static final void _init_$lambda$0() {
        MessageBus.getMessageBus().publishAsync((Object)new TimerEvent());
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        TimerPool.logger = logger;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(0, new TimerPoolThreadFactory());
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        timerPool = scheduledExecutorService;
        TimerPool.logger.trace("Initializing timer pool...");
        ScheduledFuture<?> scheduledFuture = timerPool.scheduleWithFixedDelay(TimerPool::_init_$lambda$0, 4L, 1L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        repeatingTimerFuture = scheduledFuture;
    }
}

