---
stage: Create
group: Import
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Slack slash commands (deprecated)
description: "Configure Slack slash commands for GitLab Self-Managed instances."
---

<!--- start_remove The following content will be removed on remove_date: '2026-08-15' -->

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< alert type="warning" >}}

This feature was [deprecated](https://gitlab.com/gitlab-org/gitlab/-/issues/569345) in GitLab 18.7
and is planned for removal in 19.0. Use [GitLab for Slack app](gitlab_slack_application.md) instead.

This change is a breaking change.

{{< /alert >}}

You can use [slash commands](gitlab_slack_application.md#slash-commands) to run common GitLab operations,
like creating an issue, from a [Slack](https://slack.com/) chat environment.
To run slash commands in Slack, you must configure both Slack and GitLab.

{{< alert type="note" >}}

This feature is only configurable on GitLab Self-Managed.
For GitLab.com, use the [GitLab for Slack app](gitlab_slack_application.md) instead.

{{< /alert >}}

GitLab can also send events (such as `issue created`) to Slack as part of
[Slack notifications](gitlab_slack_application.md#slack-notifications).

For a list of available slash commands, see [Slash commands](gitlab_slack_application.md#slash-commands).

## Configure the integration

Slack slash commands are scoped to a project. To configure Slack slash commands:

1. On the top bar, select **Search or go to** and find your project.
1. Select **Settings** > **Integrations**.
1. Select **Slack slash commands** and leave this browser tab open.
1. In a new browser tab, sign in to Slack and [add a new slash command](https://my.slack.com/services/new/slash-commands).
1. Enter a trigger name for the slash command. You could use the project name.
1. Select **Add Slash Command Integration**.
1. In the Slack browser tab:
   1. Complete the fields with information from the GitLab browser tab.
   1. Select **Save Integration** and copy the **Token** value.
1. In the GitLab browser tab:
   1. Paste the token and ensure the **Active** checkbox is selected.
   1. Select **Save changes**.

You can now run slash commands in Slack.

<!--- end_remove -->
