---
stage: Package
group: Package Registry
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 仮想レジストリ
description: GitLab仮想レジストリを使用して、複数のアップストリームレジストリからパッケージをプロキシ、キャッシュ、および配布します。
---

{{< details >}}

- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated
- ステータス: ベータ

{{< /details >}}

{{< history >}}

- GitLab 18.0で`virtual_registry_maven`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/groups/gitlab-org/-/epics/14137)されました。デフォルトでは無効になっています。
- 機能フラグはGitLab 18.1で`maven_virtual_registry`に[名前が変更されました](https://gitlab.com/gitlab-org/gitlab/-/issues/540276)。
- GitLab 18.1で、実験からベータに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/540276)されました。
- GitLab 18.2で、[GitLab.com、GitLab Self-Managed、およびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197432)になりました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

{{< alert type="note" >}}

GitLab仮想レジストリは、GitLabの[ベータ](../../../policy/development_stages_support.md#beta)プログラムの一部として利用できます。現在、PremiumおよびUltimateプランで利用できますが、最終的な可用性と価格は、仮想レジストリが一般的に利用可能になったときに発表されます。 

{{< /alert >}} GitLab仮想レジストリを使用して、単一の既知のURLの背後にある複数のアップストリームレジストリからパッケージをプロキシ処理し、キャッシュし、配布します。

このアプローチを使用すると、複数のアップストリームレジストリの代わりに、1つの仮想レジストリを使用するようにアプリケーションを設定できます。

## 前提要件 {#prerequisites}

仮想レジストリを設定するには、以下が必要です:

- 少なくともメンテナーロールを持つトップレベルグループが必要です。
- 仮想レジストリの設定を有効にしてください。デフォルトで有効になっていますが、[管理者はオフにすることができます](#turn-off-the-virtual-registry)。
- 依存プロキシの設定を有効にしてください。デフォルトで有効になっていますが、[管理者はオフにすることができます](../../../administration/packages/dependency_proxy.md)。
- サポートされている[パッケージ形式](#supported-package-formats)の認証を設定する必要があります。

## 仮想レジストリをオフにする {#turn-off-the-virtual-registry}

仮想レジストリはデフォルトでオンになっています。

前提要件: 

- 仮想レジストリをオフにするには、管理者である必要があります。

仮想レジストリをオフにするには、次の手順に従います:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。このグループはトップレベルにある必要があります。
1. **設定** > **パッケージとレジストリ**を選択します。
1. **Virtual Registry**で、**Enable Virtual Registry**トグルをオフにします。

## サポートされているパッケージ形式 {#supported-package-formats}

- [Mavenパッケージ](maven/_index.md)

## 仮想レジストリのワークフロー {#virtual-registry-workflows}

仮想レジストリを作成する場合:

- レジストリは、特定のパッケージ形式のトップレベルグループでホストされます。プロジェクトとサブグループはサポートされていません。
- 仮想レジストリオブジェクトは、利用可能なアップストリームの順序付きリスト（最大20個）にリンクします。各アップストリームは、外部レジストリを指します。
- 外部レジストリは、パブリックまたはプライベートにすることができます。プライベートレジストリの認証情報はアップストリーム自体に保存されるため、パッケージマネージャーの設定に保存する必要はありません。

仮想レジストリがパッケージのリクエストを受信する場合:

- レジストリは、リクエストを満たすことができるものを探すために、アップストリームの順序付きリストを順に処理します。
- リクエストされたファイルがアップストリームにある場合、仮想レジストリはそのファイルを返し、将来のリクエストのためにキャッシュします。[キャッシュ](#caching-system)により、仮想レジストリを介して少なくとも1回はプルした場合、依存関係の可用性が向上します。

## キャッシュシステム {#caching-system}

すべてのアップストリームレジストリには、次のキャッシュシステムがあります:

- キャッシュエントリにリクエストを保存します
- GitLab仮想レジストリからの同一のリクエストに対する応答を提供します

これにより、同じパッケージがリクエストされたときに、仮想レジストリがアップストリームに再度接続する必要がなくなります。

リクエストされたパスが、利用可能なアップストリームのいずれにもキャッシュされていない場合:

1. 仮想レジストリは、リクエストを満たすことができるものを探すために、アップストリームの順序付きリストを順に処理します。
1. リクエストを満たすことができるアップストリームが見つかった場合、仮想レジストリは、必要に応じて、提供された認証情報を使用してアップストリームから応答をプルします。

リクエストされたパスが、利用可能なアップストリームのいずれかにキャッシュされている場合:

1. 仮想レジストリは、応答を転送する前にキャッシュエントリを更新する必要があるかどうかを確認するために、[キャッシュの有効期間](#cache-validity-period)を確認します。
1. キャッシュが有効な場合、アップストリームのキャッシュエントリはリクエストを満たします。
   - 優先順位の低いアップストリームにキャッシュ内のリクエストがあり、優先順位の高いアップストリームにファイルが含まれているが、リクエストをキャッシュしていない場合、優先順位の低いアップストリームがリクエストを満たします。仮想レジストリは、アップストリームの順序付きリストを再度処理しません。

仮想レジストリは、リクエストを満たすアップストリームが見つからない場合、`404 Not Found`エラーを返します。

### キャッシュの有効期間 {#cache-validity-period}

キャッシュの有効期間は、リクエストを満たすためにキャッシュエントリが有効と見なされる時間を時間単位で設定します。

仮想レジストリが既存のキャッシュエントリからプルする前に、キャッシュの有効期間を確認して、エントリを更新する必要があるかどうかを判断します。

エントリが有効期間外の場合、仮想レジストリは、アップストリームの応答がキャッシュ内の応答と同一であるかどうかを確認します。次の場合:

- 応答が同一の場合、エントリを使用してリクエストを満たします。
- 応答が同一でない場合、アップストリームの応答はアップストリームのキャッシュエントリを上書きするためにアップストリームから再度ダウンロードされます。

ネットワークの状態により、仮想レジストリがアップストリームに接続できない場合、アップストリームは利用可能なキャッシュエントリを使用してリクエストを処理します。

仮想レジストリにキャッシュ内のリクエストに関連する応答がある限り、そのリクエストは、有効期間外であっても満たされます。

#### キャッシュの有効期間を設定する {#set-the-cache-validity-period}

キャッシュの有効期間は、リクエストを満たすための仮想レジストリの全体的なパフォーマンスにおいて重要です。外部レジストリへの接続は、コストのかかる操作です。有効期間が短いほどチェックの量が増え、期間が長いほどチェックの量が減ります。

`0`に設定して、キャッシュの有効期間のチェックをオフにすることができます。

キャッシュの有効期間のデフォルト値は`24`時間です。

アップストリームがターゲットとする外部レジストリがイミュータブルな応答を持つことがわかっている場合は、キャッシュの有効期間を`0`に設定する必要があります。これは多くの場合、公式のパブリックレジストリに当てはまります。詳細については、サポートされている[パッケージ形式](#supported-package-formats)を確認してください。

### オブジェクトストレージの使用状況 {#object-storage-usage}

キャッシュエントリは、[`dependency_proxy`バケット](../../../administration/object_storage.md#configure-the-parameters-of-each-object)内のオブジェクトストレージにファイルを保存します。

オブジェクトストレージの使用量は、トップレベルグループの[オブジェクトストレージの使用量制限](../../storage_usage_quotas.md#view-storage)にカウントされます。

## クリーンアップポリシー {#cleanup-policies}

{{< history >}}

- GitLab 18.6で`maven_virtual_registry`[フラグ](../../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/572839)されました。デフォルトでは有効になっています。

{{< /history >}}

仮想レジストリは、パフォーマンスと可用性を向上させるために、アップストリームレジストリからパッケージをキャッシュします。時間の経過とともに、これらのキャッシュされたエントリが蓄積され、大量のストレージスペースを消費する可能性があります。クリーンアップポリシーを使用して、キャッシュされたコンテンツを自動的に管理し、ストレージの使用量を削減します。

クリーンアップポリシーは、設定可能なルールに基づいてキャッシュされたエントリを削除するスケジュールされたジョブです。クリーンアップポリシーを実行すると、最近ダウンロードされていないキャッシュされたエントリが識別され、ストレージから削除されます。

### クリーンアップポリシーのワークフロー {#cleanup-policies-workflow}

仮想レジストリでは、クリーンアップポリシーは次のようになります:

1. 指定された保持期間内にダウンロードされていないキャッシュされたエントリを識別します。
1. 未使用のキャッシュされたエントリをオブジェクトストレージから削除します。
1. 頻繁にアクセスされるキャッシュされたエントリを保持して、パフォーマンスを維持します。

クリーンアップポリシーは、アップストリームレジストリからのキャッシュされたコンテンツにのみ影響します。影響はありません:

- 仮想レジストリの設定
- アップストリームレジストリの設定
- プロジェクトのパッケージレジストリに保存されているパッケージ

### クリーンアップポリシーを管理 {#manage-cleanup-policies}

前提要件: 

- トップレベルグループのオーナーロールが必要です。
- 仮想レジストリは、グループに対してオンになっている必要があります。

各トップレベルグループは、1つのクリーンアップポリシーしか持つことができません。クリーンアップポリシーは、そのグループ内のすべての仮想レジストリに適用されます。

[Virtual registries cleanup policies API](../../../api/virtual_registries_cleanup_policies.md)を使用して、クリーンアップポリシーを管理できます。

### クリーンアップポリシーの設定 {#cleanup-policy-settings}

次の設定を使用して、クリーンアップポリシーを制御します:

- **ケイデンス**: クリーンアップポリシーの実行頻度を制御します。使用可能なオプションには、毎日、毎週、毎月の間隔があります。
- **Retention period**（保持期間）: 最後にダウンロードされてからキャッシュされたエントリが保持される期間を決定します。この期間内にダウンロードされていないエントリは、削除の対象となります。

### クリーンアップポリシーの実行を監視する {#monitor-cleanup-policy-execution}

クリーンアップポリシーの実行後、次の実行メトリクスを表示できます:

- ポリシーが最後に実行されたとき。
- ポリシーが次に実行されるようにスケジュールされているとき。
- 削除されたキャッシュされたエントリの数。
- 解放されたストレージスペースの合計。
- 実行中に発生したエラー。

これらのメトリクスは、必要に応じて設定を調整できるように、クリーンアップポリシーの有効性を理解するのに役立ちます。

## パフォーマンスに関する考慮事項 {#performance-considerations}

仮想レジストリのパフォーマンスは、次のような要因によって異なる場合があります:

- リクエストされたファイルがアップストリームレジストリからキャッシュされているかどうか
- ファイルが存在するかどうかにかかわらず、アップストリームレジストリがどれだけ迅速に応答できるか
- どのクライアントが依存関係をプルしているか、およびクライアントとGitLabインスタンスの近さ

### トレードオフ {#tradeoffs}

仮想レジストリは、パブリックレジストリよりも高度です。仮想レジストリを使用して依存関係をプルすると、パブリックな公式レジストリなど、他のレジストリよりも時間がかかる場合があります。

パブリックレジストリと比較して、仮想レジストリは、複数のアップストリームレジストリと認証もサポートしています。

### アップストリームの優先順位付け {#upstream-prioritization}

アップストリームレジストリは、順序付けられたリストで編成されています。リクエストがキャッシュに見つからない場合、仮想レジストリは順序付けられたリストをたどって、リクエストを満たすことができる最も高い優先度のアップストリームを見つけます。このシステムは、仮想レジストリのパフォーマンスに著しい影響を与えます。

プライベートアップストリームレジストリのリストを管理する場合:

- リストの一番上に最も多くのパッケージがあるレジストリを優先する必要があります。このアプローチは次のことを可能にします:
  - 優先順位の高いレジストリがリクエストを満たす可能性を高めます
  - 有効なアップストリームレジストリを見つけるために、順序付けられたリスト全体をたどることを防ぎます
- リストの一番下に最も少ない量のパッケージを持つレジストリを配置する必要があります。

### 使用法によるパフォーマンスの向上 {#performance-improvements-with-usage}

仮想レジストリを作成すると、設定された各アップストリームのキャッシュは空になります。各リクエストでは、仮想レジストリが、利用可能なアップストリームレジストリのリストをたどって、リクエストを満たす必要があります。これらの最初のリクエストを満たすには、より時間がかかります。

アップストリームレジストリがリクエストをキャッシュすると、同一のリクエストを満たすまでの時間が短縮されます。時間の経過とともに、より多くのアップストリームレジストリがより多くのリクエストをキャッシュするため、仮想レジストリの全体的なパフォーマンスが向上します。

### CI/CDキャッシュを使用する {#use-the-cicd-cache}

ジョブが仮想レジストリから依存関係をダウンロードする必要がないように、[GitLab CI/CDでのキャッシュ](../../../ci/caching/_index.md#common-use-cases-for-caches)を使用できます。

この方法は実行時間を改善しますが、各依存関係のストレージも複製します（依存関係はCI/CDキャッシュと仮想レジストリに保存されます）。
