---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 脆弱性の重複排除プロセス
description: セキュリティスキャン結果の重複排除
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

パイプラインに、同じ種類の複数のセキュリティレポートを作成するジョブが含まれている場合、同じ脆弱性の検出結果が複数のレポートに存在する可能性があります。この重複は、coverageを向上させるために異なるスキャナーが使用されている場合に一般的ですが、単一のレポートにも存在する可能性があります。重複排除処理を使用すると、管理する必要のある検出結果の数を減らしながら、脆弱性スキャンのcoverageを最大化できます。

検出結果は、[スキャンタイプ](../terminology/_index.md#scan-type-report-type) 、[場所](../terminology/_index.md#location-fingerprint) 、および[主要識別子](../../../development/integrations/secure.md#primary-identifier)が同じである場合、別の検出結果の重複と見なされます。

スキャンタイプは、それぞれに脆弱性の場所の独自の定義を持たせることができるため、一致する必要があります。たとえば、静的アナライザーはファイルパスと行番号を特定できますが、コンテナスキャンアナライザーは代わりにイメージ名を使用します。

識別子を比較する際、GitLabは、`CWE`と`WASC`が「タイプの識別子」であり、脆弱性のグループを分類するために使用されるため、重複排除中に比較しません。これらの識別子を含めると、多くの検出結果が誤って重複と見なされることになります。2つの検出結果は、その識別子がいずれも一致しない場合、一意と見なされます。

重複した検出結果のセットでは、検出結果の最初の出現箇所が保持され、残りはスキップされます。セキュリティレポートはアルファベット順のファイルパスで処理され、検出結果はレポートに表示される順に順番に処理されます。

## 重複排除の例 {#deduplication-examples}

- 例1: 一致する識別子と場所、一致しないスキャンタイプ。
  - 検出結果
    - スキャンタイプ: `dependency_scanning`
    - 位置情報フィンガープリント: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - 識別子: CVE-2022-25510
  - その他の検出結果
    - スキャンタイプ: `container_scanning`
    - 位置情報フィンガープリント: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - 識別子: CVE-2022-25510
  - 重複排除の結果: スキャンタイプが異なるため、重複排除は発生しません。
- 例2: 一致する場所とスキャンタイプ、一致しないタイプの識別子。
  - 検出結果
    - スキャンタイプ: `sast`
    - 位置情報フィンガープリント: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - 識別子: CWE-259
  - その他の検出結果
    - スキャンタイプ: `sast`
    - 位置情報フィンガープリント: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - 識別子: CWE-798
  - 重複排除の結果: `CWE`識別子は無視されるため、重複は発生しません。
- 例3: 一致するスキャンタイプ、場所、および識別子。
  - 検出結果
    - スキャンタイプ: `container_scanning`
    - 位置情報フィンガープリント: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - 識別子: CVE-2019-12345、CVE-2022-25510、CWE-259
  - その他の検出結果
    - スキャンタイプ: `container_scanning`
    - 位置情報フィンガープリント: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - 識別子: CVE-2022-25510、CWE-798
  - 重複排除の結果: すべての基準が一致し、タイプの識別子（CWE）が無視されるため、重複が発生します。この場合、CVE-2022-25510では、1つの識別子のみが一致する必要があります。

各スキャンタイプの定義は、[`gitlab/lib/gitlab/ci/reports/security/locations`](https://gitlab.com/gitlab-org/gitlab/-/tree/master/lib/gitlab/ci/reports/security/locations)と[`gitlab/ee/lib/gitlab/ci/reports/security/locations`](https://gitlab.com/gitlab-org/gitlab/-/tree/master/ee/lib/gitlab/ci/reports/security/locations)にあります。

たとえば、`container_scanning`タイプの場合、場所はタグなしのDockerイメージ名で定義されます。ただし、イメージタグがsemver構文と一致し、Gitコミットハッシュのように見えない場合、重複とは見なされません。

たとえば、次の場所は重複として扱われます:

- `registry.gitlab.com/group-name/project-name/image1:12345019:libcrypto3`
- `registry.gitlab.com/group-name/project-name/image1:libcrypto3`

ただし、次の場所は異なると見なされます:

- `registry.gitlab.com/group-name/project-name/image1:v19202021:libcrypto3`
- `registry.gitlab.com/group-name/project-name/image1:libcrypto3`
