# frozen_string_literal: true

class RemoveProjectFingerprintFromVulnerabilityFeedback < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!
  milestone '18.1'

  def up
    add_concurrent_index(:vulnerability_feedback, [:project_id, :category, :feedback_type],
      name: :index_vulnerability_feedback_on_set_of_common_attributes)
    remove_column :vulnerability_feedback, :project_fingerprint
  end

  def down
    add_column :vulnerability_feedback, :project_fingerprint, :string, limit: 40, if_not_exists: true

    add_concurrent_index(:vulnerability_feedback, [:project_id, :category, :feedback_type, :project_fingerprint],
      name: :index_vulnerability_feedback_on_common_attributes)

    remove_concurrent_index_by_name(:vulnerability_feedback,
      name: :index_vulnerability_feedback_on_set_of_common_attributes)
  end
end
