/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer;

import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jdesktop.beans.AbstractBean;

public class Tile
extends AbstractBean {
    private static final Logger LOG = Logger.getLogger(Tile.class.getName());
    private Throwable error;
    private String url;
    private int zoom;
    private int x;
    private int y;
    private final String key;
    BufferedImage image = null;
    private boolean needsToBeLoaded;
    private boolean needsToBeDownLoaded;
    private PropertyChangeListener uniqueListener = null;

    public Tile(String maptype, int x, int y, int zoom, String url, String baseKey) {
        this.zoom = zoom;
        this.x = x;
        this.y = y;
        this.key = Tile.getKey(maptype, x, y, zoom, url, baseKey);
        this.url = url;
    }

    public String getKey() {
        return this.key;
    }

    private static final String getExt(String url) {
        if (url != null) {
            int idx = url.lastIndexOf(".");
            int idxSplit = url.lastIndexOf("/");
            if (idx > 0 && idx > idxSplit) {
                return url.substring(idx);
            }
        }
        return ".img";
    }

    public static String getKey(String mapname, int x, int y, int zoom, String url, String baseKey) {
        String newKey = baseKey;
        if (baseKey.indexOf(46) < 0) {
            newKey = newKey + Tile.getExt(url);
        }
        if (mapname != null && mapname.length() != 0) {
            newKey = mapname + File.separatorChar + newKey;
        }
        return newKey;
    }

    public Throwable getUnrecoverableError() {
        return this.error;
    }

    public Throwable getLoadingError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNeedsToBeLoaded(boolean state) {
        boolean prev;
        Tile tile = this;
        synchronized (tile) {
            prev = this.needsToBeLoaded;
            this.needsToBeLoaded = state;
        }
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setNeedsToBeDownLoaded(boolean state) {
        boolean prev;
        Tile tile = this;
        synchronized (tile) {
            prev = this.needsToBeDownLoaded;
            this.needsToBeDownLoaded = state;
        }
        return prev;
    }

    public boolean needsToBeDownLoaded() {
        return this.needsToBeDownLoaded;
    }

    public void setImage(BufferedImage img) {
        if (this.image == img) {
            return;
        }
        this.image = img;
        this.firePropertyChangeOnEDT("image", null, this.image);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("image has changed for tile: " + this.getKey());
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void addUniquePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.uniqueListener != null && this.uniqueListener != listener) {
            this.removePropertyChangeListener(propertyName, this.uniqueListener);
        }
        if (this.uniqueListener != listener) {
            this.uniqueListener = listener;
            this.addPropertyChangeListener(propertyName, this.uniqueListener);
        }
    }

    void firePropertyChangeOnEDT(final String propertyName, final Object oldValue, final Object newValue) {
        if (!EventQueue.isDispatchThread()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("enqueuing propertychange for event thread for tile: " + this.getKey());
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("firing property change on event thread for tile " + Tile.this.getKey());
                    }
                    Tile.this.firePropertyChange(propertyName, oldValue, newValue);
                }
            });
        } else {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("firing property change on event thread for tile " + this.getKey());
            }
            this.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public String getURL() {
        return this.url;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Tile)) {
            return false;
        }
        Tile otherTile = (Tile)((Object)other);
        return otherTile.getKey().equals(this.getKey());
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.key != null ? this.key.hashCode() : 0);
        return hash;
    }

    static {
        LOG.setLevel(Level.OFF);
    }
}

