/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Path;
import gps.mvc.CmdParam;
import gps.mvc.GpsController;
import gps.mvc.MTKLogDownloadHandler;
import gps.mvc.MtkModel;
import gps.mvc.ProtectedDevControllerIF;
import gps.mvc.commands.GpsLinkExecCommand;
import gps.mvc.commands.GpsLinkNmeaCommand;
import gps.mvc.commands.mtk.SetMtkBinModeCommand;
import net.sf.bt747.gps.mtk.agps.AgpsUploadHandler;

public class MtkController
implements ProtectedDevControllerIF {
    private MtkModel m;
    private GpsController c;
    private final MTKLogDownloadHandler mtkLogHandler;
    public static final int CMD_HOTSTART = 0;
    public static final int CMD_WARMSTART = 1;
    public static final int CMD_COLDSTART = 2;
    public static final int CMD_FACTORYRESET = 3;
    public static final int CMD_STARTLOG = 4;
    public static final int CMD_STOPLOG = 5;
    public static final int CMD_AUTOLOG_OFF = 6;
    public static final int CMD_AUTOLOG_ON = 7;
    public static final int CMD_SET_LOG_TIME_INTERVAL = 8;
    public static final int CMD_SET_LOG_DISTANCE_INTERVAL = 9;
    public static final int CMD_SET_LOG_SPEED_INTERVAL = 10;
    public static final int CMD_SET_DEVICE_NAME = 11;
    public static final int CMD_STOP_WAITING_FOR_ERASE = 12;
    public static final int CMD_ERASE_LOG = 13;
    public static final int CMD_SET_GPS_FIX_INTERVAL = 14;
    public static final int CMD_SET_LOG_OVERWRITE = 15;
    public static final int CMD_SET_SBAS_TEST_ENABLED = 16;
    public static final int CMD_SET_SBAS_ENABLED = 17;
    public static final int CMD_SET_POWERSAVE_ENABLED = 18;
    public static final int CMD_CANCEL_GETLOG = 19;
    public static final int CMD_EPO_CLEAR = 20;

    MtkController(GpsController gpsController, MtkModel mtkModel) {
        this.c = gpsController;
        this.m = mtkModel;
        this.mtkLogHandler = new MTKLogDownloadHandler(this);
        mtkModel.setLogHandler(this.mtkLogHandler);
    }

    public final MtkModel getMtkModel() {
        return this.m;
    }

    protected final void sendCmd(String string) {
        this.m.getHandler().sendCmd(new GpsLinkNmeaCommand(string));
    }

    protected final void sendCmd$505cbf4b(String string) {
        this.m.getHandler().sendCmd(new GpsLinkNmeaCommand(string, false));
    }

    protected final void sendCmd(GpsLinkExecCommand gpsLinkExecCommand) {
        this.m.getHandler().sendCmd(gpsLinkExecCommand);
    }

    protected final void doSendCmd(GpsLinkExecCommand gpsLinkExecCommand) {
        this.m.getHandler().doSendCmd(gpsLinkExecCommand);
    }

    public final void setLogFormat(int n) {
        if ((n & 0x2000) == 0) {
            n &= 0xFFFE3FFF;
        }
        this.sendCmd("PMTK182,1,2," + JavaLibBridge.unsigned2hex(n, 8));
        this.m.setChanged$13462e();
    }

    @Override
    public boolean cmd(int n) {
        String string = null;
        int n2 = -1;
        switch (n) {
            case 0: {
                string = "PMTK101";
                break;
            }
            case 1: {
                string = "PMTK102";
                break;
            }
            case 2: {
                string = "PMTK103";
                break;
            }
            case 3: {
                string = "PMTK104";
                break;
            }
            case 4: {
                string = "PMTK182,4";
                this.m.setLoggingActive(true);
                break;
            }
            case 5: {
                string = "PMTK182,5";
                this.m.setLoggingActive(false);
                break;
            }
            case 6: {
                string = "PMTK182,11";
                break;
            }
            case 7: {
                string = "PMTK182,10";
                break;
            }
            case 12: {
                this.mtkLogHandler.stopErase();
                break;
            }
            case 13: {
                this.mtkLogHandler.eraseLog();
                break;
            }
            case 19: {
                this.mtkLogHandler.cancelGetLog();
                break;
            }
            case 20: {
                string = "PMTK127";
                this.m.setUnAvailable$13462e();
                n2 = 17;
                break;
            }
            default: {
                return false;
            }
        }
        if (string != null) {
            this.sendCmd(string);
            if (n2 != -1) {
                this.reqData(n2);
            }
        }
        return true;
    }

    @Override
    public boolean reqData(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "PMTK182,2,9,9F";
                break;
            }
            case 3: {
                string = "PMTK182,2,2";
                break;
            }
            case 7: {
                string = "PMTK182,2,7";
                break;
            }
            case 2: {
                string = "PMTK182,2,8";
                break;
            }
            case 1: {
                string = "PMTK182,2,10";
                break;
            }
            case 8: {
                string = "PMTK182,2,12";
                break;
            }
            case 4: {
                string = "PMTK604";
                break;
            }
            case 5: {
                string = "PMTK605";
                break;
            }
            case 6: {
                this.mtkLogHandler.readLog(6, 2);
                return true;
            }
            case 9: {
                this.mtkLogHandler.readLog((this.m.getLogMemSize() - 1 & 0xFFFF0000) + 6, 4);
                return true;
            }
            case 11: {
                string = "PMTK182,2,3";
                break;
            }
            case 12: {
                string = "PMTK182,2,5";
                break;
            }
            case 13: {
                string = "PMTK182,2,4";
                break;
            }
            case 14: {
                string = "PMTK182,2,1";
                this.doSendCmd(new GpsLinkNmeaCommand(string));
                return true;
            }
            case 15: {
                string = "PMTK182,2,11";
                break;
            }
            case 16: {
                string = "PMTK400";
                break;
            }
            case 17: {
                string = "PMTK607";
                break;
            }
            case 18: {
                string = "PMTK182,2,6";
                break;
            }
            case 19: {
                string = "PMTK419";
                break;
            }
            case 20: {
                string = "PMTK413";
                break;
            }
            case 21: {
                string = "PMTK420";
                break;
            }
            case 22: {
                string = "PMTK430";
                break;
            }
            case 23: {
                string = "PMTK414";
                break;
            }
            case 24: {
                string = "PMTK401";
                break;
            }
            case 25: {
                string = "PMTK492";
                break;
            }
            case 26: {
                string = "PMTK490";
                break;
            }
            case 10: {
                string = "HOLUX241,5";
            }
        }
        if (string != null) {
            this.sendCmd(string);
            return true;
        }
        Generic.debug("Serious: (in MtkController) Unknown data type #" + n);
        return false;
    }

    @Override
    public final void setAgpsData(byte[] byArray) {
        AgpsUploadHandler agpsUploadHandler = new AgpsUploadHandler(this.m);
        agpsUploadHandler.setAgpsData(byArray);
        this.c.setDeviceOperationHandler(agpsUploadHandler);
        this.sendCmd(new SetMtkBinModeCommand());
        this.m.setUnAvailable$13462e();
        this.c.setDataNeeded(17);
    }

    @Override
    public boolean cmd(int n, CmdParam object) {
        if (object == null) {
            return this.cmd(n);
        }
        switch (n) {
            case 8: {
                int n2 = ((CmdParam)object).getInt();
                MtkController mtkController = this;
                if (n2 != 0 && n2 > 36000) {
                    n2 = 36000;
                }
                mtkController.sendCmd("PMTK182,1,3," + n2);
                break;
            }
            case 9: {
                int n3 = ((CmdParam)object).getInt();
                MtkController mtkController = this;
                if (n3 != 0 && n3 > 36000) {
                    n3 = 36000;
                } else if (n3 != 0 && n3 <= 0) {
                    n3 = 1;
                }
                mtkController.sendCmd("PMTK182,1,4," + n3);
                break;
            }
            case 10: {
                int n4 = ((CmdParam)object).getInt();
                MtkController mtkController = this;
                if (n4 != 0 && n4 > 36000) {
                    n4 = 36000;
                } else if (n4 != 0 && n4 <= 0) {
                    n4 = 1;
                }
                mtkController.sendCmd("PMTK182,1,5," + n4 * 10);
                break;
            }
            case 11: {
                object = ((CmdParam)object).getString();
                MtkController mtkController = this;
                mtkController.sendCmd("HOLUX241,4," + (String)object);
                mtkController.reqData(10);
                break;
            }
            case 14: {
                int n5 = ((CmdParam)object).getInt();
                MtkController mtkController = this;
                if (n5 > 30000) {
                    n5 = 30000;
                } else if (n5 < 200) {
                    n5 = 200;
                }
                mtkController.sendCmd("PMTK300," + n5 + ",0,0,0.0,0.0");
                break;
            }
            case 15: {
                boolean bl = ((CmdParam)object).getBoolean();
                this.sendCmd("PMTK182,1,6," + (bl ? "1" : "2"));
                break;
            }
            case 16: {
                boolean bl = ((CmdParam)object).getBoolean();
                this.sendCmd("PMTK319," + (bl ? "0" : "1"));
                break;
            }
            case 17: {
                boolean bl = ((CmdParam)object).getBoolean();
                this.sendCmd("PMTK313," + (bl ? "1" : "0"));
                break;
            }
            case 18: {
                boolean bl = ((CmdParam)object).getBoolean();
                this.sendCmd("PMTK320," + (bl ? "1" : "0"));
                break;
            }
            default: {
                Generic.debug("Unsupported cmd in " + this);
                return false;
            }
        }
        return true;
    }

    public final void setDGPSMode(int n) {
        if (n >= 0 && n <= 2) {
            this.sendCmd("PMTK301," + n);
        }
    }

    public final void setDatumMode(int n) {
        if (n >= 0 && n <= 2) {
            this.sendCmd("PMTK330," + n);
        }
    }

    public final void setBtMacAddr(String object) {
        String string = "";
        object = JavaLibBridge.getStringTokenizerInstance((String)object, ':');
        while (object.hasMoreTokens()) {
            string = object.nextToken() + string;
        }
        if (string.length() == 12) {
            this.sendCmd("PMTK392," + string.substring(0, 6) + "," + string.substring(6, 12));
            this.reqData(25);
        }
    }

    public final void setNMEAPeriods(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(255);
        stringBuffer.setLength(0);
        stringBuffer.append("PMTK314");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(nArray[i]);
        }
        this.sendCmd(stringBuffer.toString());
    }

    public final void setFlashUserOption$e5ebae1(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.sendCmd("PMTK390,0," + n + "," + n2 + "," + n3 + "," + n4 + "," + n5 + "," + n6 + "," + n7 + "," + n8);
    }

    public final void logImmediate(int n) {
        if (!this.m.isLoggingActive()) {
            this.cmd(4);
        }
        this.sendCmd("PMTK182,1,1," + JavaLibBridge.unsigned2hex(n, 4));
    }

    public final void setLogRequestAhead(int n) {
        this.mtkLogHandler.setLogRequestAhead(n);
    }

    public final void recoveryEraseLog() {
        this.mtkLogHandler.recoveryEraseLog();
    }

    public final void replyToOkToOverwrite(boolean bl) throws BT747Exception {
        this.mtkLogHandler.replyToOkToOverwrite(bl);
    }

    public final void getLogInit$6a088f64(int n, int n2, BT747Path bT747Path, boolean bl, boolean bl2) {
        this.mtkLogHandler.getLogInit(0, n, n2, bT747Path, bl, bl2);
    }

    @Override
    public final void notifyRun() throws BT747Exception {
        this.mtkLogHandler.notifyRun();
    }

    @Override
    public final void notifyDisconnected() {
        this.mtkLogHandler.notifyDisconnected();
    }

    @Override
    public void getLog(BT747Path bT747Path) {
        Generic.debug("getLog - call unexpected in MtkController");
    }
}

