/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.main;

import java.io.File;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.main.PrebootMain;
import org.jruby.util.cli.Options;

public class DripMain
extends PrebootMain {
    public static RubyInstanceConfig DRIP_CONFIG;
    public static Ruby DRIP_RUNTIME;
    public static final String JRUBY_DRIP_WARMUP_ENV = "JRUBY_DRIP_WARMUP";
    public static final String JRUBY_DRIP_WARMUP_DEFAULT = "1 + 1";
    public static final String JRUBY_DRIP_FILE = "./dripmain.rb";

    public static void main(String[] args2) {
        DripMain.preboot(new DripMain(), args2);
    }

    @Override
    protected String[] warmup(String[] args2) {
        Ruby ruby = Ruby.newInstance();
        String envWarmup = System.getenv(JRUBY_DRIP_WARMUP_ENV);
        if (envWarmup != null && envWarmup.length() > 0) {
            ruby.evalScriptlet(envWarmup);
        } else {
            ruby.evalScriptlet(JRUBY_DRIP_WARMUP_DEFAULT);
        }
        Ruby.clearGlobalRuntime();
        return args2;
    }

    @Override
    protected String[] prepareOptions(String[] args2) {
        Options.NATIVE_STDIO.force("false");
        return args2;
    }

    @Override
    protected Ruby prepareRuntime(RubyInstanceConfig config2, String[] args2) {
        Ruby ruby = super.prepareRuntime(config2, args2);
        File dripMain = new File(JRUBY_DRIP_FILE);
        if (dripMain.exists()) {
            ruby.getLoadService().load(dripMain.getAbsolutePath(), false);
        }
        return ruby;
    }

    @Override
    protected void endPreboot(RubyInstanceConfig config2, Ruby ruby, String[] args2) {
        super.endPreboot(config2, ruby, args2);
        DRIP_CONFIG = config2;
        DRIP_RUNTIME = ruby;
    }
}

