/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;
import org.openide.util.Enumerations;
import org.openide.util.Utilities;

public class ExtensionList
implements Cloneable,
Serializable {
    private static final boolean CASE_INSENSITIVE = Utilities.isWindows() || Utilities.getOperatingSystem() == 2048 || Utilities.getOperatingSystem() == 16384;
    private Set<String> list;
    private Set<String> mimeTypes;
    static final long serialVersionUID = 8868581349510386291L;

    public synchronized Object clone() {
        try {
            ExtensionList extensionList = (ExtensionList)super.clone();
            if (this.list != null) {
                extensionList.list = new HashSet<String>();
                extensionList.list.addAll(this.list);
            }
            if (this.mimeTypes != null) {
                extensionList.mimeTypes = new HashSet<String>();
                extensionList.mimeTypes.addAll(this.mimeTypes);
            }
            return extensionList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized void addExtension(String string) {
        if (this.list == null) {
            this.list = new HashSet<String>();
        }
        this.list.add(string);
    }

    public void removeExtension(String string) {
        if (this.list != null) {
            this.list.remove(string);
        }
    }

    public synchronized void addMimeType(String string) {
        if (this.mimeTypes == null) {
            this.mimeTypes = new HashSet<String>();
        }
        this.mimeTypes.add(string);
    }

    public void removeMimeType(String string) {
        if (this.mimeTypes != null) {
            this.mimeTypes.remove(string);
        }
    }

    public boolean isRegistered(String string) {
        if (this.list == null) {
            return false;
        }
        try {
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            return this.list.contains(string2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return false;
        }
    }

    public boolean isRegistered(FileObject fileObject) {
        String string;
        if (this.list != null && this.list.contains(fileObject.getExt())) {
            return true;
        }
        return this.mimeTypes != null && this.mimeTypes.contains(string = fileObject.getMIMEType(this.mimeTypes.toArray(new String[0])));
    }

    public Enumeration<String> extensions() {
        return ExtensionList.en(this.list);
    }

    public Enumeration<String> mimeTypes() {
        return ExtensionList.en(this.mimeTypes);
    }

    public String toString() {
        return "ExtensionList[" + this.list + this.mimeTypes + "]";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtensionList)) {
            return false;
        }
        ExtensionList extensionList = (ExtensionList)object;
        return ExtensionList.equalSets(this.list, extensionList.list, CASE_INSENSITIVE) && ExtensionList.equalSets(this.mimeTypes, extensionList.mimeTypes, false);
    }

    public int hashCode() {
        int n = 0;
        if (this.list != null) {
            n = ExtensionList.normalizeSet(this.list, CASE_INSENSITIVE).hashCode();
        }
        if (this.mimeTypes != null) {
            n += ExtensionList.normalizeSet(this.mimeTypes, false).hashCode();
        }
        return n;
    }

    private static boolean equalSets(Set<String> set, Set<String> set2, boolean bl) {
        if (set == null && set2 == null) {
            return true;
        }
        Set<String> set3 = ExtensionList.normalizeSet(set, bl);
        Set<String> set4 = ExtensionList.normalizeSet(set2, bl);
        return set3.equals(set4);
    }

    private static Set<String> normalizeSet(Set<String> set, boolean bl) {
        if (set == null || set.isEmpty()) {
            return Collections.emptySet();
        }
        if (bl) {
            HashSet<String> hashSet = new HashSet<String>(set.size() * 4 / 3 + 1);
            for (String string : set) {
                hashSet.add(string.toLowerCase(Locale.US));
            }
            return hashSet;
        }
        return set;
    }

    private static Enumeration<String> en(Collection<String> collection) {
        if (collection == null) {
            return Enumerations.empty();
        }
        return Collections.enumeration(ExtensionList.createExtensionSet(collection));
    }

    private static SortedSet<String> createExtensionSet(Collection<String> collection) {
        TreeSet<String> treeSet = CASE_INSENSITIVE ? new TreeSet(String.CASE_INSENSITIVE_ORDER) : new TreeSet<String>();
        treeSet.addAll(collection);
        return treeSet;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Set<String> set = getField.get("list", null);
        if (set instanceof Map) {
            set = ((Map)((Object)set)).keySet();
        }
        if (set != null) {
            this.list = ExtensionList.createExtensionSet(set);
        }
        this.mimeTypes = (Set)getField.get("mimeTypes", null);
    }
}

