/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXPathObject;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.generic.TeXParserSetUndefAction;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXFile;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;

public abstract class LaTeXSty
extends LaTeXFile {
    public LaTeXSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(laTeXParserListener.getParser(), keyValList, string, "sty", bl);
    }

    public LaTeXSty(KeyValList keyValList, String string, String string2, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(laTeXParserListener.getParser(), keyValList, string, string2, bl);
    }

    public void parseFile(TeXObjectList teXObjectList) throws IOException {
        if (this.getFile().exists()) {
            UndefAction undefAction = this.listener.getUndefinedAction();
            int n = this.getParser().getCatCode(64);
            ControlSequence controlSequence = this.getParser().getControlSequence("@currname");
            ControlSequence controlSequence2 = this.getParser().getControlSequence("@currext");
            String string = null;
            String string2 = null;
            if (string != null) {
                string = this.getParser().expandToString(controlSequence, this.getParser());
            }
            if (string2 != null) {
                string2 = this.getParser().expandToString(controlSequence2, this.getParser());
            }
            TeXObjectList teXObjectList2 = this.listener.createStack();
            teXObjectList2.add(new TeXParserSetUndefAction(UndefAction.WARN));
            if (n != 11) {
                teXObjectList2.add(this.listener.getControlSequence("makeatletter"));
            }
            teXObjectList2.add(this.listener.getControlSequence("def"));
            teXObjectList2.add(new TeXCsRef("@currname"));
            teXObjectList2.add(this.listener.createGroup(this.getName()));
            teXObjectList2.add(this.listener.getControlSequence("def"));
            teXObjectList2.add(new TeXCsRef("@currext"));
            teXObjectList2.add(this.listener.createGroup(this.getExtension()));
            teXObjectList2.add(this.listener.getControlSequence("input"));
            teXObjectList2.add(new TeXPathObject(this));
            if (string != null) {
                teXObjectList2.add(this.listener.getControlSequence("def"));
                teXObjectList2.add(new TeXCsRef("@currname"));
                teXObjectList2.add(this.listener.createGroup(string));
            }
            if (string2 != null) {
                teXObjectList2.add(this.listener.getControlSequence("def"));
                teXObjectList2.add(new TeXCsRef("@currext"));
                teXObjectList2.add(this.listener.createGroup(string2));
            }
            if (n != 11) {
                teXObjectList2.add(this.listener.getControlSequence("catcode"));
                teXObjectList2.add(new UserNumber(64));
                teXObjectList2.add(this.listener.getOther(61));
                teXObjectList2.add(new UserNumber(n));
            }
            teXObjectList2.add(new TeXParserSetUndefAction(undefAction));
            TeXParserUtils.process(teXObjectList2, this.getParser(), teXObjectList);
        }
    }

    public abstract void addDefinitions();

    @Override
    protected void postOptions(TeXObjectList teXObjectList) throws IOException {
        if (this.getParser().isDebugMode(1024)) {
            this.getParser().logMessage("Adding definitions for " + this.getName());
        }
        this.addDefinitions();
    }

    public void registerControlSequence(ControlSequence controlSequence) {
        this.listener.registerControlSequence(this, controlSequence);
    }

    public DimenRegister registerNewLength(String string) {
        return this.listener.getParser().getSettings().newdimen(string);
    }

    public DimenRegister registerNewLength(String string, float f, TeXUnit teXUnit) {
        DimenRegister dimenRegister = this.registerNewLength(string);
        try {
            dimenRegister.setValue(this.listener.getParser(), new UserDimension(f, teXUnit));
        }
        catch (TeXSyntaxException teXSyntaxException) {
            // empty catch block
        }
        return dimenRegister;
    }
}

