/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.light;

import org.sunflow.SunflowAPI;
import org.sunflow.core.Instance;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class PointLight
implements LightSource {
    private Point3 lightPoint = new Point3(0.0f, 0.0f, 0.0f);
    private Color power = Color.WHITE;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.lightPoint = parameterList.getPoint("center", this.lightPoint);
        this.power = parameterList.getColor("power", this.power);
        return true;
    }

    public int getNumSamples() {
        return 1;
    }

    public void getSamples(ShadingState shadingState) {
        Vector3 vector3 = Point3.sub(this.lightPoint, shadingState.getPoint(), new Vector3());
        if (Vector3.dot(vector3, shadingState.getNormal()) > 0.0f && Vector3.dot(vector3, shadingState.getGeoNormal()) > 0.0f) {
            LightSample lightSample = new LightSample();
            lightSample.setShadowRay(new Ray(shadingState.getPoint(), this.lightPoint));
            float f = 1.0f / (float)(Math.PI * 4 * (double)this.lightPoint.distanceToSquared(shadingState.getPoint()));
            lightSample.setRadiance(this.power, this.power);
            lightSample.getDiffuseRadiance().mul(f);
            lightSample.getSpecularRadiance().mul(f);
            lightSample.traceShadow(shadingState);
            shadingState.addSample(lightSample);
        }
    }

    public void getPhoton(double d, double d2, double d3, double d4, Point3 point3, Vector3 vector3, Color color) {
        point3.set(this.lightPoint);
        float f = (float)(Math.PI * 2 * d);
        float f2 = (float)Math.sqrt(d2 * (1.0 - d2));
        vector3.x = (float)Math.cos(f) * f2;
        vector3.y = (float)Math.sin(f) * f2;
        vector3.z = (float)(1.0 - 2.0 * d2);
        color.set(this.power);
    }

    public float getPower() {
        return this.power.getLuminance();
    }

    public Instance createInstance() {
        return null;
    }
}

