/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFDCNConnectionGroup;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleDataSource;

public class NTFDCNConnection
extends Thread
implements Monitor {
    private String clientId;
    private String instanceName;
    private String serviceName;
    private String userName;
    private OpaqueString password;
    private String connClass;
    private ArrayList<String> listenerAddresses;
    private static final int MAX_NUMBER_OF_TRIES = 5;
    private Connection conn = null;
    private T4CTTIoaqnfy oaqnfy = null;
    private volatile boolean needToBeClosed = false;
    private boolean safeToClose = true;
    private int numberOfRegistrations = 0;
    private NTFDCNConnectionGroup connectionGroup = null;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private Properties extrAuthProp = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    NTFDCNConnection(String clientId, ArrayList<String> listenerAddresses, String instanceName, String serviceName, String userName, OpaqueString password, Properties _extrAuthProp, String connClass, int numberOfRegistrations) {
        this.userName = userName;
        this.password = password;
        this.extrAuthProp = _extrAuthProp;
        this.serviceName = serviceName;
        this.clientId = clientId;
        this.listenerAddresses = listenerAddresses;
        this.instanceName = instanceName;
        this.connClass = connClass;
        this.numberOfRegistrations = numberOfRegistrations;
        assert (listenerAddresses != null) : "listenerAddresses is null";
        assert (instanceName != null) : "instancename is null";
    }

    @Override
    public void run() {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        boolean retry = false;
        boolean reConnect = false;
        int conAttempt = 0;
        int errorCode = 0;
        for (int cnt = 0; cnt < 2 && !this.needToBeClosed; ++cnt) {
            try {
                if (cnt == 0 || reConnect) {
                    this.conn = this.getConnection(conAttempt);
                    this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.clientId, true);
                }
                if (retry || !this.needToBeClosed) {
                    retry = false;
                    reConnect = false;
                    cnt = 0;
                }
                this.oaqnfy.doRPC();
                continue;
            }
            catch (IOException eIo) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFDCNConnection - connectionId = " + this.clientId + ", userName = " + this.userName + ", connClass = " + this.connClass + ", instnaceName =" + this.instanceName + ": ERROR: got Exception during thread execution" + eIo.getMessage());
                }
                this.needToBeClosed = true;
                continue;
            }
            catch (Exception e2) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFDCNConnection - connectionId = " + this.clientId + ", userName = " + this.userName + ", connClass = " + this.connClass + ", instnaceName =" + this.instanceName + ": ERROR: got Exception during thread execution" + e2.getMessage());
                }
                if (this.needToBeClosed || retry) break;
                if (e2 instanceof SQLException) {
                    errorCode = ((SQLException)e2).getErrorCode();
                }
                if (errorCode == 17410) {
                    reConnect = true;
                    errorCode = 0;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {}
                } else {
                    reConnect = false;
                }
                retry = true;
            }
        }
        if (bl) {
            OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFDCNConnection -, connectionId = " + this.clientId + ", userName = " + this.userName + ": end of run method. Thread will be closed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    Connection getConnection(int n2) throws SQLException, InterruptedException {
        void noOfTries;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        Connection notificationConnection = null;
        OracleDataSource ods = new OracleDataSource();
        Properties props = new Properties();
        if (this.extrAuthProp != null) {
            if (bl) {
                OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "getConnection - Using externally supplied authentication properties.");
            }
            props.putAll((Map<?, ?>)this.extrAuthProp);
        }
        if (this.userName != null) {
            ods.setUser(this.userName);
            ods.setPassword(this.password.get());
        }
        if (this.connClass != null) {
            props.put("oracle.jdbc.DRCPConnectionClass", this.connClass);
            props.put("oracle.jdbc.jmsNotification", "true");
            props.put("oracle.jdbc.ReadTimeout", (Object)0);
            props.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
        }
        ods.setConnectionProperties(props);
        while (notificationConnection == null && ++noOfTries < 5 && !this.needToBeClosed) {
            notificationConnection = this.tryListenerAddressesToGetConnection(ods);
            if (notificationConnection != null || noOfTries >= 5) continue;
            Thread.sleep((long)(noOfTries * 5000));
        }
        if (notificationConnection == null && !this.needToBeClosed) {
            throw new SQLException("Failed to create notification connection to emon server");
        }
        return notificationConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Connection tryListenerAddressesToGetConnection(OracleDataSource ods) {
        Iterator<String> iterator = this.listenerAddresses.iterator();
        while (iterator.hasNext()) {
            String listenerAddress = iterator.next();
            String url = "jdbc:oracle:thin:@(DESCRIPTION=" + listenerAddress + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
            ods.setURL(url);
            try {
                Monitor.CloseableLock lock = this.acquireCloseableLock();
                try {
                    if (this.needToBeClosed) {
                        Connection connection = null;
                        return connection;
                    }
                    Connection notificationConnection = ods.getConnection();
                    if (notificationConnection == null) continue;
                    Connection connection = notificationConnection;
                    return connection;
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    void closeThisListener() {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.needToBeClosed = true;
            try {
                if (this.oaqnfy != null) {
                    this.oaqnfy.stopListening();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "NTFDCNConnection -, dcnConnectionId = " + this.clientId + ", userName = " + this.userName + ": ERROR: got SQLException while closing the connection " + ex.getMessage());
                }
            }
        }
    }

    void setNeedToBeClosed(boolean _needToBeClosed) {
        this.needToBeClosed = _needToBeClosed;
    }

    String getClientId() {
        return this.clientId;
    }

    int getNumberOfRegistrations() {
        return this.numberOfRegistrations;
    }

    void incrementNumberOfRegistrations(int n2) {
        this.numberOfRegistrations += n2;
    }

    void decrementNumberOfRegistrations(int n2) {
        this.numberOfRegistrations -= n2;
    }

    void setConnectionGroup(NTFDCNConnectionGroup connGroup) {
        this.connectionGroup = connGroup;
    }

    NTFDCNConnectionGroup getConnectionGroup() {
        if (this.connectionGroup == null) {
            this.connectionGroup = PhysicalConnection.ntfManager.getDCNConnectionGroup(this.userName + this.instanceName);
        }
        return this.connectionGroup;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    static {
        try {
            $$$methodRef$$$12 = NTFDCNConnection.class.getDeclaredConstructor(String.class, ArrayList.class, String.class, String.class, String.class, OpaqueString.class, Properties.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFDCNConnection.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFDCNConnection.class.getDeclaredMethod("getConnectionGroup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFDCNConnection.class.getDeclaredMethod("setConnectionGroup", NTFDCNConnectionGroup.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFDCNConnection.class.getDeclaredMethod("decrementNumberOfRegistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFDCNConnection.class.getDeclaredMethod("incrementNumberOfRegistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFDCNConnection.class.getDeclaredMethod("getNumberOfRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFDCNConnection.class.getDeclaredMethod("getClientId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFDCNConnection.class.getDeclaredMethod("setNeedToBeClosed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFDCNConnection.class.getDeclaredMethod("closeThisListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFDCNConnection.class.getDeclaredMethod("tryListenerAddressesToGetConnection", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFDCNConnection.class.getDeclaredMethod("getConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFDCNConnection.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

