/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.INativePlugin;
import com.amazon.redshift.NativeTokenHolder;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.IdpCredentialsProvider;
import com.amazon.redshift.plugin.InternalPluginException;
import com.amazon.redshift.plugin.httpserver.RequestHandler;
import com.amazon.redshift.plugin.httpserver.Server;
import com.amazon.redshift.plugin.utils.CheckUtils;
import com.amazon.redshift.plugin.utils.ResponseUtils;
import com.amazon.redshift.util.RedshiftException;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.NameValuePair;

public class BrowserOktaSAMLCredentialsProvider
extends IdpCredentialsProvider
implements INativePlugin {
    private String m_login_url;
    public static final String KEY_LOGIN_URL = "login_url";
    public static final String KEY_IDP_RESPONSE_TIMEOUT = "idp_response_timeout";
    public static final String KEY_LISTEN_PORT = "listen_port";
    private static final String SAML_RESPONSE_PARAM_NAME = "SAMLResponse";
    private int m_idp_response_timeout = 120;
    private int m_listen_port = 7890;
    private int EXPIRY_TIME = 5;
    private static Map<String, NativeTokenHolder> m_cache = new HashMap<String, NativeTokenHolder>();
    private NativeTokenHolder m_lastRefreshCredentials;
    protected Boolean m_disableCache = false;
    private static final String LOG_PROPERTIES_FILE_NAME = "log-factory.properties";
    private static final String LOG_PROPERTIES_FILE_PATH = "META-INF/services/org.apache.commons.logging.LogFactory";
    private static final ClassLoader CONTEXT_CLASS_LOADER = new ClassLoader(BrowserOktaSAMLCredentialsProvider.class.getClassLoader()){

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> clazz = this.getParent().loadClass(name);
            return clazz;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if ("commons-logging.properties".equals(name)) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }

        @Override
        public URL getResource(String name) {
            if (BrowserOktaSAMLCredentialsProvider.LOG_PROPERTIES_FILE_PATH.equals(name)) {
                return BrowserOktaSAMLCredentialsProvider.class.getResource(BrowserOktaSAMLCredentialsProvider.LOG_PROPERTIES_FILE_NAME);
            }
            return super.getResource(name);
        }
    };

    @Override
    public void addParameter(String key, String value) {
        switch (key) {
            case "listen_port": {
                this.m_listen_port = Integer.parseInt(value);
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_listen_port: {0}", this.m_listen_port);
                break;
            }
            case "login_url": {
                this.m_login_url = value;
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_login_url: {0}", this.m_login_url);
                break;
            }
            case "idp_response_timeout": {
                this.m_idp_response_timeout = Integer.parseInt(value);
                if (!RedshiftLogger.isEnable()) break;
                this.m_log.logDebug("m_idp_response_timeout: {0}", this.m_idp_response_timeout);
            }
        }
    }

    @Override
    public void setLogger(RedshiftLogger log) {
        this.m_log = log;
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return this.m_login_url != null ? this.m_login_url : "";
    }

    @Override
    public String getIdpToken() throws RedshiftException {
        String saml = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        try {
            saml = this.getSamlAssertion();
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("BrowserOktaSAMLCredentialsProvider: got SAML token", new Object[0]);
            }
        }
        catch (Exception e) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(e);
            }
            throw new RedshiftException("SAML error: " + e.getMessage(), e);
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
        return saml;
    }

    @Override
    public String getCacheKey() {
        String pluginSpecificKey = this.getPluginSpecificCacheKey();
        return pluginSpecificKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeTokenHolder getCredentials() throws RedshiftException {
        NativeTokenHolder credentials = null;
        if (!this.m_disableCache.booleanValue()) {
            String key = this.getCacheKey();
            credentials = m_cache.get(key);
        }
        if (credentials == null || credentials.isExpired()) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logInfo("SAML getCredentials NOT from cache", new Object[0]);
            }
            BrowserOktaSAMLCredentialsProvider browserOktaSAMLCredentialsProvider = this;
            synchronized (browserOktaSAMLCredentialsProvider) {
                this.refresh();
                if (this.m_disableCache.booleanValue()) {
                    credentials = this.m_lastRefreshCredentials;
                    this.m_lastRefreshCredentials = null;
                }
            }
        } else {
            credentials.setRefresh(false);
            if (RedshiftLogger.isEnable()) {
                this.m_log.logInfo("SAML getCredentials from cache", new Object[0]);
            }
        }
        if (!this.m_disableCache.booleanValue()) {
            credentials = m_cache.get(this.getCacheKey());
        }
        if (credentials == null) {
            throw new RedshiftException("Unable to get IDP credentials");
        }
        return credentials;
    }

    @Override
    public void refresh() throws RedshiftException {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        try {
            String saml = this.getSamlAssertion();
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("BrowserOktaSAMLCredentialsProvider: refreshed SAML assertion token", new Object[0]);
            }
            Date expiration = new Date(System.currentTimeMillis() + (long)(this.EXPIRY_TIME * 60 * 1000));
            NativeTokenHolder credentials = NativeTokenHolder.newInstance(saml, expiration);
            credentials.setRefresh(true);
            if (!this.m_disableCache.booleanValue()) {
                m_cache.put(this.getCacheKey(), credentials);
            } else {
                this.m_lastRefreshCredentials = credentials;
            }
        }
        catch (Exception e) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(e);
            }
            throw new RedshiftException("SAML error: " + e.getMessage(), e);
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
    }

    protected String getSamlAssertion() throws IOException {
        try {
            CheckUtils.checkMissingAndThrows(this.m_login_url, KEY_LOGIN_URL);
            CheckUtils.checkAndThrowsWithMessage(this.m_idp_response_timeout < 10, "idp_response_timeout should be 10 seconds or greater.");
            CheckUtils.checkInvalidAndThrows(this.m_listen_port < 1 || this.m_listen_port > 65535, KEY_LISTEN_PORT);
            this.validateURL(this.m_login_url);
            return this.authenticate();
        }
        catch (InternalPluginException ex) {
            throw new IOException(ex);
        }
    }

    private String authenticate() throws IOException {
        RequestHandler requestHandler = new RequestHandler(new Function<List<NameValuePair>, Object>(){

            @Override
            public Object apply(List<NameValuePair> nameValuePairs) {
                if (RedshiftLogger.isEnable()) {
                    for (NameValuePair pair : nameValuePairs) {
                        if (pair.getName().equals(BrowserOktaSAMLCredentialsProvider.SAML_RESPONSE_PARAM_NAME)) {
                            BrowserOktaSAMLCredentialsProvider.this.m_log.logDebug("nameValuePair:name= {0}", BrowserOktaSAMLCredentialsProvider.SAML_RESPONSE_PARAM_NAME);
                            continue;
                        }
                        BrowserOktaSAMLCredentialsProvider.this.m_log.logDebug("nameValuePair: {0}", pair);
                    }
                }
                return ResponseUtils.findParameter(BrowserOktaSAMLCredentialsProvider.SAML_RESPONSE_PARAM_NAME, nameValuePairs);
            }
        });
        Server server = new Server(this.m_listen_port, requestHandler, Duration.ofSeconds(this.m_idp_response_timeout), this.m_log);
        server.listen();
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, String.format("Listening for connection on port %d", this.m_listen_port), new Object[0]);
        }
        try {
            this.openBrowser();
            server.waitForResult();
        }
        catch (IOException ex) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(ex);
            }
            server.stop();
            throw ex;
        }
        server.waitForResult();
        Object result = requestHandler.getResult();
        if (result instanceof InternalPluginException) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("Error occurred while fetching SAML assertion: {0}", result);
            }
            throw (InternalPluginException)result;
        }
        if (result instanceof String) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.log(LogLevel.DEBUG, "Got SAML assertion of length={0}", ((String)result).length());
            }
            return (String)result;
        }
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("result: {0}", result);
        }
        throw new InternalPluginException("Fail to login during timeout.");
    }

    private void openBrowser() throws IOException {
        URI authorizeRequestUrl = URI.create(this.m_login_url);
        if (RedshiftLogger.isEnable()) {
            this.m_log.log(LogLevel.DEBUG, String.format("SSO URI: \n%s", authorizeRequestUrl), new Object[0]);
        }
        this.validateURL(authorizeRequestUrl.toString());
        Desktop.getDesktop().browse(authorizeRequestUrl);
    }
}

