/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import schemacrawler.schema.Reducer;
import schemacrawler.schema.ReducibleCollection;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schemacrawler.FilterOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.utility.MetaDataUtility;

final class TablesReducer
implements Reducer<Table> {
    private final SchemaCrawlerOptions options;
    private final Predicate<Table> tableFilter;

    TablesReducer(SchemaCrawlerOptions options, Predicate<Table> tableFilter) {
        this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
        this.tableFilter = Objects.requireNonNull(tableFilter, "No table filter provided");
    }

    @Override
    public void reduce(ReducibleCollection<? extends Table> allTables) {
        if (allTables == null) {
            return;
        }
        this.doReduce(allTables);
    }

    @Override
    public void undo(ReducibleCollection<? extends Table> allTables) {
        if (allTables == null) {
            return;
        }
        allTables.resetFilter();
    }

    private void doReduce(ReducibleCollection<? extends Table> allTables) {
        HashSet<Table> reducedTables = new HashSet<Table>();
        for (Table table : allTables) {
            if (!this.tableFilter.test(table)) continue;
            reducedTables.add(table);
        }
        FilterOptions filterOptions = this.options.filterOptions();
        int n = filterOptions.childTableFilterDepth();
        Collection<Table> childTables = this.includeRelatedTables(TableRelationshipType.child, n, reducedTables);
        int parentTableFilterDepth = filterOptions.parentTableFilterDepth();
        Collection<Table> parentTables = this.includeRelatedTables(TableRelationshipType.parent, parentTableFilterDepth, reducedTables);
        HashSet<Table> keepTables = new HashSet<Table>();
        keepTables.addAll(reducedTables);
        keepTables.addAll(childTables);
        keepTables.addAll(parentTables);
        allTables.filter(keepTables::contains);
    }

    private Collection<Table> includeRelatedTables(TableRelationshipType tableRelationshipType, int depth, Set<Table> greppedTables) {
        HashSet<Table> includedTables = new HashSet<Table>();
        includedTables.addAll(greppedTables);
        for (int i = 0; i < depth; ++i) {
            for (Table table : new HashSet<Table>(includedTables)) {
                for (Table relatedTable : table.getRelatedTables(tableRelationshipType)) {
                    if (MetaDataUtility.isPartial(relatedTable)) continue;
                    includedTables.add(relatedTable);
                }
            }
        }
        return includedTables;
    }
}

