/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public class LinkedHashSet<A>
extends AbstractSet<A>
implements StrictOptimizedIterableOps<A, LinkedHashSet, LinkedHashSet<A>>,
DefaultSerializable {
    private Entry<A> firstEntry = null;
    private Entry<A> lastEntry = null;
    public Entry<A>[] scala$collection$mutable$LinkedHashSet$$table = new Entry[this.tableSizeFor(16)];
    private int threshold = (int)((double)this.scala$collection$mutable$LinkedHashSet$$table.length * 0.75);
    private int contentSize = 0;

    /*
     * WARNING - void declaration
     */
    @Override
    public Tuple2<LinkedHashSet<A>, LinkedHashSet<A>> partition(Function1<A, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <A1, A2> Tuple2<LinkedHashSet<A1>, LinkedHashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object dropRight(int n) {
        void var1_1;
        return StrictOptimizedIterableOps.dropRight$(this, (int)var1_1);
    }

    @Override
    public IterableFactory<LinkedHashSet> iterableFactory() {
        return LinkedHashSet$.MODULE$;
    }

    public Entry<A> firstEntry() {
        return this.firstEntry;
    }

    /*
     * WARNING - void declaration
     */
    public void firstEntry_$eq(Entry<A> x$1) {
        void var1_1;
        this.firstEntry = var1_1;
    }

    public Entry<A> lastEntry() {
        return this.lastEntry;
    }

    /*
     * WARNING - void declaration
     */
    public void lastEntry_$eq(Entry<A> x$1) {
        void var1_1;
        this.lastEntry = var1_1;
    }

    @Override
    public A last() {
        if (this.size() > 0) {
            return this.lastEntry().key();
        }
        throw new NoSuchElementException("Cannot call .last on empty LinkedHashSet");
    }

    @Override
    public Option<A> lastOption() {
        if (this.size() > 0) {
            return new Some<A>(this.lastEntry().key());
        }
        return None$.MODULE$;
    }

    @Override
    public A head() {
        if (this.size() > 0) {
            return this.firstEntry().key();
        }
        throw new NoSuchElementException("Cannot call .head on empty LinkedHashSet");
    }

    @Override
    public Option<A> headOption() {
        if (this.size() > 0) {
            return new Some<A>(this.firstEntry().key());
        }
        return None$.MODULE$;
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(A elem) {
        void var2_2;
        void var1_1;
        int findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(elem);
        int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash >>> 16;
        Entry<void> entry = this.scala$collection$mutable$LinkedHashSet$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashSet$$table.length - 1];
        return (entry == null ? null : entry.findEntry(var1_1, (int)var2_2)) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / 0.75));
        if (target > this.scala$collection$mutable$LinkedHashSet$$table.length) {
            void var1_1;
            this.growTable((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(A elem) {
        void var1_1;
        void var2_2;
        if (this.contentSize + 1 >= this.threshold) {
            LinkedHashSet linkedHashSet = this;
            linkedHashSet.growTable(linkedHashSet.scala$collection$mutable$LinkedHashSet$$table.length << 1);
        }
        int scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(elem);
        int hash = scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash >>> 16;
        void v1 = var2_2;
        return this.put0(var1_1, (int)v1, v1 & this.scala$collection$mutable$LinkedHashSet$$table.length - 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LinkedHashSet<A> addOne(A elem) {
        void var1_1;
        this.add(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LinkedHashSet<A> subtractOne(A elem) {
        void var1_1;
        this.remove(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(A elem) {
        void var1_2;
        A a = elem;
        int scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(a);
        return this.remove0(a, scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ var1_2 >>> 16);
    }

    @Override
    public Iterator<A> iterator() {
        return new LinkedHashSetIterator<A>(this){

            public final A extract(Entry<A> nd) {
                return nd.key();
            }
            {
                void var1_1;
            }
        };
    }

    public Iterator<Entry<A>> entryIterator() {
        return new LinkedHashSetIterator<Entry<A>>(this){

            public final Entry<A> extract(Entry<A> nd) {
                return nd;
            }
            {
                void var1_1;
            }
        };
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        for (Entry<A> cur = this.firstEntry(); cur != null; cur = cur.later()) {
            f.apply(cur.key());
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.scala$collection$mutable$LinkedHashSet$$table, null);
        this.contentSize = 0;
        this.firstEntry_$eq(null);
        this.lastEntry_$eq(null);
    }

    private int tableSizeFor(int capacity) {
        int n;
        --n;
        n = Integer.highestOneBit(Math.max(n, 4)) << 1;
        return Math.min(n, 0x40000000);
    }

    public int unimproveHash(int improvedHash) {
        int n = improvedHash;
        return n ^ n >>> 16;
    }

    /*
     * WARNING - void declaration
     */
    private Entry<A> createNewEntry(A key, int hash) {
        void var1_1;
        void var2_2;
        Entry<A> e = new Entry<A>(key, (int)var2_2);
        if (this.firstEntry() == null) {
            this.firstEntry_$eq(e);
        } else {
            this.lastEntry().later_$eq(e);
            e.earlier_$eq(this.lastEntry());
        }
        this.lastEntry_$eq(e);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void deleteEntry(Entry<A> e) {
        void var1_1;
        if (e.earlier() == null) {
            this.firstEntry_$eq(e.later());
        } else {
            e.earlier().later_$eq(e.later());
        }
        if (e.later() == null) {
            this.lastEntry_$eq(e.earlier());
        } else {
            e.later().earlier_$eq(e.earlier());
        }
        e.earlier_$eq(null);
        e.later_$eq(null);
        var1_1.next_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    private boolean put0(A elem, int hash, int idx) {
        Entry<A> entry = this.scala$collection$mutable$LinkedHashSet$$table[idx];
        if (entry == null) {
            this.scala$collection$mutable$LinkedHashSet$$table[idx] = this.createNewEntry(elem, hash);
        } else {
            void var2_2;
            Entry<A> prev = null;
            for (Entry<A> n = entry; n != null && n.hash() <= hash; n = n.next()) {
                if (n.hash() == hash && BoxesRunTime.equals(elem, n.key())) {
                    return false;
                }
                prev = n;
            }
            Entry<A> nnode = this.createNewEntry(elem, (int)var2_2);
            if (prev == null) {
                nnode.next_$eq(entry);
                this.scala$collection$mutable$LinkedHashSet$$table[var3_3] = nnode;
            } else {
                void var1_1;
                nnode.next_$eq(prev.next());
                prev.next_$eq((Entry<A>)var1_1);
            }
        }
        ++this.contentSize;
        return true;
    }

    private boolean remove0(A elem, int hash) {
        int idx = hash & this.scala$collection$mutable$LinkedHashSet$$table.length - 1;
        Entry<A> entry = this.scala$collection$mutable$LinkedHashSet$$table[idx];
        if (entry == null) {
            return false;
        }
        if (entry.hash() == hash && BoxesRunTime.equals(entry.key(), elem)) {
            this.scala$collection$mutable$LinkedHashSet$$table[idx] = entry.next();
            this.deleteEntry(entry);
            --this.contentSize;
            return true;
        }
        Entry<A> prev = entry;
        for (Entry<A> next = entry.next(); next != null && next.hash() <= hash; next = next.next()) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                this.deleteEntry(next);
                --this.contentSize;
                return true;
            }
            prev = next;
        }
        return false;
    }

    private void growTable(int newlen) {
        if (newlen < 0) {
            throw new RuntimeException(new StringBuilder(36).append("new hash table size ").append(newlen).append(" exceeds maximum").toString());
        }
        this.threshold = (int)((double)newlen * 0.75);
        if (this.size() == 0) {
            this.scala$collection$mutable$LinkedHashSet$$table = new Entry[newlen];
            return;
        }
        this.scala$collection$mutable$LinkedHashSet$$table = Arrays.copyOf(this.scala$collection$mutable$LinkedHashSet$$table, newlen);
        Entry<Object> preLow = new Entry<Object>(null, 0);
        Entry<Object> preHigh = new Entry<Object>(null, 0);
        for (int oldlen = this.scala$collection$mutable$LinkedHashSet$$table.length; oldlen < newlen; oldlen <<= 1) {
            for (int i = 0; i < oldlen; ++i) {
                Entry<A> old = this.scala$collection$mutable$LinkedHashSet$$table[i];
                if (old == null) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                Entry<Object> lastLow = preLow;
                Entry<Object> lastHigh = preHigh;
                Entry<A> n = old;
                while (n != null) {
                    Entry<A> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (old != preLow.next()) {
                    this.scala$collection$mutable$LinkedHashSet$$table[i] = preLow.next();
                }
                if (preHigh.next() == null) continue;
                this.scala$collection$mutable$LinkedHashSet$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        LinkedHashSetIterator<Object> setHashIterator = this.isEmpty() ? this.iterator() : new LinkedHashSetIterator<Object>(this){
            private int hash;
            private final /* synthetic */ LinkedHashSet $outer;

            public final int hash() {
                return this.hash;
            }

            /*
             * WARNING - void declaration
             */
            public final void hash_$eq(int x$1) {
                void var1_1;
                this.hash = var1_1;
            }

            public final int hashCode() {
                return this.hash();
            }

            /*
             * WARNING - void declaration
             */
            public final Object extract(Entry<A> nd) {
                void var1_1;
                $anon$3 v0 = this;
                v0.hash_$eq(v0.$outer.unimproveHash(var1_1.hash()));
                return this;
            }
            {
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hash = 0;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)var1_1, MurmurHash3$.MODULE$.setSeed());
    }

    @Override
    public String stringPrefix() {
        return "LinkedHashSet";
    }

    public static final class Entry<A> {
        private final A key;
        private final int hash;
        private Entry<A> earlier;
        private Entry<A> later;
        private Entry<A> next;

        public final A key() {
            return this.key;
        }

        public final int hash() {
            return this.hash;
        }

        public final Entry<A> earlier() {
            return this.earlier;
        }

        /*
         * WARNING - void declaration
         */
        public final void earlier_$eq(Entry<A> x$1) {
            void var1_1;
            this.earlier = var1_1;
        }

        public final Entry<A> later() {
            return this.later;
        }

        /*
         * WARNING - void declaration
         */
        public final void later_$eq(Entry<A> x$1) {
            void var1_1;
            this.later = var1_1;
        }

        public final Entry<A> next() {
            return this.next;
        }

        /*
         * WARNING - void declaration
         */
        public final void next_$eq(Entry<A> x$1) {
            void var1_1;
            this.next = var1_1;
        }

        public final Entry<A> findEntry(A k, int h) {
            while (h != this_.hash() || !BoxesRunTime.equals(k, this_.key())) {
                if (this_.next() == null || this_.hash() > h) {
                    return null;
                }
                Entry<A> this_ = this_.next();
            }
            return this_;
        }

        /*
         * WARNING - void declaration
         */
        public Entry(A key, int hash) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.hash = var2_2;
            this.earlier = null;
            this.later = null;
            this.next = null;
        }
    }

    private abstract class LinkedHashSetIterator<T>
    extends AbstractIterator<T> {
        private Entry<A> cur;

        public abstract T extract(Entry<A> var1);

        @Override
        public boolean hasNext() {
            return this.cur != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            if (this.hasNext()) {
                void var1_1;
                LinkedHashSetIterator linkedHashSetIterator = this;
                T r = linkedHashSetIterator.extract(linkedHashSetIterator.cur);
                this.cur = this.cur.later();
                return var1_1;
            }
            return (T)Iterator$.scala$collection$Iterator$$_empty.next();
        }

        /*
         * WARNING - void declaration
         */
        public LinkedHashSetIterator() {
            void var1_1;
            if (LinkedHashSet.this == null) {
                throw null;
            }
            this.cur = var1_1.firstEntry();
        }
    }
}

