# This module is defined in torch/csrc/distributed/python_placement.cpp

class Placement:
    def is_partial(self, reduce_op: str | None = None) -> bool: ...
    def is_replicate(self) -> bool: ...
    def is_shard(self, dim: int | None = None) -> bool: ...

class Shard(Placement):
    dim: int
    def __init__(self, dim: int): ...

class StridedShard(Placement):
    dim: int
    split_factor: int
    def __init__(self, dim: int, *, split_factor: int): ...

class Replicate(Placement): ...

class Partial(Placement):
    reduce_op: str
    def __init__(self, reduce_op: str | None = None): ...
