from typing import ClassVar, Union, overload

import numpy as np
from _typeshed import Incomplete
from typing_extensions import disjoint_base

CONST: Term
EventNames: dict
MAJOR: int
MINOR: int
Operator: Op
PATCH: int
PY_SCIP_CALL: Incomplete
StageNames: dict
TYPE_CHECKING: bool
_SCIP_BOUNDTYPE_TO_STRING: dict
_core_dot: Incomplete
_core_dot_2d: Incomplete
_core_sum: Incomplete
_expr_richcmp: Incomplete
_is_number: Incomplete
buildGenExprObj: Incomplete
cos: Incomplete
exp: Incomplete
expr_to_array: Incomplete
expr_to_nodes: Incomplete
is_memory_freed: Incomplete
log: Incomplete
print_memory_in_use: Incomplete
quickprod: Incomplete
quicksum: Incomplete
readStatistics: Incomplete
sin: Incomplete
sqrt: Incomplete
str_conversion: Incomplete
value_to_array: Incomplete

@disjoint_base
class Benders:
    model: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def benderscreatesub(self, probnumber: Incomplete) -> Incomplete: ...
    def bendersexit(self) -> Incomplete: ...
    def bendersexitpre(self) -> Incomplete: ...
    def bendersexitsol(self) -> Incomplete: ...
    def bendersfree(self) -> Incomplete: ...
    def bendersfreesub(self, probnumber: Incomplete) -> Incomplete: ...
    def bendersgetvar(
        self, variable: Incomplete, probnumber: Incomplete
    ) -> Incomplete: ...
    def bendersinit(self) -> Incomplete: ...
    def bendersinitpre(self) -> Incomplete: ...
    def bendersinitsol(self) -> Incomplete: ...
    def benderspostsolve(
        self,
        solution: Incomplete,
        enfotype: Incomplete,
        mergecandidates: Incomplete,
        npriomergecands: Incomplete,
        checkint: Incomplete,
        infeasible: Incomplete,
    ) -> Incomplete: ...
    def benderspresubsolve(
        self, solution: Incomplete, enfotype: Incomplete, checkint: Incomplete
    ) -> Incomplete: ...
    def benderssolvesub(
        self, solution: Incomplete, probnumber: Incomplete
    ) -> Incomplete: ...
    def benderssolvesubconvex(
        self, solution: Incomplete, probnumber: Incomplete, onlyconvex: Incomplete
    ) -> Incomplete: ...

@disjoint_base
class Benderscut:
    benders: Incomplete
    model: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def benderscutexec(
        self, solution: Incomplete, probnumber: Incomplete, enfotype: Incomplete
    ) -> Incomplete: ...
    def benderscutexit(self) -> Incomplete: ...
    def benderscutexitsol(self) -> Incomplete: ...
    def benderscutfree(self) -> Incomplete: ...
    def benderscutinit(self) -> Incomplete: ...
    def benderscutinitsol(self) -> Incomplete: ...

@disjoint_base
class BoundChange:
    def __init__(self) -> None: ...
    def getBoundchgtype(self) -> Incomplete: ...
    def getBoundtype(self) -> Incomplete: ...
    def getNewBound(self) -> Incomplete: ...
    def getVar(self) -> Incomplete: ...
    def isRedundant(self) -> Incomplete: ...

@disjoint_base
class Branchrule:
    model: Incomplete
    def __init__(self) -> None: ...
    def branchexecext(self, allowaddcons: Incomplete) -> Incomplete: ...
    def branchexeclp(self, allowaddcons: Incomplete) -> Incomplete: ...
    def branchexecps(self, allowaddcons: Incomplete) -> Incomplete: ...
    def branchexit(self) -> Incomplete: ...
    def branchexitsol(self) -> Incomplete: ...
    def branchfree(self) -> Incomplete: ...
    def branchinit(self) -> Incomplete: ...
    def branchinitsol(self) -> Incomplete: ...

@disjoint_base
class Column:
    data: Incomplete
    def __init__(self) -> None: ...
    def getAge(self) -> Incomplete: ...
    def getBasisStatus(self) -> Incomplete: ...
    def getLPPos(self) -> Incomplete: ...
    def getLb(self) -> Incomplete: ...
    def getObjCoeff(self) -> Incomplete: ...
    def getPrimsol(self) -> Incomplete: ...
    def getUb(self) -> Incomplete: ...
    def getVar(self) -> Incomplete: ...
    def isIntegral(self) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

@disjoint_base
class ColumnExact:
    data: Incomplete
    def __init__(self) -> None: ...

@disjoint_base
class Conshdlr:
    model: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def consactive(self, constraint: Incomplete) -> Incomplete: ...
    def conscheck(
        self,
        constraints: Incomplete,
        solution: Incomplete,
        checkintegrality: Incomplete,
        checklprows: Incomplete,
        printreason: Incomplete,
        completely: Incomplete,
    ) -> Incomplete: ...
    def conscopy(self) -> Incomplete: ...
    def consdeactive(self, constraint: Incomplete) -> Incomplete: ...
    def consdelete(self, constraint: Incomplete) -> Incomplete: ...
    def consdelvars(self, constraints: Incomplete) -> Incomplete: ...
    def consdisable(self, constraint: Incomplete) -> Incomplete: ...
    def consenable(self, constraint: Incomplete) -> Incomplete: ...
    def consenfolp(
        self,
        constraints: Incomplete,
        nusefulconss: Incomplete,
        solinfeasible: Incomplete,
    ) -> Incomplete: ...
    def consenfops(
        self,
        constraints: Incomplete,
        nusefulconss: Incomplete,
        solinfeasible: Incomplete,
        objinfeasible: Incomplete,
    ) -> Incomplete: ...
    def consenforelax(
        self,
        solution: Incomplete,
        constraints: Incomplete,
        nusefulconss: Incomplete,
        solinfeasible: Incomplete,
    ) -> Incomplete: ...
    def consexit(self, constraints: Incomplete) -> Incomplete: ...
    def consexitpre(self, constraints: Incomplete) -> Incomplete: ...
    def consexitsol(
        self, constraints: Incomplete, restart: Incomplete
    ) -> Incomplete: ...
    def consfree(self) -> Incomplete: ...
    def consgetdivebdchgs(self) -> Incomplete: ...
    def consgetnvars(self, constraint: Incomplete) -> Incomplete: ...
    def consgetpermsymgraph(self) -> Incomplete: ...
    def consgetsignedpermsymgraph(self) -> Incomplete: ...
    def consgetvars(self, constraint: Incomplete) -> Incomplete: ...
    def consinit(self, constraints: Incomplete) -> Incomplete: ...
    def consinitlp(self, constraints: Incomplete) -> Incomplete: ...
    def consinitpre(self, constraints: Incomplete) -> Incomplete: ...
    def consinitsol(self, constraints: Incomplete) -> Incomplete: ...
    def conslock(
        self,
        constraint: Incomplete,
        locktype: Incomplete,
        nlockspos: Incomplete,
        nlocksneg: Incomplete,
    ) -> Incomplete: ...
    def consparse(self) -> Incomplete: ...
    def conspresol(
        self,
        constraints: Incomplete,
        nrounds: Incomplete,
        presoltiming: Incomplete,
        nnewfixedvars: Incomplete,
        nnewaggrvars: Incomplete,
        nnewchgvartypes: Incomplete,
        nnewchgbds: Incomplete,
        nnewholes: Incomplete,
        nnewdelconss: Incomplete,
        nnewaddconss: Incomplete,
        nnewupgdconss: Incomplete,
        nnewchgcoefs: Incomplete,
        nnewchgsides: Incomplete,
        result_dict: Incomplete,
    ) -> Incomplete: ...
    def consprint(self, constraint: Incomplete) -> Incomplete: ...
    def consprop(
        self,
        constraints: Incomplete,
        nusefulconss: Incomplete,
        nmarkedconss: Incomplete,
        proptiming: Incomplete,
    ) -> Incomplete: ...
    def consresprop(self) -> Incomplete: ...
    def conssepalp(
        self, constraints: Incomplete, nusefulconss: Incomplete
    ) -> Incomplete: ...
    def conssepasol(
        self, constraints: Incomplete, nusefulconss: Incomplete, solution: Incomplete
    ) -> Incomplete: ...
    def constrans(self, sourceconstraint: Incomplete) -> Incomplete: ...

@disjoint_base
class Constant(GenExpr):
    number: Incomplete
    def __init__(self, *args: Incomplete, **kwargs: Incomplete) -> None: ...

@disjoint_base
class Constraint:
    data: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def getConshdlrName(self) -> Incomplete: ...
    def isActive(self) -> Incomplete: ...
    def isChecked(self) -> Incomplete: ...
    def isDynamic(self) -> Incomplete: ...
    def isEnforced(self) -> Incomplete: ...
    def isInitial(self) -> Incomplete: ...
    def isKnapsack(self) -> Incomplete: ...
    def isLinear(self) -> Incomplete: ...
    def isLinearType(self) -> Incomplete: ...
    def isLocal(self) -> Incomplete: ...
    def isModifiable(self) -> Incomplete: ...
    def isNonlinear(self) -> Incomplete: ...
    def isOriginal(self) -> Incomplete: ...
    def isPropagated(self) -> Incomplete: ...
    def isRemovable(self) -> Incomplete: ...
    def isSeparated(self) -> Incomplete: ...
    def isStickingAtNode(self) -> Incomplete: ...
    def ptr(self) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

@disjoint_base
class Cutsel:
    model: Incomplete
    def __init__(self) -> None: ...
    def cutselexit(self) -> Incomplete: ...
    def cutselexitsol(self) -> Incomplete: ...
    def cutselfree(self) -> Incomplete: ...
    def cutselinit(self) -> Incomplete: ...
    def cutselinitsol(self) -> Incomplete: ...
    def cutselselect(
        self,
        cuts: Incomplete,
        forcedcuts: Incomplete,
        root: Incomplete,
        maxnselectedcuts: Incomplete,
    ) -> Incomplete: ...

@disjoint_base
class DomainChanges:
    def __init__(self) -> None: ...
    def getBoundchgs(self) -> Incomplete: ...

@disjoint_base
class Event:
    data: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def _getEventNames(self) -> Incomplete: ...
    def getName(self) -> Incomplete: ...
    def getNewBound(self) -> Incomplete: ...
    def getNode(self) -> Incomplete: ...
    def getOldBound(self) -> Incomplete: ...
    def getRow(self) -> Incomplete: ...
    def getType(self) -> Incomplete: ...
    def getVar(self) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

@disjoint_base
class Eventhdlr:
    model: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def eventcopy(self) -> Incomplete: ...
    def eventdelete(self) -> Incomplete: ...
    def eventexec(self, event: Incomplete) -> Incomplete: ...
    def eventexit(self) -> Incomplete: ...
    def eventexitsol(self) -> Incomplete: ...
    def eventfree(self) -> Incomplete: ...
    def eventinit(self) -> Incomplete: ...
    def eventinitsol(self) -> Incomplete: ...

@disjoint_base
class Expr:
    terms: Incomplete
    def __init__(self, terms: Incomplete = ...) -> None: ...
    def degree(self) -> Incomplete: ...
    def normalize(self) -> Incomplete: ...
    def __abs__(self) -> Incomplete: ...
    def __add__(self, other: Incomplete) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index: Incomplete) -> Incomplete: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, other: Incomplete) -> Incomplete: ...  # noqa: PYI034
    def __iter__(self) -> Incomplete: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, other: Incomplete) -> Incomplete: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> Incomplete: ...
    def __pow__(self, other: Incomplete, modulo: Incomplete = ...) -> Incomplete: ...
    def __radd__(self, other: Incomplete) -> Incomplete: ...
    def __rmul__(self, other: Incomplete) -> Incomplete: ...
    def __rpow__(self, other: Incomplete) -> Incomplete: ...
    def __rsub__(self, other: Incomplete) -> Incomplete: ...
    def __rtruediv__(self, other: Incomplete) -> Incomplete: ...
    def __sub__(self, other: Incomplete) -> Incomplete: ...
    def __truediv__(self, other: Incomplete) -> Incomplete: ...

@disjoint_base
class ExprCons:
    _lhs: Incomplete
    _rhs: Incomplete
    expr: Incomplete
    def __init__(
        self, expr: Incomplete, lhs: Incomplete = ..., rhs: Incomplete = ...
    ) -> None: ...
    def normalize(self) -> Incomplete: ...
    def __bool__(self) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

@disjoint_base
class GenExpr:
    _op: Incomplete
    children: Incomplete
    def __init__(self) -> None: ...
    def degree(self) -> Incomplete: ...
    def getOp(self) -> Incomplete: ...
    def __abs__(self) -> GenExpr: ...
    def __add__(self, other: Incomplete) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, other: Incomplete) -> Incomplete: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> Incomplete: ...
    def __pow__(self, other: Incomplete, modulo: Incomplete = ...) -> Incomplete: ...
    def __radd__(self, other: Incomplete) -> Incomplete: ...
    def __rmul__(self, other: Incomplete) -> Incomplete: ...
    def __rpow__(self, other: Incomplete) -> Incomplete: ...
    def __rsub__(self, other: Incomplete) -> Incomplete: ...
    def __rtruediv__(self, other: Incomplete) -> Incomplete: ...
    def __sub__(self, other: Incomplete) -> Incomplete: ...
    def __truediv__(self, other: Incomplete) -> Incomplete: ...

@disjoint_base
class Heur:
    model: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def heurexec(
        self, heurtiming: Incomplete, nodeinfeasible: Incomplete
    ) -> Incomplete: ...
    def heurexit(self) -> Incomplete: ...
    def heurexitsol(self) -> Incomplete: ...
    def heurfree(self) -> Incomplete: ...
    def heurinit(self) -> Incomplete: ...
    def heurinitsol(self) -> Incomplete: ...

@disjoint_base
class IIS:
    def __init__(self) -> None: ...
    def getNNodes(self) -> Incomplete: ...
    def getSubscip(self) -> Incomplete: ...
    def getTime(self) -> Incomplete: ...
    def greedyMakeIrreducible(self) -> Incomplete: ...
    def isSubscipInfeasible(self) -> Incomplete: ...
    def isSubscipIrreducible(self) -> Incomplete: ...
    def setSubscipInfeasible(self, infeasible: Incomplete) -> Incomplete: ...
    def setSubscipIrreducible(self, irreducible: Incomplete) -> Incomplete: ...

@disjoint_base
class IISfinder:
    iis: Incomplete
    def __init__(self) -> None: ...
    def iisfinderexec(self) -> Incomplete: ...
    def iisfinderfree(self) -> Incomplete: ...

@disjoint_base
class LP:
    name: Incomplete
    def __init__(self, name: Incomplete = ..., sense: Incomplete = ...) -> None: ...
    def addCol(
        self,
        entries: Incomplete,
        obj: Incomplete = ...,
        lb: Incomplete = ...,
        ub: Incomplete = ...,
    ) -> Incomplete: ...
    def addCols(
        self,
        entrieslist: Incomplete,
        objs: Incomplete = ...,
        lbs: Incomplete = ...,
        ubs: Incomplete = ...,
    ) -> Incomplete: ...
    def addRow(
        self, entries: Incomplete, lhs: Incomplete = ..., rhs: Incomplete = ...
    ) -> Incomplete: ...
    def addRows(
        self, entrieslist: Incomplete, lhss: Incomplete = ..., rhss: Incomplete = ...
    ) -> Incomplete: ...
    def chgBound(
        self, col: Incomplete, lb: Incomplete, ub: Incomplete
    ) -> Incomplete: ...
    def chgCoef(
        self, row: Incomplete, col: Incomplete, newval: Incomplete
    ) -> Incomplete: ...
    def chgObj(self, col: Incomplete, obj: Incomplete) -> Incomplete: ...
    def chgSide(
        self, row: Incomplete, lhs: Incomplete, rhs: Incomplete
    ) -> Incomplete: ...
    def clear(self) -> Incomplete: ...
    def delCols(self, firstcol: Incomplete, lastcol: Incomplete) -> Incomplete: ...
    def delRows(self, firstrow: Incomplete, lastrow: Incomplete) -> Incomplete: ...
    def getActivity(self) -> Incomplete: ...
    def getBasisInds(self) -> Incomplete: ...
    def getBounds(
        self, firstcol: Incomplete = ..., lastcol: Incomplete = ...
    ) -> Incomplete: ...
    def getDual(self) -> Incomplete: ...
    def getDualRay(self) -> Incomplete: ...
    def getIntParam(self, param: Incomplete) -> Incomplete: ...
    def getNIterations(self) -> Incomplete: ...
    def getObjVal(self) -> Incomplete: ...
    def getPrimal(self) -> Incomplete: ...
    def getPrimalRay(self) -> Incomplete: ...
    def getRealParam(self, param: Incomplete) -> Incomplete: ...
    def getRedcost(self) -> Incomplete: ...
    def getSides(
        self, firstrow: Incomplete = ..., lastrow: Incomplete = ...
    ) -> Incomplete: ...
    def infinity(self) -> Incomplete: ...
    def isDualFeasible(self) -> Incomplete: ...
    def isInfinity(self, val: Incomplete) -> Incomplete: ...
    def isOptimal(self) -> Incomplete: ...
    def isPrimalFeasible(self) -> Incomplete: ...
    def ncols(self) -> Incomplete: ...
    def nrows(self) -> Incomplete: ...
    def readLP(self, filename: Incomplete) -> Incomplete: ...
    def setIntParam(self, param: Incomplete, value: Incomplete) -> Incomplete: ...
    def setRealParam(self, param: Incomplete, value: Incomplete) -> Incomplete: ...
    def solve(self, dual: Incomplete = ...) -> Incomplete: ...
    def writeLP(self, filename: Incomplete) -> Incomplete: ...

class MatrixConstraint(np.ndarray):
    def getConshdlrName(self) -> Incomplete: ...
    def isActive(self) -> Incomplete: ...
    def isChecked(self) -> Incomplete: ...
    def isDynamic(self) -> Incomplete: ...
    def isEnforced(self) -> Incomplete: ...
    def isInitial(self) -> Incomplete: ...
    def isLinear(self) -> Incomplete: ...
    def isLocal(self) -> Incomplete: ...
    def isModifiable(self) -> Incomplete: ...
    def isNonlinear(self) -> Incomplete: ...
    def isPropagated(self) -> Incomplete: ...
    def isRemovable(self) -> Incomplete: ...
    def isSeparated(self) -> Incomplete: ...
    def isStickingAtNode(self) -> Incomplete: ...

class MatrixExpr(np.ndarray):
    def _evaluate(self, sol: Incomplete) -> Incomplete: ...
    def __array_ufunc__(
        self,
        ufunc: Incomplete,
        method: Incomplete,
        *args: Incomplete,
        **kwargs: Incomplete,
    ) -> Incomplete: ...

class MatrixExprCons(np.ndarray):
    def __array_ufunc__(
        self,
        ufunc: Incomplete,
        method: Incomplete,
        *args: Incomplete,
        **kwargs: Incomplete,
    ) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...

class MatrixGenExpr(MatrixExpr): ...

class MatrixVariable(MatrixExpr):
    def getAvgSol(self) -> Incomplete: ...
    def getCol(self) -> Incomplete: ...
    def getIndex(self) -> Incomplete: ...
    def getLPSol(self) -> Incomplete: ...
    def getLbGlobal(self) -> Incomplete: ...
    def getLbLocal(self) -> Incomplete: ...
    def getLbOriginal(self) -> Incomplete: ...
    def getObj(self) -> Incomplete: ...
    def getUbGlobal(self) -> Incomplete: ...
    def getUbLocal(self) -> Incomplete: ...
    def getUbOriginal(self) -> Incomplete: ...
    def isInLP(self) -> Incomplete: ...
    def varMayRound(self, direction: Incomplete = ...) -> Incomplete: ...
    def vtype(self) -> Incomplete: ...

@disjoint_base
class Model:
    _freescip: Incomplete
    data: Incomplete
    def __init__(
        self,
        problemName: Incomplete = ...,
        defaultPlugins: Incomplete = ...,
        sourceModel: Incomplete = ...,
        origcopy: Incomplete = ...,
        globalcopy: Incomplete = ...,
        enablepricing: Incomplete = ...,
        createscip: Incomplete = ...,
        threadsafe: Incomplete = ...,
    ) -> None: ...
    def _createConsGenNonlinear(self, cons: Incomplete) -> Incomplete: ...
    def _createConsLinear(self, lincons: Incomplete) -> Incomplete: ...
    def _createConsNonlinear(self, cons: Incomplete) -> Incomplete: ...
    def _createConsQuadratic(self, quadcons: Incomplete) -> Incomplete: ...
    def _getStageNames(self) -> Incomplete: ...
    def activateBenders(
        self, benders: Incomplete, nsubproblems: Incomplete
    ) -> Incomplete: ...
    def addBendersSubproblem(
        self, benders: Incomplete, subproblem: Incomplete
    ) -> Incomplete: ...
    def addCoefKnapsack(
        self, cons: Incomplete, var: Incomplete, weight: Incomplete
    ) -> Incomplete: ...
    def addCoefLinear(
        self, cons: Incomplete, var: Incomplete, value: Incomplete
    ) -> Incomplete: ...
    def addCons(
        self,
        cons: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsAnd(
        self,
        vars: Incomplete,
        resvar: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsCardinality(
        self,
        consvars: Incomplete,
        cardval: Incomplete,
        indvars: Incomplete = ...,
        weights: Incomplete = ...,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsCoeff(
        self, cons: Incomplete, var: Incomplete, coeff: Incomplete
    ) -> Incomplete: ...
    def addConsDisjunction(
        self,
        conss: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        relaxcons: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsElemDisjunction(
        self, disj_cons: Incomplete, cons: Incomplete
    ) -> Incomplete: ...
    def addConsIndicator(
        self,
        cons: Incomplete,
        binvar: Incomplete = ...,
        activeone: Incomplete = ...,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsKnapsack(
        self,
        vars: Incomplete,
        weights: Incomplete,
        capacity: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        modifiable: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsLocal(
        self,
        cons: Incomplete,
        validnode: Incomplete = ...,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsNode(
        self,
        node: Incomplete,
        cons: Incomplete,
        validnode: Incomplete = ...,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsOr(
        self,
        vars: Incomplete,
        resvar: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsSOS1(
        self,
        vars: Incomplete,
        weights: Incomplete = ...,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsSOS2(
        self,
        vars: Incomplete,
        weights: Incomplete = ...,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConsXor(
        self,
        vars: Incomplete,
        rhsvar: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addConss(
        self,
        conss: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addCut(self, cut: Incomplete, forcecut: Incomplete = ...) -> Incomplete: ...
    def addExprNonlinear(
        self, cons: Incomplete, expr: Incomplete, coef: Incomplete
    ) -> Incomplete: ...
    def addMatrixCons(
        self,
        cons: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addMatrixConsIndicator(
        self,
        cons: Incomplete,
        binvar: Incomplete = ...,
        activeone: Incomplete = ...,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def addMatrixVar(
        self,
        shape: Incomplete,
        name: Incomplete = ...,
        vtype: Incomplete = ...,
        lb: Incomplete = ...,
        ub: Incomplete = ...,
        obj: Incomplete = ...,
        pricedVar: Incomplete = ...,
        pricedVarScore: Incomplete = ...,
    ) -> Incomplete: ...
    def addObjoffset(
        self, offset: Incomplete, solutions: Incomplete = ...
    ) -> Incomplete: ...
    def addPoolCut(self, row: Incomplete) -> Incomplete: ...
    def addPyCons(self, cons: Incomplete) -> Incomplete: ...
    def addRowDive(self, row: Incomplete) -> Incomplete: ...
    def addRowExact(self, rowexact: Incomplete) -> Incomplete: ...
    def addSol(self, solution: Incomplete, free: Incomplete = ...) -> Incomplete: ...
    def addVar(
        self,
        name: Incomplete = ...,
        vtype: Incomplete = ...,
        lb: Incomplete = ...,
        ub: Incomplete = ...,
        obj: Incomplete = ...,
        pricedVar: Incomplete = ...,
        pricedVarScore: Incomplete = ...,
        deletable: Incomplete = ...,
    ) -> Incomplete: ...
    def addVarLocks(
        self, var: Incomplete, nlocksdown: Incomplete, nlocksup: Incomplete
    ) -> Incomplete: ...
    def addVarLocksType(
        self,
        var: Incomplete,
        locktype: Incomplete,
        nlocksdown: Incomplete,
        nlocksup: Incomplete,
    ) -> Incomplete: ...
    def addVarSOS1(
        self, cons: Incomplete, var: Incomplete, weight: Incomplete
    ) -> Incomplete: ...
    def addVarSOS2(
        self, cons: Incomplete, var: Incomplete, weight: Incomplete
    ) -> Incomplete: ...
    def addVarToRow(
        self, row: Incomplete, var: Incomplete, value: Incomplete
    ) -> Incomplete: ...
    def adjustedVarLb(self, var: Variable, lb: float) -> float: ...
    def adjustedVarUb(self, var: Variable, ub: float) -> float: ...
    def aggregateVars(
        self,
        varx: Variable,
        vary: Variable,
        coefx: float = ...,
        coefy: float = ...,
        rhs: float = ...,
    ) -> tuple[bool, bool, bool]: ...
    def allColsInLP(self) -> Incomplete: ...
    def allowNegSlackExact(self) -> Incomplete: ...
    def appendVarSOS1(self, cons: Incomplete, var: Incomplete) -> Incomplete: ...
    def appendVarSOS2(self, cons: Incomplete, var: Incomplete) -> Incomplete: ...
    def applyCutsProbing(self) -> Incomplete: ...
    def attachEventHandlerCallback(
        self,
        callback: Incomplete,
        events: Incomplete,
        name: Incomplete = ...,
        description: Incomplete = ...,
    ) -> Incomplete: ...
    def backtrackProbing(self, probingdepth: Incomplete) -> Incomplete: ...
    def branchLPExact(self) -> Incomplete: ...
    def branchVar(self, variable: Incomplete) -> Incomplete: ...
    def branchVarVal(self, variable: Incomplete, value: Incomplete) -> Incomplete: ...
    def cacheRowExtensions(self, row: Incomplete) -> Incomplete: ...
    def calcChildEstimate(
        self, variable: Incomplete, targetvalue: Incomplete
    ) -> Incomplete: ...
    def calcNodeselPriority(
        self, variable: Incomplete, branchdir: Incomplete, targetvalue: Incomplete
    ) -> Incomplete: ...
    def catchEvent(
        self, eventtype: Incomplete, eventhdlr: Incomplete
    ) -> Incomplete: ...
    def catchRowEvent(
        self, row: Incomplete, eventtype: Incomplete, eventhdlr: Incomplete
    ) -> Incomplete: ...
    def catchVarEvent(
        self, var: Incomplete, eventtype: Incomplete, eventhdlr: Incomplete
    ) -> Incomplete: ...
    def checkBendersSubproblemOptimality(
        self, solution: Incomplete, probnumber: Incomplete, benders: Incomplete = ...
    ) -> Incomplete: ...
    def checkQuadraticNonlinear(self, cons: Incomplete) -> Incomplete: ...
    def checkSol(
        self,
        solution: Incomplete,
        printreason: Incomplete = ...,
        completely: Incomplete = ...,
        checkbounds: Incomplete = ...,
        checkintegrality: Incomplete = ...,
        checklprows: Incomplete = ...,
        original: Incomplete = ...,
    ) -> Incomplete: ...
    def chgCapacityKnapsack(
        self, cons: Incomplete, capacity: Incomplete
    ) -> Incomplete: ...
    def chgCoefLinear(
        self, cons: Incomplete, var: Incomplete, value: Incomplete
    ) -> Incomplete: ...
    def chgLhs(self, cons: Incomplete, lhs: Incomplete) -> Incomplete: ...
    def chgReoptObjective(
        self, coeffs: Incomplete, sense: Incomplete = ...
    ) -> Incomplete: ...
    def chgRhs(self, cons: Incomplete, rhs: Incomplete) -> Incomplete: ...
    def chgRowLhsDive(self, row: Incomplete, newlhs: Incomplete) -> Incomplete: ...
    def chgRowRhsDive(self, row: Incomplete, newrhs: Incomplete) -> Incomplete: ...
    def chgVarBranchPriority(
        self, var: Incomplete, priority: Incomplete
    ) -> Incomplete: ...
    def chgVarLb(self, var: Incomplete, lb: Incomplete) -> Incomplete: ...
    def chgVarLbDive(self, var: Incomplete, newbound: Incomplete) -> Incomplete: ...
    def chgVarLbGlobal(self, var: Incomplete, lb: Incomplete) -> Incomplete: ...
    def chgVarLbNode(
        self, node: Incomplete, var: Incomplete, lb: Incomplete
    ) -> Incomplete: ...
    def chgVarLbProbing(self, var: Incomplete, lb: Incomplete) -> Incomplete: ...
    def chgVarObjDive(self, var: Incomplete, newobj: Incomplete) -> Incomplete: ...
    def chgVarObjProbing(self, var: Incomplete, newobj: Incomplete) -> Incomplete: ...
    def chgVarType(self, var: Incomplete, vtype: Incomplete) -> Incomplete: ...
    def chgVarUb(self, var: Incomplete, ub: Incomplete) -> Incomplete: ...
    def chgVarUbDive(self, var: Incomplete, newbound: Incomplete) -> Incomplete: ...
    def chgVarUbGlobal(self, var: Incomplete, ub: Incomplete) -> Incomplete: ...
    def chgVarUbNode(
        self, node: Incomplete, var: Incomplete, ub: Incomplete
    ) -> Incomplete: ...
    def chgVarUbProbing(self, var: Incomplete, ub: Incomplete) -> Incomplete: ...
    def computeBestSolSubproblems(self) -> Incomplete: ...
    def constructLP(self) -> Incomplete: ...
    def copyLargeNeighborhoodSearch(
        self, to_fix: Incomplete, fix_vals: Incomplete
    ) -> Incomplete: ...
    def count(self) -> Incomplete: ...
    def createChild(
        self, nodeselprio: Incomplete, estimate: Incomplete
    ) -> Incomplete: ...
    def createCons(
        self,
        conshdlr: Incomplete,
        name: Incomplete,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def createConsFromExpr(
        self,
        cons: Incomplete,
        name: Incomplete = ...,
        initial: Incomplete = ...,
        separate: Incomplete = ...,
        enforce: Incomplete = ...,
        check: Incomplete = ...,
        propagate: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        dynamic: Incomplete = ...,
        removable: Incomplete = ...,
        stickingatnode: Incomplete = ...,
    ) -> Incomplete: ...
    def createEmptyRowSepa(
        self,
        sepa: Incomplete,
        name: Incomplete = ...,
        lhs: Incomplete = ...,
        rhs: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        removable: Incomplete = ...,
    ) -> Incomplete: ...
    def createEmptyRowUnspec(
        self,
        name: Incomplete = ...,
        lhs: Incomplete = ...,
        rhs: Incomplete = ...,
        local: Incomplete = ...,
        modifiable: Incomplete = ...,
        removable: Incomplete = ...,
    ) -> Incomplete: ...
    def createOrigSol(self, heur: Incomplete = ...) -> Incomplete: ...
    def createPartialSol(self, heur: Incomplete = ...) -> Incomplete: ...
    def createProbBasic(self, problemName: Incomplete = ...) -> Incomplete: ...
    def createSol(
        self, heur: Incomplete = ..., initlp: Incomplete = ...
    ) -> Incomplete: ...
    def cutoffNode(self, node: Incomplete) -> Incomplete: ...
    def deactivatePricer(self, pricer: Incomplete) -> Incomplete: ...
    def delCoefLinear(self, cons: Incomplete, var: Incomplete) -> Incomplete: ...
    def delCons(self, cons: Incomplete) -> Incomplete: ...
    def delConsLocal(self, cons: Incomplete) -> Incomplete: ...
    def delVar(self, var: Incomplete) -> Incomplete: ...
    def disableDebugSol(self) -> Incomplete: ...
    def disablePropagation(self, onlyroot: Incomplete = ...) -> Incomplete: ...
    def dropEvent(self, eventtype: Incomplete, eventhdlr: Incomplete) -> Incomplete: ...
    def dropRowEvent(
        self, row: Incomplete, eventtype: Incomplete, eventhdlr: Incomplete
    ) -> Incomplete: ...
    def dropVarEvent(
        self, var: Incomplete, eventtype: Incomplete, eventhdlr: Incomplete
    ) -> Incomplete: ...
    def enableDebugSol(self) -> Incomplete: ...
    def enableExactSolving(self, enable: Incomplete) -> Incomplete: ...
    def enableReoptimization(self, enable: Incomplete = ...) -> Incomplete: ...
    def endDive(self) -> Incomplete: ...
    def endProbing(self) -> Incomplete: ...
    def endStrongbranch(self) -> Incomplete: ...
    def epsilon(self) -> Incomplete: ...
    def feasCeil(self, value: Incomplete) -> Incomplete: ...
    def feasFloor(self, value: Incomplete) -> Incomplete: ...
    def feasFrac(self, value: Incomplete) -> Incomplete: ...
    def feasRound(self, value: Incomplete) -> Incomplete: ...
    def feastol(self) -> Incomplete: ...
    def fixVar(self, var: Incomplete, val: Incomplete) -> Incomplete: ...
    def fixVarProbing(self, var: Incomplete, fixedval: Incomplete) -> Incomplete: ...
    def flushRowExtensions(self, row: Incomplete) -> Incomplete: ...
    def frac(self, value: Incomplete) -> Incomplete: ...
    def freeBendersSubproblems(self) -> Incomplete: ...
    def freeProb(self) -> Incomplete: ...
    def freeReoptSolve(self) -> Incomplete: ...
    def freeSol(self, solution: Incomplete) -> Incomplete: ...
    def freeTransform(self) -> Incomplete: ...
    @staticmethod
    def from_ptr(capsule: Incomplete, take_ownership: Incomplete) -> Incomplete: ...
    def generateIIS(self) -> Incomplete: ...
    def getActivity(self, cons: Incomplete, sol: Incomplete = ...) -> Incomplete: ...
    def getBendersAuxiliaryVar(
        self, probnumber: Incomplete, benders: Incomplete = ...
    ) -> Incomplete: ...
    def getBendersSubproblem(
        self, probnumber: Incomplete, benders: Incomplete = ...
    ) -> Incomplete: ...
    def getBendersVar(
        self, var: Incomplete, benders: Incomplete = ..., probnumber: Incomplete = ...
    ) -> Incomplete: ...
    def getBestChild(self) -> Incomplete: ...
    def getBestLeaf(self) -> Incomplete: ...
    def getBestNode(self) -> Incomplete: ...
    def getBestSibling(self) -> Incomplete: ...
    def getBestSol(self) -> Incomplete: ...
    def getBestboundNode(self) -> Incomplete: ...
    def getBipartiteGraphRepresentation(
        self,
        prev_col_features: Incomplete = ...,
        prev_edge_features: Incomplete = ...,
        prev_row_features: Incomplete = ...,
        static_only: Incomplete = ...,
        suppress_warnings: Incomplete = ...,
    ) -> Incomplete: ...
    def getBranchScoreMultiple(
        self, var: Incomplete, gains: Incomplete
    ) -> Incomplete: ...
    def getCapacityKnapsack(self, cons: Incomplete) -> Incomplete: ...
    def getChildren(self) -> Incomplete: ...
    def getColRedCost(self, col: Incomplete) -> Incomplete: ...
    def getCondition(self, exact: Incomplete = ...) -> Incomplete: ...
    def getConsNVars(self, constraint: Incomplete) -> Incomplete: ...
    def getConsVals(self, constraint: Incomplete) -> Incomplete: ...
    def getConsVars(self, constraint: Incomplete) -> Incomplete: ...
    def getConss(self, transformed: Incomplete = ...) -> Incomplete: ...
    def getCurrentNode(self) -> Incomplete: ...
    def getCutEfficacy(self, cut: Incomplete, sol: Incomplete = ...) -> Incomplete: ...
    def getCutLPSolCutoffDistance(
        self, cut: Incomplete, sol: Incomplete
    ) -> Incomplete: ...
    def getCutoffbound(self) -> Incomplete: ...
    def getDepth(self) -> Incomplete: ...
    def getDualMultiplier(self, cons: Incomplete) -> Incomplete: ...
    def getDualSolVal(
        self, cons: Incomplete, boundconstraint: Incomplete = ...
    ) -> Incomplete: ...
    def getDualbound(self) -> Incomplete: ...
    def getDualboundRoot(self) -> Incomplete: ...
    def getDualfarkasKnapsack(self, cons: Incomplete) -> Incomplete: ...
    def getDualfarkasLinear(self, cons: Incomplete) -> Incomplete: ...
    def getDualsolKnapsack(self, cons: Incomplete) -> Incomplete: ...
    def getDualsolLinear(self, cons: Incomplete) -> Incomplete: ...
    def getGap(self) -> Incomplete: ...
    def getHeurTiming(self, heurname: Incomplete) -> Incomplete: ...
    def getIIS(self) -> Incomplete: ...
    def getLPBInvARow(self, row: Incomplete) -> Incomplete: ...
    def getLPBInvRow(self, row: Incomplete) -> Incomplete: ...
    def getLPBasisInd(self) -> Incomplete: ...
    def getLPBranchCands(self) -> Incomplete: ...
    def getLPColsData(self) -> Incomplete: ...
    def getLPObjVal(self) -> Incomplete: ...
    def getLPRowsData(self) -> Incomplete: ...
    def getLPSolstat(self) -> Incomplete: ...
    def getLeaves(self) -> Incomplete: ...
    def getLhs(self, cons: Incomplete) -> Incomplete: ...
    def getLinearConsIndicator(self, cons: Incomplete) -> Incomplete: ...
    def getLocalEstimate(self, original: Incomplete = ...) -> Incomplete: ...
    def getLowerbound(self) -> Incomplete: ...
    def getMajorVersion(self) -> Incomplete: ...
    def getMaxDepth(self) -> Incomplete: ...
    def getMinorVersion(self) -> Incomplete: ...
    def getNBestSolsFound(self) -> Incomplete: ...
    def getNBinVars(self) -> Incomplete: ...
    def getNChildren(self) -> Incomplete: ...
    def getNConss(self, transformed: Incomplete = ...) -> Incomplete: ...
    def getNContVars(self) -> Incomplete: ...
    def getNCountedSols(self) -> Incomplete: ...
    def getNCuts(self) -> Incomplete: ...
    def getNCutsApplied(self) -> Incomplete: ...
    def getNFeasibleLeaves(self) -> Incomplete: ...
    def getNImplVars(self) -> Incomplete: ...
    def getNInfeasibleLeaves(self) -> Incomplete: ...
    def getNIntVars(self) -> Incomplete: ...
    def getNLPBranchCands(self) -> Incomplete: ...
    def getNLPCols(self) -> Incomplete: ...
    def getNLPIterations(self) -> Incomplete: ...
    def getNLPRows(self) -> Incomplete: ...
    def getNLPs(self) -> Incomplete: ...
    def getNLeaves(self) -> Incomplete: ...
    def getNLimSolsFound(self) -> Incomplete: ...
    def getNNlRows(self) -> Incomplete: ...
    def getNNodeLPIterations(self) -> Incomplete: ...
    def getNNodes(self) -> Incomplete: ...
    def getNReaders(self) -> Incomplete: ...
    def getNSepaRounds(self) -> Incomplete: ...
    def getNSiblings(self) -> Incomplete: ...
    def getNSols(self) -> Incomplete: ...
    def getNSolsFound(self) -> Incomplete: ...
    def getNStrongbranchLPIterations(self) -> Incomplete: ...
    def getPrimalDualIntegral(self) -> Incomplete: ...
    def getNTotalNodes(self) -> Incomplete: ...
    def getNVars(self, transformed: Incomplete = ...) -> Incomplete: ...
    def getNVarsAnd(self, and_cons: Incomplete) -> Incomplete: ...
    def getNlRowActivityBounds(self, nlrow: Incomplete) -> Incomplete: ...
    def getNlRowSolActivity(
        self, nlrow: Incomplete, sol: Incomplete = ...
    ) -> Incomplete: ...
    def getNlRowSolFeasibility(
        self, nlrow: Incomplete, sol: Incomplete = ...
    ) -> Incomplete: ...
    def getNlRows(self) -> Incomplete: ...
    def getObjVal(self, original: Incomplete = ...) -> Incomplete: ...
    def getObjective(self) -> Incomplete: ...
    def getObjectiveSense(self) -> Incomplete: ...
    def getObjlimit(self) -> Incomplete: ...
    def getObjoffset(self, original: Incomplete = ...) -> Incomplete: ...
    def getOpenNodes(self) -> Incomplete: ...
    def getParam(self, name: Incomplete) -> Incomplete: ...
    def getParams(self) -> Incomplete: ...
    def getPlungeDepth(self) -> Incomplete: ...
    def getPresolvingTime(self) -> Incomplete: ...
    def getPrimalRay(self) -> Incomplete: ...
    def getPrimalRayVal(self, var: Incomplete) -> Incomplete: ...
    def getPrimalbound(self) -> Incomplete: ...
    def getPrioChild(self) -> Incomplete: ...
    def getPrioSibling(self) -> Incomplete: ...
    def getProbName(self) -> Incomplete: ...
    def getProbingDepth(self) -> Incomplete: ...
    def getPseudoBranchCands(self) -> Incomplete: ...
    def getReadingTime(self) -> Incomplete: ...
    def getResultantAnd(self, and_cons: Incomplete) -> Incomplete: ...
    def getRhs(self, cons: Incomplete) -> Incomplete: ...
    def getRowActivity(self, row: Incomplete) -> Incomplete: ...
    def getRowDualSol(self, row: Incomplete) -> Incomplete: ...
    def getRowLPActivity(self, row: Incomplete) -> Incomplete: ...
    def getRowLinear(self, cons: Incomplete) -> Incomplete: ...
    def getRowNumIntCols(self, row: Incomplete) -> Incomplete: ...
    def getRowObjParallelism(self, row: Incomplete) -> Incomplete: ...
    def getRowParallelism(
        self, row1: Incomplete, row2: Incomplete, orthofunc: Incomplete = ...
    ) -> Incomplete: ...
    def getSiblings(self) -> Incomplete: ...
    def getSlack(
        self, cons: Incomplete, sol: Incomplete = ..., side: Incomplete = ...
    ) -> Incomplete: ...
    def getSlackVarIndicator(self, cons: Incomplete) -> Incomplete: ...
    def getSolObjVal(
        self, sol: Incomplete, original: Incomplete = ...
    ) -> Incomplete: ...
    def getSolTime(self, sol: Incomplete) -> Incomplete: ...
    @overload
    def getSolVal(self, sol: Solution, expr: Union[Expr, GenExpr]) -> float: ...
    @overload
    def getSolVal(self, sol: Solution, expr: MatrixExpr) -> np.ndarray: ...
    def getSols(self) -> Incomplete: ...
    def getSolvingTime(self) -> Incomplete: ...
    def getStage(self) -> Incomplete: ...
    def getStageName(self) -> Incomplete: ...
    def getStatus(self) -> Incomplete: ...
    def getTechVersion(self) -> Incomplete: ...
    def getTermsQuadratic(self, cons: Incomplete) -> Incomplete: ...
    def getTotalTime(self) -> Incomplete: ...
    def getTransformedCons(self, cons: Incomplete) -> Incomplete: ...
    def getTransformedVar(self, var: Incomplete) -> Incomplete: ...
    def getTreesizeEstimation(self) -> Incomplete: ...
    @overload
    def getVal(self, expr: Union[Expr, GenExpr]) -> float: ...
    @overload
    def getVal(self, expr: MatrixExpr) -> np.ndarray: ...
    def getValsLinear(self, cons: Incomplete) -> Incomplete: ...
    def getVarDict(self, transformed: Incomplete = ...) -> Incomplete: ...
    def getVarLbDive(self, var: Incomplete) -> Incomplete: ...
    def getVarPseudocost(
        self, var: Incomplete, branchdir: Incomplete
    ) -> Incomplete: ...
    def getVarPseudocostScore(
        self, var: Incomplete, solVal: Incomplete
    ) -> Incomplete: ...
    def getVarRedcost(self, var: Incomplete) -> Incomplete: ...
    def getVarStrongbranch(
        self,
        var: Incomplete,
        itlim: Incomplete,
        idempotent: Incomplete = ...,
        integral: Incomplete = ...,
    ) -> Incomplete: ...
    def getVarStrongbranchLast(self, var: Incomplete) -> Incomplete: ...
    def getVarStrongbranchNode(self, var: Incomplete) -> Incomplete: ...
    def getVarUbDive(self, var: Incomplete) -> Incomplete: ...
    def getVars(self, transformed: Incomplete = ...) -> Incomplete: ...
    def getVarsAnd(self, and_cons: Incomplete) -> Incomplete: ...
    def getWeightsKnapsack(self, cons: Incomplete) -> Incomplete: ...
    def hasPrimalRay(self) -> Incomplete: ...
    def hideOutput(self, quiet: Incomplete = ...) -> Incomplete: ...
    def inProbing(self) -> Incomplete: ...
    def inRepropagation(self) -> Incomplete: ...
    def includeBenders(
        self,
        benders: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete = ...,
        cutlp: Incomplete = ...,
        cutpseudo: Incomplete = ...,
        cutrelax: Incomplete = ...,
        shareaux: Incomplete = ...,
    ) -> Incomplete: ...
    def includeBendersDefaultCuts(self, benders: Incomplete) -> Incomplete: ...
    def includeBenderscut(
        self,
        benders: Incomplete,
        benderscut: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete = ...,
        islpcut: Incomplete = ...,
    ) -> Incomplete: ...
    def includeBranchrule(
        self,
        branchrule: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete,
        maxdepth: Incomplete,
        maxbounddist: Incomplete,
    ) -> Incomplete: ...
    def includeConshdlr(
        self,
        conshdlr: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        sepapriority: Incomplete = ...,
        enfopriority: Incomplete = ...,
        chckpriority: Incomplete = ...,
        sepafreq: Incomplete = ...,
        propfreq: Incomplete = ...,
        eagerfreq: Incomplete = ...,
        maxprerounds: Incomplete = ...,
        delaysepa: Incomplete = ...,
        delayprop: Incomplete = ...,
        needscons: Incomplete = ...,
        proptiming: Incomplete = ...,
        presoltiming: Incomplete = ...,
    ) -> Incomplete: ...
    def includeCutsel(
        self,
        cutsel: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete,
    ) -> Incomplete: ...
    def includeDefaultPlugins(self) -> Incomplete: ...
    def includeEventhdlr(
        self, eventhdlr: Incomplete, name: Incomplete, desc: Incomplete
    ) -> Incomplete: ...
    def includeHeur(
        self,
        heur: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        dispchar: Incomplete,
        priority: Incomplete = ...,
        freq: Incomplete = ...,
        freqofs: Incomplete = ...,
        maxdepth: Incomplete = ...,
        timingmask: Incomplete = ...,
        usessubscip: Incomplete = ...,
    ) -> Incomplete: ...
    def includeIISfinder(
        self,
        iisfinder: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete = ...,
        freq: Incomplete = ...,
    ) -> Incomplete: ...
    def includeNodesel(
        self,
        nodesel: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        stdpriority: Incomplete,
        memsavepriority: Incomplete,
    ) -> Incomplete: ...
    def includePresol(
        self,
        presol: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete,
        maxrounds: Incomplete,
        timing: Incomplete = ...,
    ) -> Incomplete: ...
    def includePricer(
        self,
        pricer: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete = ...,
        delay: Incomplete = ...,
    ) -> Incomplete: ...
    def includeProp(
        self,
        prop: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        presolpriority: Incomplete,
        presolmaxrounds: Incomplete,
        proptiming: Incomplete,
        presoltiming: Incomplete = ...,
        priority: Incomplete = ...,
        freq: Incomplete = ...,
        delay: Incomplete = ...,
    ) -> Incomplete: ...
    def includeReader(
        self, reader: Incomplete, name: Incomplete, desc: Incomplete, ext: Incomplete
    ) -> Incomplete: ...
    def includeRelax(
        self,
        relax: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete = ...,
        freq: Incomplete = ...,
    ) -> Incomplete: ...
    def includeSepa(
        self,
        sepa: Incomplete,
        name: Incomplete,
        desc: Incomplete,
        priority: Incomplete = ...,
        freq: Incomplete = ...,
        maxbounddist: Incomplete = ...,
        usessubscip: Incomplete = ...,
        delay: Incomplete = ...,
    ) -> Incomplete: ...
    def infinity(self) -> Incomplete: ...
    def initBendersDefault(self, subproblems: Incomplete) -> Incomplete: ...
    def interruptSolve(self) -> Incomplete: ...
    def isAndConsSorted(self, and_cons: Incomplete) -> Incomplete: ...
    def isCutEfficacious(
        self, cut: Incomplete, sol: Incomplete = ...
    ) -> Incomplete: ...
    def isEQ(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isExact(self) -> Incomplete: ...
    def isFeasEQ(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isFeasGE(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isFeasGT(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isFeasIntegral(self, value: Incomplete) -> Incomplete: ...
    def isFeasLE(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isFeasLT(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isFeasNegative(self, value: Incomplete) -> Incomplete: ...
    def isFeasPositive(self, value: Incomplete) -> Incomplete: ...
    def isFeasZero(self, value: Incomplete) -> Incomplete: ...
    def isGE(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isGT(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isHugeValue(self, val: Incomplete) -> Incomplete: ...
    def isInfinity(self, value: Incomplete) -> Incomplete: ...
    def isIntegral(self, value: float) -> bool: ...
    def isLE(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isLPSolBasic(self) -> Incomplete: ...
    def isLT(self, val1: Incomplete, val2: Incomplete) -> Incomplete: ...
    def isNLPConstructed(self) -> Incomplete: ...
    def isNegative(self, val: Incomplete) -> Incomplete: ...
    def isObjChangedProbing(self) -> Incomplete: ...
    def isObjIntegral(self) -> Incomplete: ...
    def isPositive(self, val: Incomplete) -> Incomplete: ...
    def isZero(self, value: Incomplete) -> Incomplete: ...
    def lpiGetIterations(self) -> Incomplete: ...
    def markDoNotAggrVar(self, var: Incomplete) -> Incomplete: ...
    def markDoNotMultaggrVar(self, var: Incomplete) -> Incomplete: ...
    def newProbingNode(self) -> Incomplete: ...
    def optimize(self) -> Incomplete: ...
    def optimizeNogil(self) -> Incomplete: ...
    def presolve(self) -> Incomplete: ...
    def printBestSol(self, write_zeros: Incomplete = ...) -> Incomplete: ...
    def printCons(self, constraint: Incomplete) -> Incomplete: ...
    def printExternalCodeVersions(self) -> Incomplete: ...
    def printNlRow(self, nlrow: Incomplete) -> Incomplete: ...
    def printProblem(
        self,
        ext: Incomplete = ...,
        trans: Incomplete = ...,
        genericnames: Incomplete = ...,
    ) -> Incomplete: ...
    def printRow(self, row: Incomplete) -> Incomplete: ...
    def printSol(
        self, solution: Incomplete = ..., write_zeros: Incomplete = ...
    ) -> Incomplete: ...
    def printStatistics(self, filename: Incomplete = ...) -> Incomplete: ...
    def printStatisticsJson(self) -> Incomplete: ...
    def printVersion(self) -> Incomplete: ...
    def propagateProbing(self, maxproprounds: Incomplete) -> Incomplete: ...
    def readParams(self, file: Incomplete) -> Incomplete: ...
    def readProblem(
        self, filename: Incomplete, extension: Incomplete = ...
    ) -> Incomplete: ...
    def readSol(self, filename: Incomplete) -> Incomplete: ...
    def readSolFile(self, filename: Incomplete) -> Incomplete: ...
    def redirectOutput(self) -> Incomplete: ...
    def relax(self) -> Incomplete: ...
    def releaseRow(self, row: Incomplete) -> Incomplete: ...
    def repropagateNode(self, node: Incomplete) -> Incomplete: ...
    def resetParam(self, name: Incomplete) -> Incomplete: ...
    def resetParams(self) -> Incomplete: ...
    def restartSolve(self) -> Incomplete: ...
    def separateSol(
        self,
        sol: Incomplete = ...,
        pretendroot: Incomplete = ...,
        allowlocal: Incomplete = ...,
        onlydelayed: Incomplete = ...,
    ) -> Incomplete: ...
    def setBendersSubproblemIsConvex(
        self, benders: Incomplete, probnumber: Incomplete, isconvex: Incomplete = ...
    ) -> Incomplete: ...
    def setBoolParam(self, name: Incomplete, value: Incomplete) -> Incomplete: ...
    def setCharParam(self, name: Incomplete, value: Incomplete) -> Incomplete: ...
    def setCheck(self, cons: Incomplete, newCheck: Incomplete) -> Incomplete: ...
    def setEmphasis(
        self, paraemphasis: Incomplete, quiet: Incomplete = ...
    ) -> Incomplete: ...
    def setEnforced(self, cons: Incomplete, newEnf: Incomplete) -> Incomplete: ...
    def setHeurTiming(
        self, heurname: Incomplete, heurtiming: Incomplete
    ) -> Incomplete: ...
    def setHeuristics(self, setting: Incomplete) -> Incomplete: ...
    def setInitial(self, cons: Incomplete, newInit: Incomplete) -> Incomplete: ...
    def setIntParam(self, name: Incomplete, value: Incomplete) -> Incomplete: ...
    def setLogfile(self, path: Incomplete) -> Incomplete: ...
    def setLongintParam(self, name: Incomplete, value: Incomplete) -> Incomplete: ...
    def setMaximize(self) -> Incomplete: ...
    def setMinimize(self) -> Incomplete: ...
    def setModifiable(self, cons: Incomplete, newMod: Incomplete) -> Incomplete: ...
    def setObjIntegral(self) -> Incomplete: ...
    def setObjective(
        self, expr: Incomplete, sense: Incomplete = ..., clear: Incomplete = ...
    ) -> Incomplete: ...
    def setObjlimit(self, objlimit: Incomplete) -> Incomplete: ...
    def setParam(self, name: Incomplete, value: Incomplete) -> Incomplete: ...
    def setParams(self, params: Incomplete) -> Incomplete: ...
    def setParamsCountsols(self) -> Incomplete: ...
    def setPresolve(self, setting: Incomplete) -> Incomplete: ...
    def setProbName(self, name: Incomplete) -> Incomplete: ...
    def setRealParam(self, name: Incomplete, value: Incomplete) -> Incomplete: ...
    def setRelaxSolVal(self, var: Incomplete, val: Incomplete) -> Incomplete: ...
    def setRemovable(self, cons: Incomplete, newRem: Incomplete) -> Incomplete: ...
    def setSeparating(self, setting: Incomplete) -> Incomplete: ...
    def setSolVal(
        self, solution: Incomplete, var: Incomplete, val: Incomplete
    ) -> Incomplete: ...
    def setStringParam(self, name: Incomplete, value: Incomplete) -> Incomplete: ...
    def setupBendersSubproblem(
        self,
        probnumber: Incomplete,
        benders: Incomplete = ...,
        solution: Incomplete = ...,
        checktype: Incomplete = ...,
    ) -> Incomplete: ...
    def solveBendersSubproblem(
        self,
        probnumber: Incomplete,
        solvecip: Incomplete,
        benders: Incomplete = ...,
        solution: Incomplete = ...,
    ) -> Incomplete: ...
    def solveConcurrent(self) -> Incomplete: ...
    def solveDiveLP(self, itlim: Incomplete = ...) -> Incomplete: ...
    def solveProbingLP(self, itlim: Incomplete = ...) -> Incomplete: ...
    def sortAndCons(self, and_cons: Incomplete) -> Incomplete: ...
    def startDive(self) -> Incomplete: ...
    def startProbing(self) -> Incomplete: ...
    def startStrongbranch(self) -> Incomplete: ...
    def tightenVarLb(
        self, var: Incomplete, lb: Incomplete, force: Incomplete = ...
    ) -> Incomplete: ...
    def tightenVarLbGlobal(
        self, var: Incomplete, lb: Incomplete, force: Incomplete = ...
    ) -> Incomplete: ...
    def tightenVarUb(
        self, var: Incomplete, ub: Incomplete, force: Incomplete = ...
    ) -> Incomplete: ...
    def tightenVarUbGlobal(
        self, var: Incomplete, ub: Incomplete, force: Incomplete = ...
    ) -> Incomplete: ...
    def to_ptr(self, give_ownership: Incomplete) -> Incomplete: ...
    def translateSubSol(
        self, sub_model: Incomplete, sol: Incomplete, heur: Incomplete
    ) -> Incomplete: ...
    def trySol(
        self,
        solution: Incomplete,
        printreason: Incomplete = ...,
        completely: Incomplete = ...,
        checkbounds: Incomplete = ...,
        checkintegrality: Incomplete = ...,
        checklprows: Incomplete = ...,
        free: Incomplete = ...,
    ) -> Incomplete: ...
    def updateBendersLowerbounds(
        self, lowerbounds: Incomplete, benders: Incomplete = ...
    ) -> Incomplete: ...
    def updateNodeLowerbound(self, node: Incomplete, lb: Incomplete) -> Incomplete: ...
    def updateVarPseudocost(
        self,
        var: Incomplete,
        valdelta: Incomplete,
        objdelta: Incomplete,
        weight: Incomplete,
    ) -> Incomplete: ...
    def version(self) -> Incomplete: ...
    def writeBestSol(
        self, filename: Incomplete = ..., write_zeros: Incomplete = ...
    ) -> Incomplete: ...
    def writeBestTransSol(
        self, filename: Incomplete = ..., write_zeros: Incomplete = ...
    ) -> Incomplete: ...
    def writeLP(self, filename: Incomplete = ...) -> Incomplete: ...
    def writeMIP(
        self,
        filename: Incomplete,
        genericnames: Incomplete = ...,
        origobj: Incomplete = ...,
        lazyconss: Incomplete = ...,
    ) -> Incomplete: ...
    def writeName(self, var: Incomplete) -> Incomplete: ...
    def writeParams(
        self,
        filename: Incomplete = ...,
        comments: Incomplete = ...,
        onlychanged: Incomplete = ...,
        verbose: Incomplete = ...,
    ) -> Incomplete: ...
    def writeProblem(
        self,
        filename: Incomplete = ...,
        trans: Incomplete = ...,
        genericnames: Incomplete = ...,
        verbose: Incomplete = ...,
    ) -> Incomplete: ...
    def writeSol(
        self,
        solution: Incomplete,
        filename: Incomplete = ...,
        write_zeros: Incomplete = ...,
    ) -> Incomplete: ...
    def writeStatistics(self, filename: Incomplete = ...) -> Incomplete: ...
    def writeStatisticsJson(self, filename: Incomplete = ...) -> Incomplete: ...
    def writeTransSol(
        self,
        solution: Incomplete,
        filename: Incomplete = ...,
        write_zeros: Incomplete = ...,
    ) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

@disjoint_base
class NLRow:
    data: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def getConstant(self) -> Incomplete: ...
    def getDualsol(self) -> Incomplete: ...
    def getLhs(self) -> Incomplete: ...
    def getLinearTerms(self) -> Incomplete: ...
    def getRhs(self) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

@disjoint_base
class Node:
    data: Incomplete
    def __init__(self) -> None: ...
    def getAddedConss(self) -> Incomplete: ...
    def getDepth(self) -> Incomplete: ...
    def getDomchg(self) -> Incomplete: ...
    def getEstimate(self) -> Incomplete: ...
    def getLowerbound(self) -> Incomplete: ...
    def getNAddedConss(self) -> Incomplete: ...
    def getNDomchg(self) -> Incomplete: ...
    def getNParentBranchings(self) -> Incomplete: ...
    def getNumber(self) -> Incomplete: ...
    def getParent(self) -> Incomplete: ...
    def getParentBranchings(self) -> Incomplete: ...
    def getType(self) -> Incomplete: ...
    def isActive(self) -> Incomplete: ...
    def isPropagatedAgain(self) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

@disjoint_base
class Nodesel:
    model: Incomplete
    def __init__(self) -> None: ...
    def nodecomp(self, node1: Incomplete, node2: Incomplete) -> Incomplete: ...
    def nodeexit(self) -> Incomplete: ...
    def nodeexitsol(self) -> Incomplete: ...
    def nodefree(self) -> Incomplete: ...
    def nodeinit(self) -> Incomplete: ...
    def nodeinitsol(self) -> Incomplete: ...
    def nodeselect(self) -> Incomplete: ...

class Op:
    add: ClassVar[str] = ...
    const: ClassVar[str] = ...
    cos: ClassVar[str] = ...
    div: ClassVar[str] = ...
    exp: ClassVar[str] = ...
    fabs: ClassVar[str] = ...
    log: ClassVar[str] = ...
    minus: ClassVar[str] = ...
    mul: ClassVar[str] = ...
    plus: ClassVar[str] = ...
    power: ClassVar[str] = ...
    prod: ClassVar[str] = ...
    sin: ClassVar[str] = ...
    sqrt: ClassVar[str] = ...
    varidx: ClassVar[str] = ...

class PY_SCIP_BENDERSENFOTYPE:
    CHECK: ClassVar[int] = ...
    LP: ClassVar[int] = ...
    PSEUDO: ClassVar[int] = ...
    RELAX: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_BRANCHDIR:
    AUTO: ClassVar[int] = ...
    DOWNWARDS: ClassVar[int] = ...
    FIXED: ClassVar[int] = ...
    UPWARDS: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_EVENTTYPE:
    BESTSOLFOUND: ClassVar[int] = ...
    BOUNDCHANGED: ClassVar[int] = ...
    BOUNDRELAXED: ClassVar[int] = ...
    BOUNDTIGHTENED: ClassVar[int] = ...
    DISABLED: ClassVar[int] = ...
    DOMCHANGED: ClassVar[int] = ...
    DUALBOUNDIMPROVED: ClassVar[int] = ...
    FIRSTLPSOLVED: ClassVar[int] = ...
    GAPUPDATED: ClassVar[int] = ...
    GBDCHANGED: ClassVar[int] = ...
    GHOLEADDED: ClassVar[int] = ...
    GHOLECHANGED: ClassVar[int] = ...
    GHOLEREMOVED: ClassVar[int] = ...
    GLBCHANGED: ClassVar[int] = ...
    GUBCHANGED: ClassVar[int] = ...
    HOLECHANGED: ClassVar[int] = ...
    IMPLADDED: ClassVar[int] = ...
    LBCHANGED: ClassVar[int] = ...
    LBRELAXED: ClassVar[int] = ...
    LBTIGHTENED: ClassVar[int] = ...
    LHOLEADDED: ClassVar[int] = ...
    LHOLECHANGED: ClassVar[int] = ...
    LHOLEREMOVED: ClassVar[int] = ...
    LPEVENT: ClassVar[int] = ...
    LPSOLVED: ClassVar[int] = ...
    NODEBRANCHED: ClassVar[int] = ...
    NODEDELETE: ClassVar[int] = ...
    NODEEVENT: ClassVar[int] = ...
    NODEFEASIBLE: ClassVar[int] = ...
    NODEFOCUSED: ClassVar[int] = ...
    NODEINFEASIBLE: ClassVar[int] = ...
    NODESOLVED: ClassVar[int] = ...
    OBJCHANGED: ClassVar[int] = ...
    POORSOLFOUND: ClassVar[int] = ...
    PRESOLVEROUND: ClassVar[int] = ...
    ROWADDEDLP: ClassVar[int] = ...
    ROWADDEDSEPA: ClassVar[int] = ...
    ROWCHANGED: ClassVar[int] = ...
    ROWCOEFCHANGED: ClassVar[int] = ...
    ROWCONSTCHANGED: ClassVar[int] = ...
    ROWDELETEDLP: ClassVar[int] = ...
    ROWDELETEDSEPA: ClassVar[int] = ...
    ROWEVENT: ClassVar[int] = ...
    ROWSIDECHANGED: ClassVar[int] = ...
    SOLEVENT: ClassVar[int] = ...
    SOLFOUND: ClassVar[int] = ...
    SYNC: ClassVar[int] = ...
    UBCHANGED: ClassVar[int] = ...
    UBRELAXED: ClassVar[int] = ...
    UBTIGHTENED: ClassVar[int] = ...
    VARADDED: ClassVar[int] = ...
    VARCHANGED: ClassVar[int] = ...
    VARDELETED: ClassVar[int] = ...
    VAREVENT: ClassVar[int] = ...
    VARFIXED: ClassVar[int] = ...
    VARUNLOCKED: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_HEURTIMING:
    AFTERLPLOOP: ClassVar[int] = ...
    AFTERLPNODE: ClassVar[int] = ...
    AFTERLPPLUNGE: ClassVar[int] = ...
    AFTERPROPLOOP: ClassVar[int] = ...
    AFTERPSEUDONODE: ClassVar[int] = ...
    AFTERPSEUDOPLUNGE: ClassVar[int] = ...
    BEFORENODE: ClassVar[int] = ...
    BEFOREPRESOL: ClassVar[int] = ...
    DURINGLPLOOP: ClassVar[int] = ...
    DURINGPRESOLLOOP: ClassVar[int] = ...
    DURINGPRICINGLOOP: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_IMPLINTTYPE:
    NONE: ClassVar[int] = ...
    STRONG: ClassVar[int] = ...
    WEAK: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_LOCKTYPE:
    CONFLICT: ClassVar[int] = ...
    MODEL: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_LPPARAM:
    BARRIERCONVTOL: ClassVar[int] = ...
    CONDITIONLIMIT: ClassVar[int] = ...
    DUALFEASTOL: ClassVar[int] = ...
    FASTMIP: ClassVar[int] = ...
    FEASTOL: ClassVar[int] = ...
    FROMSCRATCH: ClassVar[int] = ...
    LPINFO: ClassVar[int] = ...
    LPITLIM: ClassVar[int] = ...
    LPTILIM: ClassVar[int] = ...
    MARKOWITZ: ClassVar[int] = ...
    OBJLIM: ClassVar[int] = ...
    POLISHING: ClassVar[int] = ...
    PRESOLVING: ClassVar[int] = ...
    PRICING: ClassVar[int] = ...
    RANDOMSEED: ClassVar[int] = ...
    REFACTOR: ClassVar[int] = ...
    ROWREPSWITCH: ClassVar[int] = ...
    SCALING: ClassVar[int] = ...
    THREADS: ClassVar[int] = ...
    TIMING: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_LPSOLSTAT:
    ERROR: ClassVar[int] = ...
    INFEASIBLE: ClassVar[int] = ...
    ITERLIMIT: ClassVar[int] = ...
    NOTSOLVED: ClassVar[int] = ...
    OBJLIMIT: ClassVar[int] = ...
    OPTIMAL: ClassVar[int] = ...
    TIMELIMIT: ClassVar[int] = ...
    UNBOUNDEDRAY: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_NODETYPE:
    CHILD: ClassVar[int] = ...
    DEADEND: ClassVar[int] = ...
    FOCUSNODE: ClassVar[int] = ...
    FORK: ClassVar[int] = ...
    JUNCTION: ClassVar[int] = ...
    LEAF: ClassVar[int] = ...
    PROBINGNODE: ClassVar[int] = ...
    PSEUDOFORK: ClassVar[int] = ...
    REFOCUSNODE: ClassVar[int] = ...
    SIBLING: ClassVar[int] = ...
    SUBROOT: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_PARAMEMPHASIS:
    BENCHMARK: ClassVar[int] = ...
    COUNTER: ClassVar[int] = ...
    CPSOLVER: ClassVar[int] = ...
    DEFAULT: ClassVar[int] = ...
    EASYCIP: ClassVar[int] = ...
    FEASIBILITY: ClassVar[int] = ...
    HARDLP: ClassVar[int] = ...
    NUMERICS: ClassVar[int] = ...
    OPTIMALITY: ClassVar[int] = ...
    PHASEFEAS: ClassVar[int] = ...
    PHASEIMPROVE: ClassVar[int] = ...
    PHASEPROOF: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_PARAMSETTING:
    AGGRESSIVE: ClassVar[int] = ...
    DEFAULT: ClassVar[int] = ...
    FAST: ClassVar[int] = ...
    OFF: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_PRESOLTIMING:
    EXHAUSTIVE: ClassVar[int] = ...
    FAST: ClassVar[int] = ...
    MEDIUM: ClassVar[int] = ...
    NONE: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_PROPTIMING:
    AFTERLPLOOP: ClassVar[int] = ...
    AFTERLPNODE: ClassVar[int] = ...
    BEFORELP: ClassVar[int] = ...
    DURINGLPLOOP: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_RESULT:
    BRANCHED: ClassVar[int] = ...
    CONSADDED: ClassVar[int] = ...
    CONSCHANGED: ClassVar[int] = ...
    CUTOFF: ClassVar[int] = ...
    DELAYED: ClassVar[int] = ...
    DIDNOTFIND: ClassVar[int] = ...
    DIDNOTRUN: ClassVar[int] = ...
    FEASIBLE: ClassVar[int] = ...
    FOUNDSOL: ClassVar[int] = ...
    INFEASIBLE: ClassVar[int] = ...
    NEWROUND: ClassVar[int] = ...
    REDUCEDDOM: ClassVar[int] = ...
    SEPARATED: ClassVar[int] = ...
    SOLVELP: ClassVar[int] = ...
    SUCCESS: ClassVar[int] = ...
    SUSPENDED: ClassVar[int] = ...
    UNBOUNDED: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_ROWORIGINTYPE:
    CONS: ClassVar[int] = ...
    REOPT: ClassVar[int] = ...
    SEPA: ClassVar[int] = ...
    UNSPEC: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_SOLORIGIN:
    LPSOL: ClassVar[int] = ...
    NLPSOL: ClassVar[int] = ...
    ORIGINAL: ClassVar[int] = ...
    PARTIAL: ClassVar[int] = ...
    PSEUDOSOL: ClassVar[int] = ...
    RELAXSOL: ClassVar[int] = ...
    UNKNOWN: ClassVar[int] = ...
    ZERO: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_STAGE:
    EXITPRESOLVE: ClassVar[int] = ...
    EXITSOLVE: ClassVar[int] = ...
    FREE: ClassVar[int] = ...
    FREETRANS: ClassVar[int] = ...
    INIT: ClassVar[int] = ...
    INITPRESOLVE: ClassVar[int] = ...
    INITSOLVE: ClassVar[int] = ...
    PRESOLVED: ClassVar[int] = ...
    PRESOLVING: ClassVar[int] = ...
    PROBLEM: ClassVar[int] = ...
    SOLVED: ClassVar[int] = ...
    SOLVING: ClassVar[int] = ...
    TRANSFORMED: ClassVar[int] = ...
    TRANSFORMING: ClassVar[int] = ...
    def __init__(self) -> None: ...

class PY_SCIP_STATUS:
    BESTSOLLIMIT: ClassVar[int] = ...
    DUALLIMIT: ClassVar[int] = ...
    GAPLIMIT: ClassVar[int] = ...
    INFEASIBLE: ClassVar[int] = ...
    INFORUNBD: ClassVar[int] = ...
    MEMLIMIT: ClassVar[int] = ...
    NODELIMIT: ClassVar[int] = ...
    OPTIMAL: ClassVar[int] = ...
    PRIMALLIMIT: ClassVar[int] = ...
    RESTARTLIMIT: ClassVar[int] = ...
    SOLLIMIT: ClassVar[int] = ...
    STALLNODELIMIT: ClassVar[int] = ...
    TIMELIMIT: ClassVar[int] = ...
    TOTALNODELIMIT: ClassVar[int] = ...
    UNBOUNDED: ClassVar[int] = ...
    UNKNOWN: ClassVar[int] = ...
    USERINTERRUPT: ClassVar[int] = ...
    def __init__(self) -> None: ...

@disjoint_base
class PowExpr(GenExpr):
    expo: Incomplete
    def __init__(self, *args: Incomplete, **kwargs: Incomplete) -> None: ...

@disjoint_base
class Presol:
    model: Incomplete
    def __init__(self) -> None: ...
    def presolexec(
        self, nrounds: Incomplete, presoltiming: Incomplete
    ) -> Incomplete: ...
    def presolexit(self) -> Incomplete: ...
    def presolexitpre(self) -> Incomplete: ...
    def presolfree(self) -> Incomplete: ...
    def presolinit(self) -> Incomplete: ...
    def presolinitpre(self) -> Incomplete: ...

@disjoint_base
class Pricer:
    model: Incomplete
    def __init__(self) -> None: ...
    def pricerexit(self) -> Incomplete: ...
    def pricerexitsol(self) -> Incomplete: ...
    def pricerfarkas(self) -> Incomplete: ...
    def pricerfree(self) -> Incomplete: ...
    def pricerinit(self) -> Incomplete: ...
    def pricerinitsol(self) -> Incomplete: ...
    def pricerredcost(self) -> Incomplete: ...

@disjoint_base
class ProdExpr(GenExpr):
    constant: Incomplete
    def __init__(self, *args: Incomplete, **kwargs: Incomplete) -> None: ...

@disjoint_base
class Prop:
    model: Incomplete
    def __init__(self) -> None: ...
    def propexec(self, proptiming: Incomplete) -> Incomplete: ...
    def propexit(self) -> Incomplete: ...
    def propexitpre(self) -> Incomplete: ...
    def propexitsol(self, restart: Incomplete) -> Incomplete: ...
    def propfree(self) -> Incomplete: ...
    def propinit(self) -> Incomplete: ...
    def propinitpre(self) -> Incomplete: ...
    def propinitsol(self) -> Incomplete: ...
    def proppresol(
        self, nrounds: Incomplete, presoltiming: Incomplete, result_dict: Incomplete
    ) -> Incomplete: ...
    def propresprop(
        self,
        confvar: Incomplete,
        inferinfo: Incomplete,
        bdtype: Incomplete,
        relaxedbd: Incomplete,
    ) -> Incomplete: ...

@disjoint_base
class Reader:
    model: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def readerfree(self) -> Incomplete: ...
    def readerread(self, filename: Incomplete) -> Incomplete: ...
    def readerwrite(
        self,
        file: Incomplete,
        name: Incomplete,
        transformed: Incomplete,
        objsense: Incomplete,
        objoffset: Incomplete,
        objscale: Incomplete,
        binvars: Incomplete,
        intvars: Incomplete,
        implvars: Incomplete,
        contvars: Incomplete,
        fixedvars: Incomplete,
        startnvars: Incomplete,
        conss: Incomplete,
        maxnconss: Incomplete,
        startnconss: Incomplete,
        genericnames: Incomplete,
    ) -> Incomplete: ...

@disjoint_base
class Relax:
    model: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def relaxexec(self) -> Incomplete: ...
    def relaxexit(self) -> Incomplete: ...
    def relaxexitsol(self) -> Incomplete: ...
    def relaxfree(self) -> Incomplete: ...
    def relaxinit(self) -> Incomplete: ...
    def relaxinitsol(self) -> Incomplete: ...

@disjoint_base
class Row:
    data: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def getAge(self) -> Incomplete: ...
    def getBasisStatus(self) -> Incomplete: ...
    def getCols(self) -> Incomplete: ...
    def getConsOriginConshdlrtype(self) -> Incomplete: ...
    def getConstant(self) -> Incomplete: ...
    def getDualfarkas(self) -> Incomplete: ...
    def getDualsol(self) -> Incomplete: ...
    def getLPPos(self) -> Incomplete: ...
    def getLhs(self) -> Incomplete: ...
    def getNLPNonz(self) -> Incomplete: ...
    def getNNonz(self) -> Incomplete: ...
    def getNorm(self) -> Incomplete: ...
    def getOrigintype(self) -> Incomplete: ...
    def getRhs(self) -> Incomplete: ...
    def getVals(self) -> Incomplete: ...
    def isInGlobalCutpool(self) -> Incomplete: ...
    def isIntegral(self) -> Incomplete: ...
    def isLocal(self) -> Incomplete: ...
    def isModifiable(self) -> Incomplete: ...
    def isRemovable(self) -> Incomplete: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

@disjoint_base
class RowExact:
    data: Incomplete
    def __init__(self) -> None: ...

@disjoint_base
class Sepa:
    model: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def sepaexeclp(self) -> Incomplete: ...
    def sepaexecsol(self, solution: Incomplete) -> Incomplete: ...
    def sepaexit(self) -> Incomplete: ...
    def sepaexitsol(self) -> Incomplete: ...
    def sepafree(self) -> Incomplete: ...
    def sepainit(self) -> Incomplete: ...
    def sepainitsol(self) -> Incomplete: ...

@disjoint_base
class Solution:
    data: Incomplete
    def __init__(self, raise_error: Incomplete = ...) -> None: ...
    def _checkStage(self, method: Incomplete) -> Incomplete: ...
    def getOrigin(self) -> Incomplete: ...
    def retransform(self) -> Incomplete: ...
    def translate(self, target: Incomplete) -> Incomplete: ...
    def __getitem__(self, index: Incomplete) -> Incomplete: ...
    def __setitem__(self, key: Incomplete, value: Incomplete) -> None: ...

class Statistics:
    status: str
    total_time: float
    solving_time: float
    presolving_time: float
    reading_time: float
    copying_time: float
    problem_name: str
    presolved_problem_name: str
    n_runs: int | None
    n_nodes: int | None
    n_solutions_found: int
    first_solution: float | None
    primal_bound: float | None
    dual_bound: float | None
    gap: float | None
    primal_dual_integral: float | None
    def __init__(
        self,
        status: str,
        total_time: float,
        solving_time: float,
        presolving_time: float,
        reading_time: float,
        copying_time: float,
        problem_name: str,
        presolved_problem_name: str,
        n_runs: int | None,
        n_nodes: int | None,
        n_solutions_found: int,
        first_solution: float | None,
        primal_bound: float | None,
        dual_bound: float | None,
        gap: float | None,
        primal_dual_integral: float | None,
    ) -> None: ...
    @property
    def n_binary_vars(self) -> int: ...
    @property
    def n_conss(self) -> int: ...
    @property
    def n_continuous_vars(self) -> int: ...
    @property
    def n_implicit_integer_vars(self) -> int: ...
    @property
    def n_integer_vars(self) -> int: ...
    @property
    def n_maximal_cons(self) -> int: ...
    @property
    def n_presolved_binary_vars(self) -> int: ...
    @property
    def n_presolved_conss(self) -> int: ...
    @property
    def n_presolved_continuous_vars(self) -> int: ...
    @property
    def n_presolved_implicit_integer_vars(self) -> int: ...
    @property
    def n_presolved_integer_vars(self) -> int: ...
    @property
    def n_presolved_maximal_cons(self) -> int: ...
    @property
    def n_presolved_vars(self) -> int: ...
    @property
    def n_vars(self) -> int: ...
    def __replace__(self, **changes: Incomplete) -> Statistics: ...

@disjoint_base
class SumExpr(GenExpr):
    coefs: Incomplete
    constant: Incomplete
    def __init__(self, *args: Incomplete, **kwargs: Incomplete) -> None: ...

@disjoint_base
class Term:
    ptrtuple: Incomplete
    vartuple: Incomplete
    def __init__(self, *vartuple: Incomplete) -> None: ...
    def __mul__(self, other: Term) -> Term: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index: Incomplete) -> Incomplete: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class UnaryExpr(GenExpr):
    def __init__(self, *args: Incomplete, **kwargs: Incomplete) -> None: ...
    def __abs__(self) -> GenExpr: ...

@disjoint_base
class VarExpr(GenExpr):
    var: Incomplete
    def __init__(self, *args: Incomplete, **kwargs: Incomplete) -> None: ...

@disjoint_base
class Variable(Expr):
    data: Incomplete
    name: Incomplete
    def __init__(self) -> None: ...
    def getAvgSol(self) -> Incomplete: ...
    def getCol(self) -> Incomplete: ...
    def getImplType(self) -> Incomplete: ...
    def getIndex(self) -> Incomplete: ...
    def getLPSol(self) -> Incomplete: ...
    def getLbGlobal(self) -> Incomplete: ...
    def getLbLocal(self) -> Incomplete: ...
    def getLbOriginal(self) -> Incomplete: ...
    def getNBranchings(self, branchdir: Incomplete) -> Incomplete: ...
    def getNBranchingsCurrentRun(self, branchdir: Incomplete) -> Incomplete: ...
    def getNLocksDown(self) -> Incomplete: ...
    def getNLocksDownType(self, locktype: Incomplete) -> Incomplete: ...
    def getNLocksUp(self) -> Incomplete: ...
    def getNLocksUpType(self, locktype: Incomplete) -> Incomplete: ...
    def getObj(self) -> Incomplete: ...
    def getStatus(self) -> Incomplete: ...
    def getUbGlobal(self) -> Incomplete: ...
    def getUbLocal(self) -> Incomplete: ...
    def getUbOriginal(self) -> Incomplete: ...
    def isActive(self) -> Incomplete: ...
    def isBinary(self) -> Incomplete: ...
    def isDeletable(self) -> Incomplete: ...
    def isImpliedIntegral(self) -> Incomplete: ...
    def isInLP(self) -> Incomplete: ...
    def isIntegral(self) -> Incomplete: ...
    def isNonImpliedIntegral(self) -> Incomplete: ...
    def isOriginal(self) -> Incomplete: ...
    def isRelaxationOnly(self) -> Incomplete: ...
    def markRelaxationOnly(self) -> Incomplete: ...
    def ptr(self) -> Incomplete: ...
    def varMayRound(self, direction: Incomplete = ...) -> Incomplete: ...
    def vtype(self) -> Incomplete: ...

@disjoint_base
class _VarArray:
    def __init__(self) -> None: ...
