/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.Icon;
import org.protege.editor.owl.ui.renderer.OWLSystemColors;

public abstract class OWLEntityIcon
implements Icon {
    private static final int BASE_SIZE = 16;
    private final FillType fillType;
    private Color overrideColor = null;
    private boolean enabled = true;

    protected OWLEntityIcon(FillType fillType) {
        this.fillType = fillType;
    }

    public abstract Color getEntityColor();

    public Color getColor() {
        if (!this.enabled) {
            return Color.LIGHT_GRAY;
        }
        if (this.overrideColor == null) {
            return this.getEntityColor();
        }
        return this.overrideColor;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public OWLEntityIcon setOverrideColor(Color overrideColor) {
        this.overrideColor = overrideColor;
        return this;
    }

    public OWLEntityIcon setOverriderColorToForegroundColor() {
        return this.setOverrideColor(OWLSystemColors.getForegroundColor());
    }

    public Color getBorderColor() {
        return this.getColor();
    }

    public FillType getFillType() {
        return this.fillType;
    }

    public int getBaseSize() {
        return 16;
    }

    protected int getBaseline(Component c, int defaultBaseline) {
        if (c == null) {
            return defaultBaseline;
        }
        Font f = c.getFont();
        if (f == null) {
            return defaultBaseline;
        }
        FontMetrics fm = c.getFontMetrics(f);
        return fm.getAscent() + fm.getLeading();
    }

    @Override
    public int getIconWidth() {
        return this.getBaseSize();
    }

    @Override
    public int getIconHeight() {
        return this.getBaseSize();
    }

    public static enum FillType {
        FILLED,
        HOLLOW;

    }
}

