/*
 * Decompiled with CFR 0.152.
 */
package ECDH;

import StandardLibraryInternal.InternalResult;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECParameterSpec;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.ECDHCurveSpec;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;

public enum ECCAlgorithm {
    P256("secp256r1"),
    P384("secp384r1"),
    P521("secp521r1"),
    SM2("SM2");

    public final String curve;

    private ECCAlgorithm(String curve) {
        this.curve = curve;
    }

    static InternalResult<ECCAlgorithm, Error> eccAlgorithm(ECDHCurveSpec dtor_eccAlgorithm) {
        ECCAlgorithm namedCurveAlgorithm;
        if (dtor_eccAlgorithm.is_ECC__NIST__P256()) {
            namedCurveAlgorithm = P256;
        } else if (dtor_eccAlgorithm.is_ECC__NIST__P384()) {
            namedCurveAlgorithm = P384;
        } else if (dtor_eccAlgorithm.is_ECC__NIST__P521()) {
            namedCurveAlgorithm = P521;
        } else if (dtor_eccAlgorithm.is_SM2()) {
            namedCurveAlgorithm = SM2;
        } else {
            return InternalResult.failure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Requested Curve is not supported. Requested %s.", dtor_eccAlgorithm)).build()));
        }
        return InternalResult.success(namedCurveAlgorithm);
    }

    static ECParameterSpec ecParameterSpec(ECCAlgorithm algorithm) {
        return ECNamedCurveTable.getParameterSpec((String)algorithm.curve);
    }
}

