/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class BinaryOrder {
    TreeSet<Integer> mAllNumbers = new TreeSet();
    Vector<Integer> mOrder = new Vector();

    public synchronized void init(int pStart, int pEnd) {
        this.mOrder.clear();
        this.mAllNumbers.clear();
        if (pEnd <= pStart) {
            return;
        }
        this.addNumbersOfDepth(pStart, pEnd, 1);
    }

    public synchronized boolean hasNext() {
        return !this.mOrder.isEmpty();
    }

    public synchronized int getNext() {
        if (!this.hasNext()) {
            throw new IllegalArgumentException("getNext on empty list called!");
        }
        Integer ret = this.mOrder.firstElement();
        this.mOrder.remove(0);
        return ret;
    }

    private void addNumbersOfDepth(int pStart, int pEnd, int pDepth) {
        for (float i = (float)pStart; i <= (float)pEnd; i += (0.0f + (float)pEnd - (float)pStart) / (float)pDepth) {
            this.addNumber((int)i);
        }
        if (this.mAllNumbers.size() <= pEnd - pStart) {
            this.addNumbersOfDepth(pStart, pEnd, pDepth * 2);
        }
    }

    private boolean addNumber(int pNumber) {
        if (this.mAllNumbers.add(pNumber)) {
            this.mOrder.add(pNumber);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        BinaryOrder order = new BinaryOrder();
        order.init(1, 17);
        while (order.hasNext()) {
            int number = order.getNext();
            for (int j = 1; j < number; ++j) {
                System.out.print(" ");
            }
            System.out.println("x " + number);
        }
    }

    public synchronized void alreadyDone(int pZoom) {
        Iterator<Integer> it = this.mOrder.iterator();
        while (it.hasNext()) {
            Integer zoom = it.next();
            if (zoom != pZoom) continue;
            it.remove();
            return;
        }
    }
}

