/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.base;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.TreeMap;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.ColorUtils;
import net.sourceforge.offroad.ui.Drawable;
import net.sourceforge.offroad.ui.PorterDuffMultiplyFilter;

public class FavoriteImageDrawable
extends Drawable {
    private int color;
    private BufferedImage favIcon;
    private BufferedImage favBackground;
    private boolean withShadow;
    private BufferedImage listDrawable;
    private Rectangle listDrawable_Bounds = new Rectangle();
    private OsmWindow mContext;
    private PorterDuffMultiplyFilter paintIcon_Composite;
    private PorterDuffMultiplyFilter paintBackground_Composite;
    private static TreeMap<Integer, FavoriteImageDrawable> cache = new TreeMap();

    public FavoriteImageDrawable(OsmWindow ctx, int color2, boolean withShadow) {
        this.mContext = ctx;
        this.withShadow = withShadow;
        this.color = color2;
        int col = color2 == 0 ? 1437252556 : color2;
        this.paintBackground_Composite = new PorterDuffMultiplyFilter(new Color(col, true));
        this.favIcon = ctx.readImage("map_favorite");
        this.favBackground = ctx.readImage("map_white_favorite_shield");
        this.listDrawable = ctx.readImage("ic_action_fav_dark");
    }

    @Override
    protected void onBoundsChange(Rectangle bounds) {
        super.onBoundsChange(bounds);
        if (!this.withShadow) {
            Rectangle bs = new Rectangle(bounds);
            bs.grow(bs.width / 4, bs.height / 4);
            this.listDrawable_Bounds = bs;
        }
    }

    @Override
    public int getIntrinsicHeight() {
        return this.favBackground.getHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.favBackground.getWidth();
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public void draw(Graphics2D canvas) {
        Rectangle bs = this.getBounds();
        Graphics2D graphics = this.mContext.getDrawPanel().createGraphics(canvas);
        if (this.withShadow) {
            graphics.setComposite(this.paintBackground_Composite);
            graphics.drawImage((Image)this.favBackground, (int)(bs.getCenterX() - (double)((float)this.favBackground.getWidth() / 2.0f)), (int)(bs.getCenterY() - (double)((float)this.favBackground.getHeight() / 2.0f)), null);
            if (this.paintIcon_Composite != null) {
                graphics.setComposite(this.paintIcon_Composite);
            } else {
                graphics.dispose();
                graphics = this.mContext.getDrawPanel().createGraphics(canvas);
            }
            graphics.drawImage((Image)this.favIcon, (int)(bs.getCenterX() - (double)((float)this.favIcon.getWidth() / 2.0f)), (int)(bs.getCenterY() - (double)((float)this.favIcon.getHeight() / 2.0f)), null);
        } else {
            int min = Math.min(bs.width, bs.height);
            int r = min * 4 / 10;
            int rs = r - 1;
            graphics.setColor(ColorUtils.create(this.color == 0 ? -2007673515 : this.color));
            graphics.drawOval(min / 2, min / 2, r, r);
            graphics.setColor(ColorUtils.create(this.color == 0 ? 1437252556 : this.color));
            graphics.drawOval(min / 2, min / 2, rs, rs);
            canvas.drawImage(this.listDrawable, this.listDrawable_Bounds.x, this.listDrawable_Bounds.y, this.listDrawable_Bounds.width, this.listDrawable_Bounds.height, null);
        }
        graphics.dispose();
    }

    public void drawBitmapInCenter(Graphics2D canvas, int x, int y) {
        int dx = x - this.getIntrinsicWidth() / 2;
        int dy = y - this.getIntrinsicHeight() / 2;
        canvas.translate(dx, dy);
        this.draw(canvas);
        canvas.translate(-dx, -dy);
    }

    public void drawBitmapInCenter(Graphics2D canvas, float x, float y) {
        float dx = x - (float)this.getIntrinsicWidth() / 2.0f;
        float dy = y - (float)this.getIntrinsicHeight() / 2.0f;
        canvas.translate(dx, dy);
        this.draw(canvas);
        canvas.translate(-dx, -dy);
    }

    @Override
    public int getOpacity() {
        return 0;
    }

    @Override
    public void setAlpha(int alpha) {
        Color origC = this.paintBackground_Composite.getColor();
        Color newColor = new Color(origC.getRed(), origC.getGreen(), origC.getBlue(), alpha);
        this.paintBackground_Composite.setColor(newColor);
    }

    @Override
    public void setColorFilter(Composite cf) {
        this.paintIcon_Composite = (PorterDuffMultiplyFilter)cf;
    }

    public static FavoriteImageDrawable getOrCreate(OsmWindow a, int color2, boolean withShadow) {
        int hash = ((color2 |= 0xFF000000) << 2) + (withShadow ? 1 : 0);
        FavoriteImageDrawable drawable2 = cache.get(hash);
        if (drawable2 == null) {
            drawable2 = new FavoriteImageDrawable(a, color2, withShadow);
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            cache.put(hash, drawable2);
        }
        return drawable2;
    }
}

