import { IrcAction } from "./IrcAction";
import { Intent, MediaProxy } from "matrix-appservice-bridge";
export declare enum ActionType {
    Audio = "audio",
    Command = "command",
    Emote = "emote",
    File = "file",
    Image = "image",
    Message = "message",
    Notice = "notice",
    Topic = "topic",
    Video = "video"
}
export interface MatrixMessageEvent {
    type: string;
    sender: string;
    room_id: string;
    event_id: string;
    content: {
        "m.relates_to"?: {
            "m.in_reply_to"?: {
                event_id: string;
            };
            "rel_type"?: string;
            "event_id": string;
        };
        "m.new_content"?: {
            body: string;
            msgtype: string;
        };
        body?: string;
        topic?: string;
        format?: string;
        formatted_body?: string;
        msgtype: string;
        url?: string;
        info?: {
            size: number;
        };
    };
    origin_server_ts: number;
}
export declare class MatrixAction {
    readonly type: ActionType;
    text: string | null;
    htmlText: string | null;
    readonly ts: number;
    replyEvent?: string | undefined;
    private mediaProxy?;
    constructor(type: ActionType, text?: string | null, htmlText?: string | null, ts?: number, replyEvent?: string | undefined, mediaProxy?: MediaProxy | undefined);
    get msgType(): string | undefined;
    formatMentions(nickUserIdMap: Map<string, string>, intent: Intent): Promise<void>;
    static fromEvent(event: MatrixMessageEvent, mediaProxy: MediaProxy, filename?: string): Promise<MatrixAction>;
    static fromIrcAction(ircAction: IrcAction): MatrixAction | null;
}
